/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.ListDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ServerUsageDialog
extends JDialog {
    private JFrame parent;
    private ArrayList<TangoClass> tangoClasses = new ArrayList();
    private ArrayList<Domain> deviceDomains = new ArrayList();
    private ArrayList<Domain> serverDomains = new ArrayList();
    private int nbServers;
    private String wildcard;
    private static final int ByDevice = 0;
    private static final int ByServer = 1;
    private JTextArea textArea;
    private JLabel titleLabel;

    public ServerUsageDialog(JFrame parent) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.displayServerUsage();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void displayServerUsage() throws DevFailed {
        String[] servers = ApiUtil.get_db_obj().get_server_name_list();
        ListDialog dialog = new ListDialog(this.parent, "Servers in " + ApiUtil.getTangoHost(), servers);
        this.wildcard = dialog.showDialog();
        if (this.wildcard == null) {
            this.doClose();
            return;
        }
        this.wildcard = this.wildcard + "/*";
        this.titleLabel.setText(this.wildcard);
        this.tangoClasses.clear();
        this.deviceDomains.clear();
        this.serverDomains.clear();
        String[] serverNames = ApiUtil.get_db_obj().get_server_list(this.wildcard);
        this.nbServers = serverNames.length;
        for (String serverName : serverNames) {
            this.fillTangoClasses(serverName);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.textArea.setText(this.toString());
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton anotherBtn = new JButton();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServerUsageDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        anotherBtn.setText("Another Server");
        anotherBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerUsageDialog.this.anotherBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(anotherBtn);
        jLabel1.setText("                              ");
        bottomPanel.add(jLabel1);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerUsageDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        jScrollPane1.setPreferredSize(new Dimension(400, 500));
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        jScrollPane1.setViewportView(this.textArea);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void anotherBtnActionPerformed(ActionEvent evt) {
        try {
            this.displayServerUsage();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void fillTangoClasses(String serverName) throws DevFailed {
        DbServer server = new DbServer(serverName);
        String[] class_dev = server.get_device_class_list();
        boolean doneForServer = false;
        for (int i = 0; i < class_dev.length; i += 2) {
            String deviceName = class_dev[i];
            String className = class_dev[i + 1];
            if (className.equals("DServer")) continue;
            ArrayList _class = null;
            for (TangoClass tc : this.tangoClasses) {
                if (!tc.name.toLowerCase().equals(className.toLowerCase())) continue;
                _class = tc;
            }
            if (_class == null) {
                _class = new TangoClass(className);
                this.tangoClasses.add((TangoClass)_class);
            }
            _class.add(deviceName);
            this.fillDomains(deviceName, 0);
            if (doneForServer) continue;
            this.fillDomains(deviceName, 1);
            doneForServer = true;
        }
    }

    private void fillDomains(String deviceName, int target) throws DevFailed {
        ArrayList domain = null;
        String domainName = deviceName.substring(0, deviceName.indexOf("/"));
        ArrayList<Domain> list = target == 0 ? this.deviceDomains : this.serverDomains;
        for (Domain d : list) {
            if (!d.name.toLowerCase().equals(domainName.toLowerCase())) continue;
            domain = d;
        }
        if (domain == null) {
            domain = new Domain(domainName);
            list.add((Domain)domain);
        }
        domain.add(deviceName);
    }

    @Override
    public String toString() {
        int nbDevices = 0;
        StringBuffer sb = new StringBuffer();
        sb.append(this.wildcard).append("\n");
        sb.append("\n=====================================\n");
        for (TangoClass tangoClass : this.tangoClasses) {
            sb.append(tangoClass);
            nbDevices += tangoClass.size();
        }
        sb.append("\n=====================================\n");
        for (int i = 0; i < this.deviceDomains.size() && i < this.serverDomains.size(); ++i) {
            sb.append("Domain ").append(this.deviceDomains.get((int)i).name).append(":\t");
            sb.append(this.deviceDomains.get(i).size()).append(" devices\t");
            sb.append(this.serverDomains.get(i).size()).append(" servers\n");
        }
        sb.append("\n=====================================\n");
        sb.append(this.nbServers).append("\tservers\n");
        sb.append(nbDevices).append("\tdevices\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            new ServerUsageDialog(null).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    class TangoClass
    extends ArrayList<String> {
        String name;

        TangoClass(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("Class " + this.name + ":\t");
            sb.append(this.size()).append(" devices\n");
            return sb.toString();
        }
    }

    class Domain
    extends ArrayList<String> {
        String name;

        Domain(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("Domain " + this.name + ":\t");
            sb.append(this.size()).append(" devices\n");
            return sb.toString();
        }
    }
}

