/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.DevPollStatus;
import admin.astor.tools.PolledElement;
import admin.astor.tools.PoolThreadsTree;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PollingProfiler
extends JDialog
implements IJLChartListener,
ComponentListener {
    private JLChart chart = new JLChart();
    private JLAxis y_axis;
    private JLAxis x_axis;
    private JLDataView[] data = null;
    private long now;
    private String[] deviceNames;
    private DevPollStatus poll_status;
    private Component parent = null;
    private Timer timer = null;
    private int timer_period = 2;
    private boolean update_chart = true;
    private JLabel late_label;
    private JLabel early_label;
    private PollingInfo poll_info;
    private String title;
    private int display_mode = 2;
    private JCheckBoxMenuItem[] check_box;
    private static final int HISTORY = 0;
    private static final int POLL_DRIFT = 1;
    private static final int DURATION = 2;
    private static final int NB_CHECK_BOX = 3;
    private boolean titleDisplayed = false;
    private JRadioButton autoBtn;
    private JLabel titleLabel;
    private JButton updateBtn;

    public PollingProfiler(JDialog parent, String devname) {
        super((Dialog)parent, false);
        this.parent = parent;
        this.realConstructor(new String[]{devname});
    }

    public PollingProfiler(JFrame parent, String devname) {
        super((Frame)parent, false);
        this.parent = parent;
        this.realConstructor(new String[]{devname});
    }

    public PollingProfiler(JDialog parent, String[] devnames) {
        super((Dialog)parent, false);
        this.parent = parent;
        this.realConstructor(devnames);
    }

    public PollingProfiler(JFrame parent, String[] devnames) {
        super((Frame)parent, false);
        this.parent = parent;
        this.realConstructor(devnames);
    }

    private void realConstructor(String[] deviceNames) {
        this.deviceNames = deviceNames;
        this.initComponents();
        this.initOwnComponents();
        this.buildPopupMenu();
        this.customizeAxis();
        this.updateData();
        this.titleLabel.setVisible(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void buildPopupMenu() {
        this.chart.addMenuItem(new JMenuItem("-------------------------"));
        this.check_box = new JCheckBoxMenuItem[3];
        this.check_box[0] = new JCheckBoxMenuItem("History");
        this.check_box[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[0]);
        this.check_box[1] = new JCheckBoxMenuItem("Polling Drift");
        this.check_box[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[1]);
        this.check_box[2] = new JCheckBoxMenuItem("Duration");
        this.check_box[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[2]);
        JMenuItem jmi = new JMenuItem("Polling Info");
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem(jmi);
        this.check_box[this.display_mode].setSelected(true);
    }

    private void menuActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = 0;
        if (obj instanceof JCheckBoxMenuItem) {
            for (int i = 0; i < this.check_box.length; ++i) {
                if (this.check_box[i] == obj) {
                    cmdidx = i;
                    this.check_box[i].setSelected(true);
                    continue;
                }
                this.check_box[i].setSelected(false);
            }
            this.display_mode = cmdidx;
            this.customizeAxis();
            this.updateCurves();
            this.manageLabels();
        } else {
            this.poll_info.setVisible(true);
        }
    }

    private void customizeAxis() {
        this.x_axis.setPosition(4);
        if (this.display_mode == 0) {
            this.chart.setHeader(this.title + " (History)");
            this.x_axis.setAutoScale(false);
            this.x_axis.setName("Time");
            this.x_axis.setAnnotation(1);
            this.x_axis.setLabelFormat(0);
            this.y_axis.setAutoScale(false);
            this.y_axis.setName("T0");
            this.late_label.setVisible(false);
            this.early_label.setVisible(false);
        } else {
            this.x_axis.setAutoScale(false);
            this.x_axis.setName("Attributes");
            this.x_axis.setAnnotation(2);
            this.x_axis.setLabelFormat(3);
            if (this.display_mode == 1) {
                this.chart.setHeader(this.title + " (Drift)");
                this.y_axis.setName("Polling Drift (ms)");
                this.late_label.setVisible(true);
                this.early_label.setVisible(true);
            } else if (this.display_mode == 2) {
                this.chart.setHeader(this.title + " (Duration)");
                this.y_axis.setName("Duration (ms)");
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
                this.y_axis.setAutoScale(true);
            }
        }
    }

    private void manageLabels() {
        switch (this.display_mode) {
            case 0: {
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
                break;
            }
            case 1: {
                int w = this.early_label.getPreferredSize().width;
                int h = this.early_label.getPreferredSize().height;
                int h_chart = this.chart.getHeight();
                this.early_label.setBounds(24, h_chart - 20, w, h);
                this.late_label.setVisible(true);
                this.early_label.setVisible(true);
                break;
            }
            case 2: {
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
            }
        }
    }

    private void initOwnComponents() {
        this.y_axis = this.chart.getY2Axis();
        this.x_axis = this.chart.getXAxis();
        this.chart.setBackground(Color.white);
        this.chart.setChartBackground(Color.lightGray);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setLabelVisible(true);
        this.chart.setLabelFont(new Font("Dialog", 1, 12));
        this.x_axis.setGridVisible(true);
        this.chart.setPreferredSize(new Dimension(850, 400));
        this.chart.setJLChartListener((IJLChartListener)this);
        this.chart.setLabelPlacement(2);
        this.getContentPane().add((Component)this.chart, "Center");
        this.chart.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PollingProfiler.this.myMouseReleased(evt);
            }
        });
        this.title = "Polling on:  ";
        if (this.deviceNames.length == 1) {
            this.title = this.title + this.deviceNames[0];
        } else {
            try {
                String adm = new DeviceProxy(this.deviceNames[0]).adm_name();
                this.title = this.title + adm.substring(adm.indexOf(47) + 1);
            }
            catch (DevFailed e) {
                this.title = this.title + this.deviceNames[0];
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
        this.chart.setHeader(this.title);
        this.late_label = new JLabel("Polling Late");
        this.late_label.setFont(new Font("Dialog", 1, 14));
        this.late_label.setIcon(Utils.getInstance().getIcon("up.gif"));
        this.late_label.setVisible(false);
        this.chart.add((Component)this.late_label);
        int w = this.late_label.getPreferredSize().width;
        int h = this.late_label.getPreferredSize().height;
        this.late_label.setBounds(24, 10, w, h);
        this.early_label = new JLabel("Polling Early");
        this.early_label.setFont(new Font("Dialog", 1, 14));
        this.early_label.setIcon(Utils.getInstance().getIcon("down.gif"));
        this.early_label.setVisible(false);
        this.chart.add((Component)this.early_label);
        this.poll_info = new PollingInfo(this);
        this.chart.addComponentListener((ComponentListener)this);
    }

    private void myMouseReleased(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) != 0) {
            this.update_chart = true;
            this.doRepaint();
        }
    }

    private void displayTitle(int nbAttributes) throws DevFailed {
        String adminDevice = new DeviceProxy(this.deviceNames[0]).adm_name();
        int nbThreads = new PoolThreadsTree(adminDevice).getNbThreads();
        this.setTitle(Integer.toString(nbAttributes) + " elements polled by " + nbThreads + " threads");
        this.titleDisplayed = true;
    }

    private void updateData() {
        this.now = System.currentTimeMillis();
        try {
            this.poll_status = new DevPollStatus(this.deviceNames);
            if (!this.titleDisplayed) {
                this.displayTitle(this.poll_status.size());
            }
            this.updateCurves();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void manageDataViews(int nb) {
        if (this.data != null && nb != this.data.length) {
            for (JLDataView datum : this.data) {
                datum.reset();
                this.y_axis.removeDataView(datum);
            }
            this.data = null;
            this.initOwnComponents();
        }
        if (this.data != null) {
            for (JLDataView datum : this.data) {
                datum.reset();
            }
        } else {
            this.data = new JLDataView[nb];
            AstorUtil util = AstorUtil.getInstance();
            util.initColors(nb);
            for (int i = 0; i < nb; ++i) {
                this.data[i] = new JLDataView();
                this.data[i].setColor(util.getNewColor());
                this.data[i].setName(((PolledElement)this.poll_status.get((int)i)).name);
                this.data[i].setLabelVisible(true);
                this.y_axis.addDataView(this.data[i]);
            }
        }
        if (this.display_mode == 0) {
            for (int i = 0; i < nb; ++i) {
                this.data[i].setViewType(0);
            }
        } else {
            for (int i = 0; i < nb; ++i) {
                this.data[i].setViewType(1);
                this.data[i].setFillMethod(1);
                this.data[i].setFill(true);
                this.data[i].setFillStyle(1);
                this.data[i].setFillColor(this.data[i].getColor());
            }
        }
    }

    private void updateCurves() {
        int nb = this.poll_status.size();
        if (nb == 0) {
            return;
        }
        this.manageDataViews(nb);
        double xMin = this.now;
        double[] yMinMax = new double[]{0.0, 0.0};
        int i = 0;
        for (PolledElement polledElement : this.poll_status) {
            switch (this.display_mode) {
                case 0: {
                    xMin = this.updateHistory(polledElement, i, xMin);
                    break;
                }
                case 1: {
                    yMinMax = this.updateDrift(polledElement, i, yMinMax);
                    break;
                }
                case 2: {
                    double y = polledElement.polled ? polledElement.reading_time : 0.0;
                    this.data[i].add((double)i, y);
                }
            }
            ++i;
        }
        this.manageMinMax(yMinMax);
        this.poll_info.display();
        this.doRepaint();
    }

    private double[] updateDrift(PolledElement polledElement, int i, double[] yMinMax) {
        double y;
        if (polledElement.polled) {
            if (polledElement.realPeriods.length == 0) {
                System.out.println("pe.realPeriods.length=0");
                y = 0.0;
            } else {
                y = polledElement.realPeriods[0] - polledElement.period;
            }
        } else {
            y = 0.0;
        }
        this.data[i].add((double)i, y);
        if (y < yMinMax[0]) {
            yMinMax[0] = y;
        }
        if (y > yMinMax[1]) {
            yMinMax[1] = y;
        }
        return yMinMax;
    }

    private double updateHistory(PolledElement polledElement, int i, double xMin) {
        double x = this.now - (long)polledElement.last_update;
        double y = 1.0 + 0.1 * (double)i;
        this.data[i].add(x, 0.0);
        this.data[i].add(x, y);
        this.data[i].add(x - polledElement.reading_time, y);
        this.data[i].add(x - polledElement.reading_time, 0.0);
        if (x < xMin) {
            xMin = x;
        }
        for (int real_period : polledElement.realPeriods) {
            this.data[i].add(x -= (double)real_period, 0.0);
            this.data[i].add(x, y);
            this.data[i].add(x - polledElement.reading_time, y);
            this.data[i].add(x - polledElement.reading_time, 0.0);
            if (!(x < xMin)) continue;
            xMin = x;
        }
        return xMin;
    }

    private void manageMinMax(double[] yMinMax) {
        int nb = this.poll_status.size();
        double xmin = this.now;
        switch (this.display_mode) {
            case 0: {
                this.x_axis.setMinimum(xmin -= 1000.0);
                this.x_axis.setMaximum((double)this.now);
                this.y_axis.setMinimum(0.0);
                this.y_axis.setMaximum(0.1 * (double)nb + 1.5);
                break;
            }
            case 1: {
                this.x_axis.setMinimum(-0.05);
                this.x_axis.setMaximum((double)nb - 0.5);
                if (yMinMax[0] > -10.0 && yMinMax[1] < 10.0) {
                    this.y_axis.setAutoScale(false);
                    this.y_axis.setMinimum(-10.0);
                    this.y_axis.setMaximum(10.0);
                    break;
                }
                this.y_axis.setAutoScale(true);
                break;
            }
            case 2: {
                this.x_axis.setMinimum(-0.05);
                this.x_axis.setMaximum((double)nb - 0.5);
            }
        }
    }

    private void doRepaint() {
        if (this.update_chart) {
            this.chart.repaint();
        }
    }

    public String[] clickOnChart(JLChartEvent event) {
        String[] retVal;
        this.update_chart = false;
        JLDataView dv = event.getDataView();
        PolledElement pe = null;
        for (int i = 0; pe == null && i < this.poll_status.size(); ++i) {
            if (!dv.getName().equals(((PolledElement)this.poll_status.get((int)i)).name)) continue;
            pe = (PolledElement)this.poll_status.get(i);
        }
        int idx = event.getDataViewIndex();
        DataList dl = dv.getData();
        for (int i = 0; i < idx; ++i) {
            dl = dl.next;
        }
        if (pe == null) {
            return new String[0];
        }
        String[] s1 = pe.getInfo();
        int nblines = s1.length;
        if (this.display_mode == 0) {
            retVal = new String[nblines + 2];
            System.arraycopy(s1, 0, retVal, 0, nblines);
            retVal[nblines] = "";
            retVal[nblines + 1] = "T0 - " + (int)((double)this.now - dl.x) + " ms";
        } else {
            retVal = s1;
        }
        return retVal;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.autoBtn = new JRadioButton();
        this.updateBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PollingProfiler.this.closeDialog(evt);
            }
        });
        this.autoBtn.setText("Auto Update");
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.autoBtnActionPerformed(evt);
            }
        });
        jPanel1.add(this.autoBtn);
        this.updateBtn.setText("Update");
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.updateBtnActionPerformed(evt);
            }
        });
        jPanel1.add(this.updateBtn);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void autoBtnActionPerformed(ActionEvent evt) {
        if (this.autoBtn.getSelectedObjects() != null) {
            String strval = "" + this.timer_period;
            if ((strval = (String)JOptionPane.showInputDialog(this, "Reading period (seconds)  ?", "Reading period", 1, null, null, strval)) == null) {
                this.autoBtn.setSelected(false);
                return;
            }
            try {
                this.timer_period = Integer.parseInt(strval);
            }
            catch (NumberFormatException e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
                ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
                this.autoBtn.setSelected(false);
                return;
            }
            this.updateData();
            if (this.timer == null) {
                ActionListener taskPerformer = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PollingProfiler.this.updateData();
                    }
                };
                this.timer = new Timer(1000 * this.timer_period, taskPerformer);
            } else {
                this.timer.setDelay(1000 * this.timer_period);
            }
            this.timer.start();
            this.updateBtn.setEnabled(false);
        } else if (this.timer != null) {
            this.timer.stop();
            this.updateBtn.setEnabled(true);
        }
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        this.updateData();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.parent != null && this.parent.isVisible()) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
        this.manageLabels();
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        this.manageLabels();
    }

    @Override
    public void componentResized(ComponentEvent evt) {
        this.manageLabels();
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
    }

    static int getNbFields(String[] args) {
        if (args.length == 0) {
            return 0;
        }
        StringTokenizer stk = new StringTokenizer(args[0], "/");
        return stk.countTokens();
    }

    static String[] getDeviceNames(String servname) throws DevFailed {
        DeviceData argout = new DeviceProxy("dserver/" + servname).command_inout("QueryDevice");
        String[] devnames = argout.extractStringArray();
        for (int i = 0; i < devnames.length; ++i) {
            devnames[i] = devnames[i].substring(devnames[i].indexOf("::") + 2);
            System.out.println(devnames[i]);
        }
        return devnames;
    }

    public static void main(String[] args) {
        try {
            switch (PollingProfiler.getNbFields(args)) {
                case 3: {
                    new PollingProfiler(new JDialog(), args[0]).setVisible(true);
                    break;
                }
                case 2: {
                    String[] devnames = PollingProfiler.getDeviceNames(args[0]);
                    new PollingProfiler(new JDialog(), devnames).setVisible(true);
                    break;
                }
                default: {
                    Except.throw_exception((String)"BAD_ARGUMENT", (String)"Server or Device name  ?", (String)"PollingProfiler.main()");
                    break;
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }

    public class PollingInfo
    extends JDialog {
        private JTextArea textArea;

        public PollingInfo(JDialog parent) {
            super((Dialog)parent, false);
            JScrollPane jsp = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("Dialog", 1, 14));
            this.textArea.setEditable(false);
            jsp.setViewportView(this.textArea);
            jsp.setPreferredSize(new Dimension(500, 250));
            this.getContentPane().add((Component)jsp, "Center");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private String formatValue(double val, int nb_dec) {
            String str = "" + val;
            int idx = str.indexOf(46);
            if (idx > 0 && str.substring(idx + 1).length() > nb_dec) {
                str = str.substring(0, nb_dec + idx + 1);
            }
            return str;
        }

        private void display() {
            int nb_polled = PollingProfiler.this.poll_status.polledCount();
            int nb_triggered = PollingProfiler.this.poll_status.triggeredCount();
            StringBuilder sb = new StringBuilder("  ");
            if (nb_triggered == 0) {
                sb.append(nb_polled).append(" polled attributes.\n\n");
            } else if (nb_polled == 0) {
                sb.append(nb_triggered).append(" triggered attributes.\n\n");
            } else {
                sb.append(nb_polled).append(" polled attributes  and  ");
                sb.append(nb_triggered).append(" triggered attributes.\n\n");
            }
            sb.append(this.getDriftStatus());
            sb.append(this.getDurationStatus());
            sb.append(this.getLastUpdate());
            this.textArea.setText(sb.toString());
        }

        private String getDurationStatus() {
            double sum = 0.0;
            double max = 0.0;
            String maxName = null;
            for (PolledElement polledElement : PollingProfiler.this.poll_status) {
                if (polledElement.realPeriods.length <= 0 || !polledElement.polled) continue;
                if (polledElement.reading_time > max) {
                    max = polledElement.reading_time;
                    maxName = polledElement.name;
                }
                sum += polledElement.reading_time;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("Duration :\n");
            sb.append("    Maxi : ").append(this.formatValue(max, 2)).append(" ms");
            if (maxName != null) {
                sb.append("\ton ").append(maxName);
            }
            sb.append("\n");
            sb.append("    Total: ").append(this.formatValue(sum, 2)).append(" ms \n");
            return sb.toString();
        }

        private String getDriftStatus() {
            boolean available = false;
            int late = 0;
            int early = 0;
            String lateName = null;
            String earlyName = null;
            for (PolledElement polledElement : PollingProfiler.this.poll_status) {
                if (polledElement.realPeriods.length <= 0 || !polledElement.polled) continue;
                int drift = polledElement.realPeriods[0] - polledElement.period;
                if (drift > 0) {
                    if (drift > late) {
                        late = drift;
                        lateName = polledElement.name;
                    }
                } else if (drift < early) {
                    early = drift;
                    earlyName = polledElement.name;
                }
                available = true;
            }
            StringBuilder sb = new StringBuilder();
            if (available) {
                sb.append("Drift maxi :\n");
                sb.append("    - Late : ").append(late).append(" ms ");
                if (lateName != null) {
                    sb.append("\ton ").append(lateName);
                }
                sb.append("\n");
                sb.append("    - Early: ").append(early).append(" ms ");
                if (earlyName != null) {
                    sb.append("\ton ").append(earlyName);
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        private String getLastUpdate() {
            int max = 0;
            String time = "";
            String maxName = null;
            for (PolledElement polledElement : PollingProfiler.this.poll_status) {
                if (polledElement.realPeriods.length <= 0 || polledElement.last_update <= max) continue;
                max = polledElement.last_update;
                time = polledElement.last_update_str;
                maxName = polledElement.name;
            }
            StringBuilder sb = new StringBuilder();
            if (maxName != null) {
                sb.append("\n");
                sb.append("Last update max\ton ").append(maxName);
                sb.append("\n    since ").append(time);
            }
            return sb.toString();
        }
    }
}

