/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PingHosts {
    private ArrayList<DevState> states = new ArrayList();
    private String[] hosts;

    public PingHosts(String[] hosts) throws DevFailed {
        this.hosts = hosts;
        ArrayList<PingThread> threads = new ArrayList<PingThread>();
        for (String host : hosts) {
            threads.add(new PingThread(host));
        }
        for (PingThread thread : threads) {
            thread.start();
        }
        try {
            if (AstorUtil.osIsUnix()) {
                Thread.sleep(2000L);
            } else {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (PingThread thread : threads) {
            if (thread.hostAlive()) {
                this.states.add(DevState.ON);
            } else {
                this.states.add(DevState.FAULT);
            }
            thread.interrupt();
        }
    }

    public ArrayList<DevState> getStates() throws DevFailed {
        return this.states;
    }

    public ArrayList<String> getRunning() throws DevFailed {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < this.hosts.length && i < this.states.size(); ++i) {
            if (this.states.get(i) != DevState.ON) continue;
            v.add(this.hosts[i]);
        }
        return v;
    }

    public ArrayList<String> getStopped() throws DevFailed {
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < this.hosts.length && i < this.states.size(); ++i) {
            if (this.states.get(i) != DevState.FAULT) continue;
            v.add(this.hosts[i]);
        }
        return v;
    }

    public static void main(String[] args) {
        try {
            String[] hosts = AstorUtil.getInstance().getHostControlledList();
            int alives = 0;
            int deads = 0;
            long t0 = System.currentTimeMillis();
            PingHosts client = new PingHosts(hosts);
            ArrayList<DevState> states = client.getStates();
            for (int i = 0; i < hosts.length && i < states.size(); ++i) {
                if (states.get(i) == DevState.FAULT) {
                    ++deads;
                } else {
                    ++alives;
                }
                System.out.println(hosts[i] + ":\t" + (states.get(i) == DevState.FAULT ? "NOT " : "") + " alive");
            }
            long t1 = System.currentTimeMillis();
            System.out.println("elapsed time: " + (t1 - t0) + " ms");
            System.out.println(alives + " hosts alive   and  " + deads + " hosts dead");
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private class PingThread
    extends Thread {
        private String hostName;
        private boolean alive = false;

        private PingThread(String hostName) {
            this.hostName = hostName;
        }

        private boolean hostAlive() {
            return this.alive;
        }

        @Override
        public void run() {
            try {
                String str = this.executeShellCmdOneLine("ping " + this.hostName);
                this.alive = AstorUtil.osIsUnix() ? str.toLowerCase().indexOf("unreachable") < 0 : str.toLowerCase().indexOf("unreachable") < 0 && str.length() > 0 && str.indexOf("timed out") < 0;
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
        }

        public String executeShellCmdOneLine(String cmd) throws DevFailed {
            StringBuffer sb = new StringBuffer();
            try {
                String str;
                Process proc = Runtime.getRuntime().exec(cmd);
                InputStream istr = proc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(istr));
                int cnt = 0;
                while (cnt < 2 && (str = br.readLine()) != null) {
                    if ((str = str.trim()).length() <= 0) continue;
                    sb.append(str.trim()).append("\n");
                    ++cnt;
                }
                proc.destroy();
            }
            catch (Exception e) {
                Except.throw_exception((String)e.toString(), (String)("The shell command\n" + cmd + "\nHas failed"), (String)"Utils.executeShellCmd()");
            }
            return sb.toString();
        }
    }
}

