/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.PolledElement;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;

public class DevPollStatus
extends ArrayList<PolledElement> {
    private DeviceProxy dev;
    private static final boolean FULL_NAME = true;
    private static final boolean ATTR_NAME = false;

    public DevPollStatus(String devname) throws DevFailed {
        this.dev = new DeviceProxy(devname).get_adm_dev();
        this.readData(devname, false);
    }

    public DevPollStatus(String[] devnames) throws DevFailed {
        boolean full_name = true;
        if (devnames.length < 2) {
            full_name = false;
        }
        for (String devname : devnames) {
            this.dev = new DeviceProxy(devname).get_adm_dev();
            this.readData(this.removeTangoHostIfAny(devname), full_name);
        }
    }

    private String removeTangoHostIfAny(String deviceName) {
        String tangoHeader = "tango://";
        if (deviceName.startsWith(tangoHeader)) {
            deviceName = deviceName.substring(tangoHeader.length());
            deviceName = deviceName.substring(deviceName.indexOf(47) + 1);
        }
        return deviceName;
    }

    private void readData(String devname, boolean full_name) throws DevFailed {
        String[] str;
        DeviceData argin = new DeviceData();
        argin.insert(devname);
        DeviceData argout = this.dev.command_inout("DevPollStatus", argin);
        for (String s : str = argout.extractStringArray()) {
            PolledElement pe = new PolledElement(devname, s);
            boolean found = false;
            for (int j = 0; !found && j < this.size(); ++j) {
                found = full_name ? ((PolledElement)this.get((int)j)).name.toLowerCase().equals(devname + "/" + pe.name.toLowerCase()) : ((PolledElement)this.get((int)j)).name.toLowerCase().equals(pe.name.toLowerCase());
            }
            if (found) continue;
            if (full_name) {
                pe.name = devname + "/" + pe.name;
            }
            this.add(pe);
        }
    }

    public int polledCount() {
        int cnt = 0;
        for (PolledElement polledElement : this) {
            if (!polledElement.polled) continue;
            ++cnt;
        }
        return cnt;
    }

    public int triggeredCount() {
        int cnt = 0;
        for (PolledElement polledElement : this) {
            if (polledElement.polled) continue;
            ++cnt;
        }
        return cnt;
    }

    static void displaySyntax() {
        System.out.println("device name ?");
        System.exit(1);
    }

    public static void main(String[] args) {
        String devname = null;
        if (args.length > 0) {
            devname = args[0];
        } else {
            DevPollStatus.displaySyntax();
        }
        try {
            DevPollStatus clients = new DevPollStatus(devname);
            for (PolledElement client : clients) {
                String[] infoArray;
                for (String info : infoArray = client.getInfo()) {
                    System.out.println(info);
                }
                System.out.println();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
            System.exit(1);
        }
        System.exit(0);
    }
}

