/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.ManagePollingDialog;
import admin.astor.tools.DevBrowserTree;
import admin.astor.tools.EventsTable;
import admin.astor.tools.SubscribedSignal;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import jive.MultiLineToolTipUI;

public class DevBrowser
extends JFrame {
    private JFrame parent;
    private DevBrowserTree tree;
    private static EventsTable ev_table;
    private JMenuItem eventsDlgBtn;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JTextArea textArea;
    private JScrollPane treeScrollPane;
    private JMenu viewMenu;

    public DevBrowser(JFrame parent) {
        this.parent = parent;
        this.initComponents();
        try {
            this.tree = new DevBrowserTree(this);
            this.treeScrollPane.setViewportView(this.tree);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
        this.customizeMenu();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        MultiLineToolTipUI.initialize();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.viewMenu.setMnemonic('V');
        this.eventsDlgBtn.setMnemonic('E');
        this.eventsDlgBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
    }

    void displayEventProperties(String attname) {
        this.tree.displayEventProperties(attname);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JScrollPane textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.eventsDlgBtn = new JMenuItem();
        JMenuItem astorBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DevBrowser.this.exitForm(evt);
            }
        });
        jPanel1.setLayout(new BorderLayout());
        textScrollPane.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        textScrollPane.setViewportView(this.textArea);
        jPanel1.add((Component)textScrollPane, "Center");
        this.treeScrollPane.setPreferredSize(new Dimension(350, 400));
        jPanel1.add((Component)this.treeScrollPane, "West");
        this.getContentPane().add((Component)jPanel1, "Center");
        this.fileMenu.setText("File");
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.eventsDlgBtn.setText("Events Panel");
        this.eventsDlgBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.eventsDlgBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.eventsDlgBtn);
        astorBtn.setText("Astor Panel");
        astorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevBrowser.this.astorBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(astorBtn);
        jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void astorBtnActionPerformed(ActionEvent evt) {
        if (this.parent instanceof Astor) {
            Astor astor = (Astor)this.parent;
            astor.setVisible(true);
        }
    }

    private void eventsDlgBtnActionPerformed(ActionEvent evt) {
        try {
            if (ev_table == null) {
                ev_table = new EventsTable(this);
            }
            ev_table.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            if (this.parent.isVisible()) {
                this.dispose();
            } else {
                ((Astor)this.parent).doExit();
            }
        } else {
            this.dispose();
        }
    }

    void setText(String str) {
        this.textArea.setText(str);
        this.textArea.setCaretPosition(0);
    }

    void add(String signame, int mode) {
        if (ev_table == null) {
            try {
                ev_table = new EventsTable(this);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                return;
            }
        }
        ev_table.add(signame, mode);
    }

    void displayHostPanel(String devname) {
        if (this.parent instanceof Astor) {
            Astor astor = (Astor)this.parent;
            astor.tree.displayHostInfo(devname);
        }
    }

    void managePolling(SubscribedSignal sig) {
        try {
            new ManagePollingDialog(this, sig.devname, sig.attname).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    void managePolling(String devname) {
        try {
            new ManagePollingDialog(this, devname, "").setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    void managePolling(DeviceProxy dev, String attname) {
        try {
            new ManagePollingDialog(this, dev.name(), attname).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    public static void main(String[] args) {
        try {
            Astor astor = new Astor();
            DevBrowser db = new DevBrowser(astor);
            db.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }
}

