/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoReleaseTree;
import admin.astor.tango_release.TangoServerReleaseList;
import admin.astor.tools.PopupHtml;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class TangoReleaseDialog
extends JDialog {
    private JFrame parent;
    private int retVal = 0;
    static final int byTango = 0;
    static final int byIDL = 1;
    private JPanel idlPanel;
    private JPanel tangoPanel;
    private JLabel titleLabel;

    public TangoReleaseDialog(JFrame parent) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        String[] hostList = AstorUtil.getInstance().getHostControlledList();
        ArrayList<String> serverList = new ArrayList<String>();
        for (String hostName : hostList) {
            System.out.println("Reading " + hostName);
            ArrayList<String> serverNames = this.getControlledServers(hostName);
            for (String server : serverNames) {
                serverList.add(server);
            }
        }
        System.out.println(serverList.size());
        String rootName = ApiUtil.getTangoHost();
        this.buildDialog(rootName, serverList);
    }

    public TangoReleaseDialog(JFrame parent, String hostName) {
        super((Frame)parent, false);
        this.parent = parent;
        this.buildDialog(hostName, this.getControlledServers(hostName));
    }

    public TangoReleaseDialog(JFrame parent, String rootName, ArrayList<String> serverNames) {
        super((Frame)parent, false);
        this.parent = parent;
        this.buildDialog(rootName, serverNames);
    }

    private void buildDialog(String rootName, ArrayList<String> serverNames) {
        AstorUtil.startSplash("Server Tango Releases");
        AstorUtil.increaseSplashProgress(5, "Initializing....");
        this.initComponents();
        this.initOwnComponents(rootName, serverNames);
        this.titleLabel.setText("Tango Release for Servers");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        AstorUtil.stopSplash();
    }

    private ArrayList<String> getControlledServers(String hostName) {
        ArrayList<String> controlledServers = new ArrayList<String>();
        try {
            String[] lines;
            DeviceAttribute attribute = new DeviceProxy("tango/admin/" + hostName).read_attribute("Servers");
            for (String line : lines = attribute.extractStringArray()) {
                StringTokenizer stringTokenizer = new StringTokenizer(line);
                String serverName = stringTokenizer.nextToken();
                controlledServers.add(serverName);
            }
            controlledServers.add("Starter/" + hostName);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return controlledServers;
    }

    private void initOwnComponents(String rootName, ArrayList<String> serverNames) {
        AstorUtil.increaseSplashProgress(1, "Check servers....");
        TangoServerReleaseList serverReleaseList = new TangoServerReleaseList(serverNames);
        rootName = rootName + "  (" + serverReleaseList.size() + " servers - " + serverReleaseList.nbClasses() + " classes)";
        AstorUtil.increaseSplashProgress(5, "Build trees....");
        TangoReleaseTree tangoTree = new TangoReleaseTree(this.parent, rootName, serverReleaseList, 0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(tangoTree);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        this.tangoPanel.add((Component)scrollPane, "Center");
        TangoReleaseTree idlTree = new TangoReleaseTree(this.parent, rootName, serverReleaseList, 1);
        scrollPane = new JScrollPane();
        scrollPane.setViewportView(idlTree);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        this.idlPanel.add((Component)scrollPane, "Center");
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton helpBtn = new JButton();
        JLabel dummyLbl = new JLabel();
        JButton cancelBtn = new JButton();
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        this.tangoPanel = new JPanel();
        this.idlPanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TangoReleaseDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        helpBtn.setText("Help");
        helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoReleaseDialog.this.helpBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(helpBtn);
        dummyLbl.setText("                       ");
        bottomPanel.add(dummyLbl);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoReleaseDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.tangoPanel.setLayout(new BorderLayout());
        jTabbedPane1.addTab("Tango Releases", this.tangoPanel);
        this.idlPanel.setLayout(new BorderLayout());
        jTabbedPane1.addTab("IDL Releases", this.idlPanel);
        this.getContentPane().add((Component)jTabbedPane1, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void helpBtnActionPerformed(ActionEvent evt) {
        URL url = this.getClass().getResource("TangoRelease.html");
        PopupHtml dialog = new PopupHtml(null);
        dialog.setLocation(this.getLocation());
        dialog.show(url, 850, 600);
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                if (args[0].equals("-test")) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("VacGaugeServer/sr_c1-pen");
                    list.add("VacGaugeServer/sr_c1-ip");
                    list.add("PLCvacuumValve/sr_c01");
                    list.add("Starter/l-c01-1");
                    list.add("TacoStarter/l-srrf-1");
                    new TangoReleaseDialog(null, "My Test", list).setVisible(true);
                } else {
                    new TangoReleaseDialog(null, args[0]).setVisible(true);
                }
            } else {
                new TangoReleaseDialog(null).setVisible(true);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
        }
    }
}

