/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class TangoClassRelease {
    String className;
    int idl = 0;
    String error = "";

    public TangoClassRelease(DbServer dbServer, String className) {
        this.className = className;
        try {
            String[] deviceNames = this.getDevices(dbServer, className);
            if (deviceNames.length > 0) {
                this.idl = new DeviceProxy(deviceNames[0]).get_idl_version();
            } else {
                this.error = "No device found for class " + className + " on server " + dbServer.name();
            }
        }
        catch (DevFailed e) {
            this.error = e.errors[0].desc;
        }
    }

    public String[] getDevices(DbServer dbServer, String className) throws DevFailed {
        return dbServer.get_device_name(className);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        sb.append(this.className).append(" (");
        if (this.idl > 0) {
            sb.append("idl=").append(this.idl);
        } else {
            sb.append(this.error);
        }
        sb.append(")");
        return sb.toString();
    }

    public static void main(String[] args) {
        String serverName = "VacGaugeServer/sr_c1-pen";
        String className = "VacGauge";
        if (args.length > 0) {
            className = args[0];
        }
        try {
            TangoClassRelease client = new TangoClassRelease(new DbServer(serverName), className);
            System.out.println(client);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

