/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.StarterStat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class Utils {
    private static final String percentageFormat = "%7.4f";

    public static String formatDuration(long ms) {
        double nbSec = (double)ms / 1000.0;
        return Utils.formatDuration(nbSec);
    }

    public static String formatDuration(double nbSeconds) {
        if (nbSeconds < 10.0) {
            String str = "" + nbSeconds;
            int idx = str.indexOf(46);
            if (idx > 0 && str.length() > idx + 3) {
                str = str.substring(0, idx + 3);
            }
            return str + " sec.";
        }
        int intDuration = (int)nbSeconds;
        if (nbSeconds < 60.0) {
            return "" + intDuration + " sec.";
        }
        if (intDuration < 3600) {
            int mn = intDuration / 60;
            int sec = intDuration - 60 * mn;
            return "" + mn + " mn " + (sec < 10 ? "0" : "") + sec + " sec.";
        }
        if (intDuration < 86400) {
            int h = intDuration / 3600;
            int mn = (intDuration -= h * 3600) / 60;
            int sec = intDuration - 60 * mn;
            return "" + h + " h " + (mn < 10 ? "0" : "") + mn + " mn " + (sec < 10 ? "0" : "") + sec + " sec.";
        }
        int days = intDuration / 86400;
        return "" + days + " day" + (days > 1 ? "s " : " ") + Utils.formatDuration((double)intDuration - (double)(days * 24 * 3600));
    }

    public static String formatPercentage(double ratio) {
        double d = 100.0 * ratio;
        return String.format(percentageFormat, d) + " %";
    }

    public static String formatDate(long ms) {
        StringTokenizer st = new StringTokenizer(new Date(ms).toString());
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        String month = (String)v.get(1);
        String day = (String)v.get(2);
        String time = (String)v.get(3);
        String year = (String)v.get(v.size() - 1);
        if (year.indexOf(41) > 0) {
            year = year.substring(0, year.indexOf(41));
        }
        return day + " " + month + " " + year + "  " + time;
    }

    public static StarterStat readHostStatistics(String hostName) {
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(hostName);
        ArrayList<StarterStat> stat = Utils.readHostStatistics(vs);
        if (stat.size() > 0) {
            return stat.get(0);
        }
        return null;
    }

    public static ArrayList<StarterStat> readHostStatistics(ArrayList<String> ctrlHosts) {
        if (ctrlHosts == null || ctrlHosts.size() == 0) {
            ctrlHosts = Utils.getHostControlledList(true);
        }
        int increment = 80 / ctrlHosts.size();
        ArrayList<StarterStat> stats = new ArrayList<StarterStat>();
        for (String host : ctrlHosts) {
            AstorUtil.increaseSplashProgress(increment, "Get statistics for " + host);
            stats.add(new StarterStat(host));
        }
        return stats;
    }

    public static ArrayList<String> getHostControlledList(boolean display) {
        if (display) {
            AstorUtil.increaseSplashProgress(5, "Get Controlled host list....");
        }
        ArrayList<String> ctrlHosts = new ArrayList<String>();
        String dbg = System.getProperty("ebugStat");
        if (dbg != null && dbg.equals("true")) {
            ctrlHosts.add("coral");
            ctrlHosts.add("esrflinux1-2");
            ctrlHosts.add("esrflinux1-1");
            return ctrlHosts;
        }
        try {
            String[] hosts = AstorUtil.getInstance().getHostControlledList();
            Database dbase = ApiUtil.get_db_obj();
            String[] excludedCollections = new String[]{};
            DbDatum data = dbase.get_property("Astor", "ExcludedCollectionsForStatistics");
            if (!data.is_empty()) {
                excludedCollections = data.extractStringArray();
            }
            for (String host : hosts) {
                DbDatum datum = new DeviceProxy("tango/admin/" + host).get_property("HostCollection");
                if (datum.is_empty()) continue;
                String collec = datum.extractString().toLowerCase();
                boolean found = false;
                for (String s : excludedCollections) {
                    if (!s.toLowerCase().equals(collec)) continue;
                    found = true;
                }
                if (found) continue;
                ctrlHosts.add(host);
            }
        }
        catch (DevFailed e) {
            if (display) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
            Except.print_exception((Exception)((Object)e));
        }
        return ctrlHosts;
    }

    public static String readFile(String filename) throws DevFailed {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            if (nb > 0) {
                str = Utils.takeOffWindowsChar(inStr);
            }
        }
        catch (Exception e) {
            Except.throw_exception((String)"READ_FAILED", (String)e.toString(), (String)"ParserTool.readFile()");
        }
        return str;
    }

    public static boolean osIsUnix() {
        String os = System.getProperty("os.name");
        return !os.toLowerCase().startsWith("windows");
    }

    private static String takeOffWindowsChar(byte[] b_in) {
        int nb = 0;
        for (byte b : b_in) {
            if (b == 13) continue;
            ++nb;
        }
        byte[] b_out = new byte[nb];
        int j = 0;
        for (int i = 0; i < b_in.length; ++i) {
            if (b_in[i] == 13) continue;
            b_out[j++] = b_in[i];
        }
        return new String(b_out);
    }

    private static String checkOsFormat(String code) {
        if (!Utils.osIsUnix()) {
            return Utils.setWindowsFileFormat(code);
        }
        return code;
    }

    public static String setWindowsFileFormat(String code) {
        byte[] b = new byte[]{13, 10};
        String lsp = new String(b);
        code = code.replaceAll("\n", lsp);
        return code;
    }

    public static void writeFile(String fileName, String code) throws DevFailed {
        try {
            code = Utils.checkOsFormat(code);
            FileOutputStream fidout = new FileOutputStream(fileName);
            fidout.write(code.getBytes());
            fidout.close();
            System.out.println(fileName + "  written");
        }
        catch (Exception e) {
            Except.throw_exception((String)"WRITE_FAILED", (String)e.toString(), (String)"ParserTool.readFile()");
        }
    }

    public static String parseXmlProperty(String code, String tag) throws DevFailed {
        int end;
        String tmpTag = tag + "=\"";
        int start = code.indexOf(tmpTag);
        if (start < 0) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)("Cannot parse '" + tag + "'  in:\n" + code), (String)"Utils.parseProperty()");
        }
        if ((end = code.indexOf(34, start += tmpTag.length())) < 0) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)("Cannot parse '" + tag + "'  in:\n" + code), (String)"Utils.parseProperty()");
        }
        return code.substring(start, end);
    }

    public static String strReplace(String text, String old_str, String new_str) {
        if (text == null) {
            return "";
        }
        int pos = 0;
        while ((pos = text.indexOf(old_str, pos)) >= 0) {
            text = text.substring(0, pos) + new_str + text.substring(pos + old_str.length());
            pos += new_str.length();
        }
        return text;
    }
}

