/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevState;
import java.util.StringTokenizer;

public class LogRecord {
    String name;
    DevState newState;
    long startedTime = -1L;
    long failedTime = -1L;
    long failedDuration = 0L;
    long runDuration = 0L;
    int autoRestart = 0;

    public LogRecord(String line) {
        StringTokenizer stk = new StringTokenizer(line, "\t");
        this.name = stk.nextToken();
        this.newState = this.getState(stk.nextToken());
        this.startedTime = this.getValue(stk.nextToken()) * 1000L;
        this.failedTime = stk.hasMoreTokens() ? this.getValue(stk.nextToken()) * 1000L : -1L;
        if (this.failedTime > 0L) {
            if (this.startedTime > this.failedTime) {
                this.failedDuration = this.startedTime - this.failedTime;
            } else if (this.newState == DevState.ON) {
                this.runDuration = this.failedTime - this.startedTime;
            }
        }
        if (this.newState == DevState.ON && stk.hasMoreTokens()) {
            String str = stk.nextToken();
            this.autoRestart = str.equals("true") ? 2 : 1;
        }
    }

    private long getValue(String str) {
        long val = -1L;
        try {
            val = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            System.err.println(e);
        }
        return val;
    }

    private DevState getState(String str) {
        if (str.equals("ON")) {
            return DevState.ON;
        }
        return DevState.FAULT;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name).append(":\t");
        if (this.newState == DevState.FAULT) {
            sb.append("Failed at   ").append(Utils.formatDate(this.failedTime));
        } else {
            sb.append("Start  at   ").append(Utils.formatDate(this.startedTime));
        }
        if (this.failedDuration > 0L) {
            sb.append("\tFailure ").append(Utils.formatDuration(this.failedDuration));
        }
        if (this.runDuration > 0L) {
            sb.append("\tAvailable ").append(Utils.formatDuration(this.runDuration));
        }
        return sb.toString();
    }
}

