/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.ctrl_system_info;

import admin.astor.ctrl_system_info.Monitor;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class ScanningThread
extends Thread {
    private ArrayList<String> hostNames;
    private ResultsStructure results = new ResultsStructure();
    private Monitor monitor;
    private static final int nbHostByJVM = 10;
    private static final String fileNameHeader = "CtrlSystemResults_";

    public ScanningThread(ArrayList<String> hostNames, Monitor monitor) {
        this.hostNames = hostNames;
        this.monitor = monitor;
        monitor.setProgressValue(0.05, "Starting to scan control system...");
    }

    public String getResults() {
        return this.results.toString() + "\n\n" + "Measurements done " + new Date();
    }

    private void startInAnotherJvm(String parameters) throws DevFailed, InterruptedException, IOException {
        String command = "java -DTANGO_HOST=" + ApiUtil.getTangoHost() + "  admin.astor.ctrl_system_info.ScanningControlSystem " + parameters;
        this.executeShellCommand(command);
    }

    public static String readFile(String filename) throws DevFailed {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            if (nb > 0) {
                str = new String(inStr);
            }
        }
        catch (Exception e) {
            Except.throw_exception((String)"READ_FAILED", (String)e.toString(), (String)"readFile()");
        }
        return str;
    }

    @Override
    public void run() {
        try {
            int fileCounter = 0;
            StringBuilder sb = new StringBuilder(fileNameHeader + fileCounter++);
            for (int i = 0; i < this.hostNames.size(); ++i) {
                String hostName = this.hostNames.get(i);
                if (i != 0 && i % 10 == 0) {
                    this.startInAnotherJvm(sb.toString());
                    sb = new StringBuilder(fileNameHeader + fileCounter++);
                }
                sb.append(" ").append(hostName);
            }
            if (sb.length() > 0) {
                this.startInAnotherJvm(sb.toString());
            }
            this.monitor.stop();
            String tmpDir = System.getProperty("java.io.tmpdir");
            for (int i = 0; i < fileCounter; ++i) {
                String fileName = tmpDir + "/" + fileNameHeader + i;
                ResultsStructure structure = new ResultsStructure(ScanningThread.readFile(fileName));
                this.results.add(structure);
                System.out.println(structure);
                if (new File(fileName).delete()) continue;
                System.err.println("Cannot delete " + fileName);
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
        }
    }

    public String executeShellCommand(String cmd) throws IOException, InterruptedException, DevFailed {
        String str;
        Process process = Runtime.getRuntime().exec(cmd);
        InputStream inputStream = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        while ((str = br.readLine()) != null) {
            this.monitor.increaseProgressValue(str);
            sb.append(str).append("\n");
        }
        process.waitFor();
        int retVal = process.exitValue();
        if (retVal != 0) {
            InputStream errorStream = process.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errorStream));
            while ((str = br.readLine()) != null) {
                this.monitor.increaseProgressValue(str);
                sb.append(str).append("\n");
            }
            Except.throw_exception((String)"ExecCommnandFailed", (String)("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb), (String)"executeShellCommand()");
        }
        System.out.println(sb);
        return sb.toString();
    }

    private class ResultsStructure {
        int nbHosts = 0;
        int nbSevers = 0;
        int nbServerInstances = 0;
        int nbDevices = 0;
        int nbControlPoints = 0;
        int nbAttributes = 0;
        int nbCommands = 0;
        int nbServerStopped = 0;

        private ResultsStructure() {
        }

        private ResultsStructure(String code) {
            code = code.toLowerCase();
            StringTokenizer stk = new StringTokenizer(code, "\n");
            while (stk.hasMoreTokens()) {
                String line = stk.nextToken();
                if (line.contains("host")) {
                    this.nbHosts = this.getValue(line);
                    continue;
                }
                if (line.contains("server types")) {
                    this.nbSevers = this.getValue(line);
                    continue;
                }
                if (line.contains("instance")) {
                    this.nbServerInstances = this.getValue(line);
                    continue;
                }
                if (line.contains("device")) {
                    this.nbDevices = this.getValue(line);
                    continue;
                }
                if (line.contains("points")) {
                    this.nbControlPoints = this.getValue(line);
                    continue;
                }
                if (line.contains("attributes")) {
                    this.nbAttributes = this.getValue(line);
                    continue;
                }
                if (line.contains("commands")) {
                    this.nbCommands = this.getValue(line);
                    continue;
                }
                if (!line.contains("cannot be checked")) continue;
                this.nbServerStopped = this.getValue(line);
            }
        }

        private int getValue(String line) {
            StringTokenizer stk = new StringTokenizer(line, ":");
            try {
                stk.nextToken();
                String strValue = stk.nextToken().trim();
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                System.err.println(e);
                return -1;
            }
        }

        private void add(ResultsStructure structure) {
            this.nbHosts += structure.nbHosts;
            this.nbSevers += structure.nbSevers;
            this.nbServerInstances += structure.nbServerInstances;
            this.nbDevices += structure.nbDevices;
            this.nbControlPoints += structure.nbControlPoints;
            this.nbAttributes += structure.nbAttributes;
            this.nbCommands += structure.nbCommands;
            this.nbServerStopped += structure.nbServerStopped;
        }

        public String toString() {
            String str = this.nbHosts + " hosts\n" + this.nbServerInstances + " Server instances\n" + this.nbDevices + " devices\n" + this.nbControlPoints + " control points\n" + this.nbAttributes + "  attributes\n" + this.nbCommands + " commands";
            if (this.nbServerStopped > 0) {
                str = str + "\n\n" + this.nbServerStopped + " server(s) cannot be checked.";
            }
            return str;
        }
    }
}

