/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorUtil;
import admin.astor.access.AccessProxy;
import admin.astor.access.AllowedCmdTree;
import admin.astor.access.EditDialog;
import admin.astor.access.PasswordDialog;
import admin.astor.access.UsersTree;
import admin.astor.access.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class TangoAccess
extends JFrame {
    String accessDeviceName;
    UsersTree usersTree;
    private AccessProxy accessProxy;
    private EditDialog checkDialog = null;
    private JFrame parent;
    private static final Dimension pane_size = new Dimension(350, 500);
    private String userName;
    private JMenu actionMenu;
    private JMenuItem checkAccessBtn;
    private JPanel cmdClassPanel;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenuItem findItem;
    private JMenu helpMenu;
    private JMenuItem principleItem;
    private JRadioButtonMenuItem registerItem;
    private JLabel superUserLabel;
    private JTabbedPane tabbedPane;
    private JPanel usersPanel;

    public TangoAccess(JFrame parent) throws DevFailed {
        this.parent = parent;
        try {
            AstorUtil.startSplash("TangoAccess ");
            AstorUtil.increaseSplashProgress(5, "Reading database");
            String test = System.getenv("AccessControl");
            if (test == null) {
                this.getTangoService();
            } else {
                this.accessDeviceName = test;
            }
            this.initComponents();
            this.initOwnComponents();
            AstorUtil.increaseSplashProgress(5, "Finalize GUI");
            ImageIcon icon = Utils.getInstance().getIcon("tango_icon.jpg");
            this.setIconImage(icon.getImage());
            this.setTitle("Tango Access Control Manager");
            if (TangoAccess.isSuperUser()) {
                this.superUserLabel.setVisible(true);
            } else if (this.accessProxy.getAccessControl() == 0) {
                this.superUserLabel.setVisible(true);
                this.superUserLabel.setText("Read Only Mode !");
                this.superUserLabel.setForeground(Color.red);
            } else {
                this.superUserLabel.setVisible(false);
            }
            this.pack();
            if (parent.getWidth() > 0) {
                Point p = parent.getLocationOnScreen();
                p.x += 100;
                p.y += 100;
                this.setLocation(p);
            } else {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
            }
            AstorUtil.stopSplash();
        }
        catch (DevFailed e) {
            AstorUtil.stopSplash();
            throw e;
        }
    }

    private static boolean isSuperUser() {
        boolean super_tango = false;
        String str = System.getProperty("SUPER_TANGO");
        if (str != null) {
            if (str.toLowerCase().equals("true")) {
                super_tango = true;
            }
        } else {
            str = System.getenv("SUPER_TANGO");
            if (str != null && str.toLowerCase().equals("true")) {
                super_tango = true;
            }
        }
        return super_tango;
    }

    private void getTangoService() throws DevFailed {
        String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
        if (services.length == 0) {
            Except.throw_communication_failed((String)"Service_DoesNotExist", (String)"There is no AccessControl service defined !", (String)"TangoAccess.TangoAccess()");
        }
        this.accessDeviceName = services[0];
    }

    private void initOwnComponents() throws DevFailed {
        this.fileMenu.setMnemonic('F');
        this.checkAccessBtn.setMnemonic('T');
        this.checkAccessBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.actionMenu.setMnemonic('A');
        this.registerItem.setMnemonic('R');
        this.findItem.setMnemonic('R');
        this.findItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.helpMenu.setMnemonic('H');
        this.principleItem.setMnemonic('P');
        this.principleItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.accessProxy = new AccessProxy(this.accessDeviceName);
        if (this.accessProxy.getAccessControl() == 0) {
            this.checkAccessBtn.setEnabled(false);
            this.actionMenu.setEnabled(false);
        }
        this.tabbedPane.setTitleAt(0, "Users");
        this.tabbedPane.setTitleAt(1, "Allowed Cmd");
        this.usersTree = new UsersTree(this, this.accessProxy);
        JScrollPane scrowllPane = new JScrollPane();
        scrowllPane.setViewportView(this.usersTree);
        this.usersPanel.add((Component)scrowllPane, "Center");
        AllowedCmdTree cmd_tree = new AllowedCmdTree(this, this.accessProxy);
        scrowllPane = new JScrollPane();
        scrowllPane.setViewportView(cmd_tree);
        this.cmdClassPanel.add((Component)scrowllPane, "Center");
        JLabel lbl = new JLabel("Devices: ");
        JPanel panel = new JPanel();
        panel.add(lbl);
        lbl = new JLabel("Read/Write");
        lbl.setIcon(Utils.getInstance().getIcon("greenbal.gif"));
        panel.add(lbl);
        lbl = new JLabel("Read Only");
        lbl.setIcon(Utils.getInstance().getIcon("redball.gif"));
        panel.add(lbl);
        this.usersPanel.add((Component)panel, "South");
        this.tabbedPane.setPreferredSize(pane_size);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.usersPanel = new JPanel();
        this.cmdClassPanel = new JPanel();
        JPanel topPanel = new JPanel();
        this.superUserLabel = new JLabel();
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.checkAccessBtn = new JMenuItem();
        JMenuItem passwordItem = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.actionMenu = new JMenu();
        this.findItem = new JMenuItem();
        this.registerItem = new JRadioButtonMenuItem();
        this.helpMenu = new JMenu();
        this.principleItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TangoAccess.this.exitForm(evt);
            }
        });
        this.usersPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab1", this.usersPanel);
        this.cmdClassPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab2", this.cmdClassPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.superUserLabel.setFont(new Font("Tahoma", 1, 12));
        this.superUserLabel.setText("You are Super User !");
        topPanel.add(this.superUserLabel);
        this.getContentPane().add((Component)topPanel, "First");
        this.fileMenu.setText("File");
        this.checkAccessBtn.setText("Test Tango Acces");
        this.checkAccessBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.checkAccessBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.checkAccessBtn);
        passwordItem.setText("Change Password");
        passwordItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.passwordItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(passwordItem);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar1.add(this.fileMenu);
        this.actionMenu.setText("Action");
        this.actionMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TangoAccess.this.actionMenuItemStateChanged(evt);
            }
        });
        this.findItem.setText("Find User");
        this.findItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.findItemActionPerformed(evt);
            }
        });
        this.actionMenu.add(this.findItem);
        this.registerItem.setText("Register Service");
        this.registerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.registerItemActionPerformed(evt);
            }
        });
        this.actionMenu.add(this.registerItem);
        jMenuBar1.add(this.actionMenu);
        this.helpMenu.setText("help");
        this.principleItem.setText("On Principle");
        this.principleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.principleItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.principleItem);
        jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void actionMenuItemStateChanged(ItemEvent evt) {
        if (!this.actionMenu.isSelected()) {
            return;
        }
        try {
            String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
            this.registerItem.setSelected(services.length != 0);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    private void registerItemActionPerformed(ActionEvent evt) {
        try {
            boolean b = this.registerItem.getSelectedObjects() != null;
            this.accessProxy.registerService(b);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    private void checkAccessBtnActionPerformed(ActionEvent evt) {
        if (this.checkDialog == null) {
            this.checkDialog = new EditDialog(this, this.accessProxy);
            this.checkDialog.showDialog();
        } else {
            this.checkDialog.setVisible(true);
        }
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void principleItemActionPerformed(ActionEvent evt) {
        admin.astor.tools.Utils.popupMessage(this, "This access management is necessary only if the\n    \"AccessControl/tango\"\n    Tango service has been installed.\n\nBy default all devices are forbiden for all users.\nAnd the rights will be opened for [user, address, device].\n\nThis tool is able to define WRITE access \n    on devices for a TANGO control system\n\nYou can define for a specified user:\n    - Allowed addresses to write devices\n    - Set devices acces to  READ_WRITE or READ_ONLY");
    }

    private void passwordItemActionPerformed(ActionEvent evt) {
        boolean ok = false;
        while (!ok) {
            PasswordDialog dialog = new PasswordDialog((JFrame)this, "New Password ?");
            if (dialog.showDialog() == 0) {
                String password = dialog.getPassword();
                dialog = new PasswordDialog((JFrame)this, "Confirm New Passsword:");
                if (dialog.showDialog() == 0) {
                    String password2 = dialog.getPassword();
                    if (password.equals(password2)) {
                        try {
                            TangoAccess.savePassword(password);
                        }
                        catch (DevFailed e) {
                            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                        }
                        ok = true;
                        continue;
                    }
                    TangoAccess.popupError(this, "Passwords are not equals !");
                    continue;
                }
                return;
            }
            return;
        }
    }

    private void findItemActionPerformed(ActionEvent evt) {
        String str = (String)JOptionPane.showInputDialog(this, "Host Name ?", "Input Dialog", 1, null, null, this.userName);
        if (str != null) {
            this.userName = str;
            this.usersTree.findUser(this.userName);
        }
    }

    private static String getPasswordFromDatabase() throws DevFailed {
        DbDatum datum = ApiUtil.get_db_obj().get_property("Astor", "access");
        String encoded = "???";
        if (!datum.is_empty()) {
            encoded = datum.extractString();
        }
        return PasswordDialog.decryptPassword(encoded);
    }

    private static void savePassword(String password) throws DevFailed {
        DbDatum datum = new DbDatum("access");
        datum.insert(PasswordDialog.cryptPassword(password));
        ApiUtil.get_db_obj().put_property("Astor", new DbDatum[]{datum});
    }

    public static int checkPassword(JFrame parent) throws DevFailed {
        if (TangoAccess.isSuperUser()) {
            return 0;
        }
        String password = TangoAccess.getPasswordFromDatabase();
        PasswordDialog dialog = new PasswordDialog(parent, password.getBytes());
        return dialog.showDialog();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0 && args[0].equals("-???")) {
                System.out.println(TangoAccess.getPasswordFromDatabase());
                System.exit(0);
            }
            if (TangoAccess.checkPassword(new JFrame()) == 0) {
                new TangoAccess(new JFrame()).setVisible(true);
            } else {
                System.exit(0);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"Cannot start TangoAccess class", (DevFailed)e);
            System.exit(0);
        }
        catch (InternalError e) {
            System.out.println(e);
            System.exit(0);
        }
        catch (HeadlessException e) {
            System.out.println(e);
            System.exit(0);
        }
    }

    public static void popupError(Component component, String message) {
        try {
            throw new Exception(message);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)component, null, (Exception)e);
            return;
        }
    }
}

