/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.ServerInfo;
import admin.astor.TangoHost;
import admin.astor.tools.Utils;
import fr.esrf.TangoApi.DbServInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ServersTree
extends JScrollPane
implements AstorDefs {
    private Astor parent;
    public JTree tree;
    public TangoHost[] hosts;
    private DbServInfo selection;

    public ServersTree(Astor astor, String string, ArrayList arrayList, ArrayList<DbServInfo[]> arrayList2) {
        this.parent = astor;
        this.initComponent(string, arrayList, arrayList2);
    }

    private void initComponent(String string, ArrayList arrayList, ArrayList<DbServInfo[]> arrayList2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.createNodes(defaultMutableTreeNode, arrayList, arrayList2);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree.setModel(defaultTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new TangoRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ServersTree.this.serverSelectionPerformed(treeSelectionEvent);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ServersTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.add(this.tree);
        this.setPreferredSize(new Dimension(280, 400));
        this.setViewportView(this.tree);
        this.setVisible(true);
    }

    public void serverSelectionPerformed(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf() && object instanceof DbServInfo) {
            this.selection = (DbServInfo)object;
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
            return;
        }
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2 && (n & 0x10) != 0 && this.selection != null && treePath.getPathCount() - 2 == 1) {
            this.parent.tree.displayHostInfo();
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList arrayList, ArrayList<DbServInfo[]> arrayList2) {
        int n;
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            defaultMutableTreeNodeArray[n] = new DefaultMutableTreeNode(arrayList.get(n));
            defaultMutableTreeNode.add(defaultMutableTreeNodeArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (DbServInfo[] dbServInfoArray : arrayList2) {
                for (DbServInfo dbServInfo : dbServInfoArray) {
                    String string = (String)arrayList.get(n);
                    if (!dbServInfo.name.contains(string)) continue;
                    ServerInfo serverInfo = new ServerInfo(dbServInfo);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)serverInfo);
                    defaultMutableTreeNodeArray[n].add(defaultMutableTreeNode2);
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon tangoIcon;
        String tango_host = AstorUtil.getTangoHost();
        ImageIcon serv_icon;
        ImageIcon inst_icon;
        Font[] fonts;
        private final int TITLE = 0;
        private final int LEAF = 1;

        public TangoRenderer() {
            this.tangoIcon = Utils.getInstance().getIcon("TangoLogo.gif", 0.15);
            this.serv_icon = Utils.getInstance().getIcon("server.gif");
            this.inst_icon = Utils.getInstance().getIcon("device.gif");
            this.fonts = new Font[2];
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(Color.white);
            if (n == 0) {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
                this.setToolTipText(this.tango_host);
            } else if (bl3) {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setIcon(this.inst_icon);
                this.setFont(this.fonts[1]);
                this.setToolTipText("Double click to popup host panel.");
            } else {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.serv_icon);
                this.setFont(this.fonts[1]);
                this.setToolTipText("Server");
            }
            return this;
        }
    }
}

