/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jive.ExecDev;

public class ServerStatePanel
extends JScrollPane {
    private String title;
    private AttributeList attlist = new AttributeList();
    private ErrorHistory err_history;
    private StatePopupMenu menu;

    public ServerStatePanel(String string) throws DevFailed {
        try {
            new DeviceProxy("dserver/" + string).ping();
        }
        catch (DevFailed devFailed) {
            devFailed.errors[0].desc = "Server " + string + " Is not running !";
            throw devFailed;
        }
        this.title = string;
        TangoClass[] tangoClassArray = this.getClasses(string);
        this.initializeComponents(tangoClassArray);
        this.menu = new StatePopupMenu(this);
    }

    public ServerStatePanel(String string, String[] stringArray) {
        this.title = string;
        TangoClass tangoClass = new TangoClass(stringArray);
        this.initializeComponents(new TangoClass[]{tangoClass});
    }

    public void stopRefresher() {
        this.attlist.stopRefresher();
    }

    private void initializeComponents(TangoClass[] tangoClassArray) {
        this.err_history = new ErrorHistory();
        this.attlist.addErrorListener((IErrorListener)this.err_history);
        this.attlist.startRefresher();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 2;
        for (TangoClass tangoClass : tangoClassArray) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(4, 0, 4, 0);
            jPanel.add((Component)new JLabel(tangoClass.name), gridBagConstraints);
            for (TangoDevice tangoDevice : tangoClass.dev) {
                if (tangoDevice == null) continue;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = n;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(4, 0, 4, 0);
                jPanel.add((Component)tangoDevice.label, gridBagConstraints);
                if (tangoDevice.viewer != null) {
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(4, 0, 4, 0);
                    jPanel.add((Component)tangoDevice.viewer, gridBagConstraints);
                    gridBagConstraints.gridx = 4;
                    gridBagConstraints.gridy = n;
                    gridBagConstraints.fill = 2;
                    jPanel.add((Component)tangoDevice.btn, gridBagConstraints);
                    tangoDevice.setStateText();
                }
                ++n;
            }
        }
        JLabel jLabel = new JLabel(this.title);
        jLabel.setFont(new Font("Dialog", 1, 16));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 30, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JButton jButton = new JButton("Errors");
        jButton.setMargin(new Insets(2, 5, 5, 2));
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 2) == 0) {
                    ServerStatePanel.this.err_history.setVisible(true);
                } else {
                    ATKDiagnostic.showDiagnostic();
                }
            }
        });
        this.add(jPanel);
        this.setViewportView(jPanel);
        if (n > 24) {
            this.setPreferredSize(new Dimension(300, 650));
        }
    }

    private TangoClass[] getClasses(String string) throws DevFailed {
        DbServer dbServer = new DbServer(string);
        String[] stringArray = dbServer.get_class_list();
        TangoClass[] tangoClassArray = new TangoClass[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            tangoClassArray[stringArray.length - n - 1] = new TangoClass(dbServer, string2);
            ++n;
        }
        return tangoClassArray;
    }

    class StatePopupMenu
    extends JPopupMenu {
        private ServerStatePanel parent;
        private final String[] menuLabels = new String[]{"Status", "Test Device", "monitor Device"};
        private JLabel title;
        private TangoDevice device;
        private final int OFFSET = 2;
        private final int STATUS = 0;
        private final int TEST_DEVICE = 1;
        private final int MONITOR_DEVICE = 2;

        public StatePopupMenu(ServerStatePanel serverStatePanel2) {
            this.parent = serverStatePanel2;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel("Device :");
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : this.menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StatePopupMenu.this.itemActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent, TangoDevice tangoDevice) {
            this.device = tangoDevice;
            this.title.setText("Device: " + this.device.name);
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            Point point = jComponent.getLocation();
            this.show(this.parent, mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
        }

        private void itemActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    this.device.displayStatus();
                    break;
                }
                case 1: {
                    try {
                        JDialog jDialog = new JDialog((Frame)new JFrame(), false);
                        jDialog.setTitle(this.device.name + " Device Panel");
                        jDialog.setContentPane((Container)new ExecDev(this.device.name));
                        ATKGraphicsUtils.centerDialog((Dialog)jDialog);
                        jDialog.setVisible(true);
                    }
                    catch (DevFailed devFailed) {
                        ErrorPane.showErrorMessage((Component)new JFrame(), (String)this.device.name, (DevFailed)devFailed);
                    }
                    break;
                }
                case 2: {
                    new MainPanel(this.device.name(), false, true);
                }
            }
        }
    }

    class TangoDevice
    extends DeviceProxy
    implements IDevStateScalarListener {
        String name;
        JLabel label;
        StateViewer viewer;
        JButton btn;

        public TangoDevice(String string) throws DevFailed {
            super(string);
            this.name = string;
            try {
                this.label = new JLabel(string);
                this.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        TangoDevice.this.devMouseClicked(mouseEvent);
                    }
                });
                IDevStateScalar iDevStateScalar = (IDevStateScalar)ServerStatePanel.this.attlist.add(string + "/state");
                this.viewer = new StateViewer();
                this.viewer.setLabel("");
                this.viewer.setStatePreferredSize(new Dimension(60, 15));
                this.viewer.setModel(iDevStateScalar);
                iDevStateScalar.addDevStateScalarListener((IDevStateScalarListener)this);
                this.btn = new JButton("...");
                this.btn.setPreferredSize(new Dimension(20, 15));
                this.btn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        TangoDevice.this.devMouseClicked(mouseEvent);
                    }
                });
            }
            catch (ConnectionException connectionException) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (ATKException)connectionException);
            }
        }

        private void setStateText() {
            String string = this.viewer.getCurrentState();
            this.viewer.setStateText(string);
        }

        public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
            this.viewer.setStateText(devStateScalarEvent.getValue());
        }

        public void stateChange(AttributeStateEvent attributeStateEvent) {
        }

        public void errorChange(ErrorEvent errorEvent) {
            System.err.println(errorEvent.getError());
        }

        private void displayStatus() {
            try {
                String string = this.status();
                JOptionPane.showMessageDialog(new Frame(), string, this.name, 1);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            }
        }

        private void devMouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 0x10) != 0 && mouseEvent.getSource() instanceof JButton) {
                this.displayStatus();
            } else if ((n & 4) != 0) {
                ServerStatePanel.this.menu.showMenu(mouseEvent, this);
            }
        }
    }

    class TangoClass {
        String name;
        TangoDevice[] dev;

        public TangoClass(DbServer dbServer, String string) {
            this.name = string;
            try {
                String[] stringArray = dbServer.get_device_name(string);
                this.dev = new TangoDevice[stringArray.length];
                int n = 0;
                for (String string2 : stringArray) {
                    this.dev[n++] = new TangoDevice(string2);
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            }
        }

        public TangoClass(String[] stringArray) {
            this.name = "";
            try {
                this.dev = new TangoDevice[stringArray.length];
                int n = 0;
                for (String string : stringArray) {
                    this.dev[n++] = new TangoDevice(string);
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
            }
        }

        public String toString() {
            String string = "Class " + this.name + ":\n";
            for (TangoDevice tangoDevice : this.dev) {
                string = string + "\t" + tangoDevice.name() + "\n";
            }
            return string;
        }
    }
}

