/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DbServerStructure;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Server2TangoHost
extends JDialog {
    private Component parent;
    private DbServerStructure server;
    private JLabel titleLabel;
    private static final Font[] fonts = new Font[]{new Font("Dialog", 1, 18), new Font("Dialog", 1, 14), new Font("Dialog", 1, 12), new Font("Dialog", 0, 12), new Font("Dialog", 0, 11)};
    private static final int SERVER = 0;
    private static final int CLASS = 1;
    private static final int DEVICE = 2;
    private static final int ATTRIB = 3;
    private static final int DATA = 4;

    public Server2TangoHost(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.buildTheForm(string);
    }

    public Server2TangoHost(JDialog jDialog, String string) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.buildTheForm(string);
    }

    private void buildTheForm(String string) throws DevFailed {
        this.initComponents();
        this.server = new DbServerStructure(string);
        this.initOwnComponents(this.server);
        this.titleLabel.setText("Server " + string + " on " + ApiUtil.get_db_obj().get_tango_host());
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents(DbServerStructure dbServerStructure) throws DevFailed {
        DbServerTree dbServerTree = new DbServerTree(dbServerStructure);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(dbServerTree);
        jScrollPane.setPreferredSize(new Dimension(700, 600));
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Server2TangoHost.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("Export Server");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Server2TangoHost.this.exportBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jLabel.setText("         ");
        jPanel2.add(jLabel);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Server2TangoHost.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void exportBtnActionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.getTangoHostToExport(this.server.getName());
            if (string == null) {
                return;
            }
            int n = this.checkIfServerAlreadyExists(this.server, string);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.server.remove(string);
            }
            this.server.putInDatabase(string);
            if (JOptionPane.showConfirmDialog(this, this.server.getName() + "  server\nHas been exported to " + string + " \n\n" + "Remove it  in  " + ApiUtil.getTangoHost() + " ?\n", "Confirm Dialog", 0) == 0) {
                this.removeServer();
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
        this.doClose();
    }

    private void removeServer() throws DevFailed {
        block5: {
            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + this.server.getName());
            try {
                deviceProxy.ping();
                if (JOptionPane.showConfirmDialog(this, this.server.getName() + "  is running!\n" + "Stop it before remove it  in  " + ApiUtil.getTangoHost() + " ?\n", "Confirm Dialog", 0) == 0) {
                    deviceProxy.command_inout("Kill");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    break block5;
                }
                return;
            }
            catch (DevFailed devFailed) {
                if (JOptionPane.showConfirmDialog(this, "Delete  " + this.server.getName() + "  in  " + ApiUtil.getTangoHost() + " ?\n", "Confirm Dialog", 0) == 0) break block5;
                return;
            }
        }
        new DbServer(this.server.getName()).put_info(new DbServInfo(this.server.getName(), "", false, 0));
        this.server.remove();
    }

    private int checkIfServerAlreadyExists(DbServerStructure dbServerStructure, String string) throws DevFailed {
        if (dbServerStructure.alreadyExists(string)) {
            Object[] objectArray = new Object[]{"Write " + string + " nevertheless", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, "WARNING:\n" + dbServerStructure.getName() + " or device(s)  already exists in " + string + " !\n\n", "Warning", -1, 2, null, objectArray, objectArray[0])) {
                case 0: {
                    return 0;
                }
                case -1: 
                case 1: {
                    return 2;
                }
            }
        }
        return 1;
    }

    private String getTangoHostToExport(String string) {
        String string2 = "";
        boolean bl = false;
        while (string2 != null && !bl) {
            string2 = (String)JOptionPane.showInputDialog(this, "TANGO_HOST to export " + string + "  ?", "Input Dialog", 1, null, null, string2);
            if (string2 == null) continue;
            try {
                if (string2.equals(ApiUtil.getTangoHost())) {
                    Except.throw_exception((String)"", (String)"Cannot copy server on itself", (String)"Server2TangoHost.getTangoHostToExport()");
                }
                ApiUtil.get_db_obj((String)string2);
                bl = true;
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
        return string2;
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                Except.throw_exception((String)"SyntaxError", (String)"ServerName ?", (String)"main()");
            }
            new Server2TangoHost((JFrame)null, stringArray[0]).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
            System.exit(0);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon[] icons = new ImageIcon[5];

        public TangoRenderer() {
            this.icons[0] = Utils.getInstance().getIcon("server.gif");
            this.icons[1] = Utils.getInstance().getIcon("class.gif");
            this.icons[2] = Utils.getInstance().getIcon("device.gif");
            this.icons[3] = Utils.getInstance().getIcon("attleaf.gif");
            this.icons[4] = Utils.getInstance().getIcon("leaf.gif");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            int n2 = object2 instanceof DbServerStructure ? 0 : (object2 instanceof DbServerStructure.TangoClass ? 1 : (object2 instanceof DbServerStructure.TangoDevice ? 2 : (object2 instanceof DbServerStructure.TangoAttribute ? 3 : 4)));
            this.setFont(fonts[n2]);
            this.setIcon(this.icons[n2]);
            return this;
        }
    }

    public class DbServerTree
    extends JTree
    implements TangoConst {
        private DefaultMutableTreeNode root;

        public DbServerTree(DbServerStructure dbServerStructure) throws DevFailed {
            this.buildTree(dbServerStructure);
            this.expandChildren(this.root);
            this.setSelectionPath(null);
        }

        private void buildTree(DbServerStructure dbServerStructure) {
            this.root = new DefaultMutableTreeNode(dbServerStructure);
            this.createCollectionClassNodes(dbServerStructure);
            this.getSelectionModel().setSelectionMode(1);
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
            this.setModel(defaultTreeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            TangoRenderer tangoRenderer = new TangoRenderer();
            this.setCellRenderer(tangoRenderer);
            this.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                }

                @Override
                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    DbServerTree.this.expandedPerformed(treeExpansionEvent);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    DbServerTree.this.treeMouseClicked(mouseEvent);
                }
            });
        }

        private void treeMouseClicked(MouseEvent mouseEvent) {
        }

        public void expandedPerformed(TreeExpansionEvent treeExpansionEvent) {
        }

        private void createCollectionClassNodes(DbServerStructure dbServerStructure) {
            ArrayList arrayList = dbServerStructure.getClasses();
            for (DbServerStructure.TangoClass tangoClass : arrayList) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                DbServerStructure.TangoAttribute tangoAttribute;
                Object object2;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(tangoClass);
                this.root.add(defaultMutableTreeNode2);
                ArrayList arrayList2 = tangoClass.getProperties();
                for (Object object2 : arrayList2) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(object2));
                }
                ArrayList arrayList3 = tangoClass.getAttributes();
                object2 = arrayList3.iterator();
                while (object2.hasNext()) {
                    tangoAttribute = (DbServerStructure.TangoAttribute)object2.next();
                    defaultMutableTreeNode = new DefaultMutableTreeNode(tangoAttribute);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    for (Object object3 : tangoAttribute) {
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(object3));
                    }
                }
                object2 = tangoClass.iterator();
                while (object2.hasNext()) {
                    Object object4;
                    Object object3;
                    tangoAttribute = (DbServerStructure.TangoDevice)object2.next();
                    defaultMutableTreeNode = new DefaultMutableTreeNode(tangoAttribute);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode);
                    ArrayList arrayList4 = tangoAttribute.getProperties();
                    object3 = arrayList4.iterator();
                    while (object3.hasNext()) {
                        object4 = (DbServerStructure.TangoProperty)object3.next();
                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(object4));
                    }
                    object3 = tangoAttribute.getAttributes();
                    object4 = ((ArrayList)object3).iterator();
                    while (object4.hasNext()) {
                        DbServerStructure.TangoAttribute tangoAttribute2 = (DbServerStructure.TangoAttribute)object4.next();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(tangoAttribute2);
                        defaultMutableTreeNode.add(defaultMutableTreeNode3);
                        for (DbServerStructure.TangoProperty tangoProperty : tangoAttribute2) {
                            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(tangoProperty));
                        }
                    }
                }
            }
        }

        private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
            boolean bl = false;
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (defaultMutableTreeNode2.isLeaf()) {
                    if (bl) continue;
                    this.expandNode(defaultMutableTreeNode2);
                    bl = true;
                    continue;
                }
                if (defaultMutableTreeNode2.getUserObject() instanceof DbServerStructure.TangoDevice) continue;
                this.expandChildren(defaultMutableTreeNode2);
            }
        }

        private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            arrayList.add(defaultMutableTreeNode);
            while (defaultMutableTreeNode != this.root) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                arrayList.add(0, defaultMutableTreeNode);
            }
            Object[] objectArray = new DefaultMutableTreeNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray[i] = (TreeNode)arrayList.get(i);
            }
            TreePath treePath = new TreePath(objectArray);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }
}

