/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.GlobalStatistics;
import admin.astor.statistics.GlobalStatisticsTable;
import admin.astor.statistics.ResetStatistics;
import admin.astor.statistics.ServerStat;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.StatisticsFileFilter;
import admin.astor.statistics.Utils;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class StatisticsPanel
extends JFrame {
    private static JFileChooser chooser = null;
    private static final StatisticsFileFilter fileFilter = new StatisticsFileFilter("xml", "Statistics Files");
    private JFrame parent = null;
    private GlobalStatistics globalStatistics;
    private JScrollPane tableScrollPane = null;
    private GlobalStatisticsTable statisticsTable;
    private JPanel bottomPanel;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JTextField filterText;
    private JTextArea globalStatTextArea;
    private JMenuItem openItem;
    private JMenuItem readItem;
    private JMenuItem resetItem;
    private JMenuItem saveItem;
    private JMenu showMenu;
    private JLabel titleLabel;
    private String filter = "";

    public StatisticsPanel(JFrame jFrame, String string) throws DevFailed {
        this.parent = jFrame;
        this.initComponents();
        this.customizeMenus();
        this.globalStatistics = new GlobalStatistics(string);
        this.displayGlobalStatistics();
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
    }

    public StatisticsPanel() {
        this((JFrame)null);
    }

    public StatisticsPanel(JFrame jFrame) {
        this.parent = jFrame;
        AstorUtil.startSplash("Statistics ");
        AstorUtil.increaseSplashProgress(5, "Initializing....");
        this.initComponents();
        this.customizeMenus();
        this.titleLabel.setText("No Statistics Read");
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        AstorUtil.stopSplash();
    }

    public void readAndDisplayStatistics(ArrayList<String> arrayList) {
        this.titleLabel.setText("Reading and Computing Statistics");
        new ReadThread(arrayList).start();
    }

    private void displayGlobalStatistics() {
        ArrayList<ServerStat> arrayList = this.getServerFailedList(this.globalStatistics.getStarterStatistics());
        this.statisticsTable = new GlobalStatisticsTable(this);
        this.statisticsTable.setStatistics(arrayList);
        this.globalStatTextArea.setText(this.globalStatistics.toString());
        if (this.tableScrollPane != null) {
            this.getContentPane().remove(this.tableScrollPane);
        }
        this.tableScrollPane = new JScrollPane();
        this.tableScrollPane.setPreferredSize(new Dimension(this.statisticsTable.getDefaultWidth(), this.statisticsTable.getDefaultHeight()));
        this.tableScrollPane.setViewportView(this.statisticsTable);
        this.getContentPane().add((Component)this.tableScrollPane, "Center");
        String string = "During  " + Utils.formatDuration(this.globalStatistics.getDuration()) + "      " + arrayList.size();
        string = arrayList.size() <= 1 ? string + "  server has failed" : string + "  servers have failed";
        this.titleLabel.setText(string);
        this.pack();
    }

    private void customizeMenus() {
        this.fileMenu.setMnemonic('F');
        this.readItem.setMnemonic('R');
        this.readItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveItem.setMnemonic('S');
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        String string = System.getenv("SUPER_TANGO");
        if (string != null && string.toLowerCase().equals("true")) {
            this.resetItem.setMnemonic('R');
            this.resetItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        } else {
            this.resetItem.setVisible(false);
        }
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.editMenu.setMnemonic('E');
        this.showMenu.setMnemonic('S');
        this.bottomPanel.setVisible(false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.globalStatTextArea = new JTextArea();
        this.bottomPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.filterText = new JTextField();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.readItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.saveItem = new JMenuItem();
        this.resetItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        JMenuItem jMenuItem = new JMenuItem();
        this.showMenu = new JMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StatisticsPanel.this.exitForm(windowEvent);
            }
        });
        jPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Times New Roman", 1, 14));
        this.titleLabel.setText("Title");
        jPanel.add((Component)this.titleLabel, "Last");
        jScrollPane.setPreferredSize(new Dimension(250, 110));
        this.globalStatTextArea.setColumns(20);
        this.globalStatTextArea.setEditable(false);
        this.globalStatTextArea.setFont(new Font("Monospaced", 1, 12));
        this.globalStatTextArea.setRows(5);
        jScrollPane.setViewportView(this.globalStatTextArea);
        jPanel.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "North");
        jLabel.setText("Filter :  ");
        this.bottomPanel.add(jLabel);
        this.filterText.setColumns(20);
        this.filterText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                StatisticsPanel.this.filterTextKeyPressed(keyEvent);
            }
        });
        this.bottomPanel.add(this.filterText);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.fileMenu.setText("File");
        this.readItem.setText("Read Whole Statistics");
        this.readItem.setActionCommand("read");
        this.readItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.readItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.readItem);
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.openItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.openItem);
        this.saveItem.setText("Save");
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.saveItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveItem);
        this.resetItem.setText("Reset Statistics");
        this.resetItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.resetItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.resetItem);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.exitItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitItem);
        jMenuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItem.setText("Find Server");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.filterItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(jMenuItem);
        jMenuBar.add(this.editMenu);
        this.showMenu.setText("Show");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenuItem2.setText("Show Reset Dates");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.datesItemActionPerformed(actionEvent);
            }
        });
        this.showMenu.add(jMenuItem2);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem3.setText("Show Errors");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsPanel.this.errorItemActionPerformed(actionEvent);
            }
        });
        this.showMenu.add(jMenuItem3);
        jMenuBar.add(this.showMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void openItemActionPerformed(ActionEvent actionEvent) {
        File file;
        this.initChooser("Open");
        int n = chooser.showOpenDialog(this);
        if (n == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            try {
                String string = file.getAbsolutePath();
                this.globalStatistics = new GlobalStatistics(string);
                this.displayGlobalStatistics();
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void initChooser(String string) {
        if (chooser == null) {
            String string2 = System.getProperty("FILES");
            if (string2 == null) {
                string2 = "";
            }
            chooser = new JFileChooser(new File(string2).getAbsolutePath());
            chooser.setFileFilter(fileFilter);
        }
        chooser.setApproveButtonText(string);
    }

    private void saveItemActionPerformed(ActionEvent actionEvent) {
        File file;
        if (this.globalStatistics == null) {
            return;
        }
        this.initChooser("Save");
        int n = chooser.showOpenDialog(this);
        if (n == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String string = file.getAbsolutePath();
            if (!string.endsWith(".xml")) {
                string = string + ".xml";
            }
            if (new File(string).exists() && JOptionPane.showConfirmDialog(this, string + "   File already exists\n\n     Overwrite it ?", "Confirm Dialog", 0) != 0) {
                return;
            }
            try {
                this.globalStatistics.saveStatistics(string);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void exitItemActionPerformed(ActionEvent actionEvent) {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    private void readItemActionPerformed(ActionEvent actionEvent) {
        this.readAndDisplayStatistics(null);
    }

    private void errorItemActionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.globalStatistics != null) {
            for (StarterStat starterStat : this.globalStatistics.getStarterStatistics()) {
                if (starterStat.readOK) continue;
                stringBuilder.append(starterStat.name).append(":\t").append(starterStat.error).append("\n");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("No Eror.");
        }
        new PopupText((Frame)this, true).show(stringBuilder.toString());
    }

    private void filterTextKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            this.resetFilter();
        } else {
            new DelayedDisplay(keyEvent).start();
        }
    }

    private void filterItemActionPerformed(ActionEvent actionEvent) {
        if (this.statisticsTable != null) {
            this.bottomPanel.setVisible(true);
            this.pack();
            new DelayedDisplay().start();
        }
    }

    private void resetItemActionPerformed(ActionEvent actionEvent) {
        new ResetStatistics(this);
    }

    private void datesItemActionPerformed(ActionEvent actionEvent) {
        if (this.globalStatistics != null) {
            try {
                new PopupTable((JFrame)this, null, new String[]{"Host", "Statistics starting Date"}, this.globalStatistics.getStarterResetDates()).setVisible(true);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    private void resetFilter() {
        if (this.statisticsTable != null) {
            this.statisticsTable.resetFilter();
            this.filterText.setText("");
            this.bottomPanel.setVisible(false);
            this.pack();
        }
    }

    private ArrayList<ServerStat> getServerFailedList(ArrayList<StarterStat> arrayList) {
        ArrayList<ServerStat> arrayList2 = new ArrayList<ServerStat>();
        for (StarterStat starterStat : arrayList) {
            for (ServerStat serverStat : starterStat) {
                if (serverStat.nbFailures <= 0) continue;
                arrayList2.add(serverStat);
            }
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                new StatisticsPanel(null, stringArray[0]).setVisible(true);
            } else {
                new StatisticsPanel().setVisible(true);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
        }
    }

    private class DelayedDisplay
    extends Thread {
        private KeyEvent evt = null;

        private DelayedDisplay() {
        }

        private DelayedDisplay(KeyEvent keyEvent) {
            this.evt = keyEvent;
        }

        @Override
        public void run() {
            try {
                DelayedDisplay.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.evt == null) {
                StatisticsPanel.this.filterText.requestFocus();
            } else {
                char c = this.evt.getKeyChar();
                if ((c & 0x8000) == 0) {
                    String string = StatisticsPanel.this.filterText.getText();
                    if (!StatisticsPanel.this.filter.equals(string)) {
                        if (string.length() > 0) {
                            StatisticsPanel.this.statisticsTable.setFilter(string);
                        } else {
                            StatisticsPanel.this.statisticsTable.resetFilter();
                        }
                    }
                    StatisticsPanel.this.filter = string;
                }
            }
        }
    }

    class CompareStarterResetTime
    implements Comparator<StarterStat> {
        CompareStarterResetTime() {
        }

        @Override
        public int compare(StarterStat starterStat, StarterStat starterStat2) {
            if (starterStat.resetTime == starterStat2.resetTime) {
                return 0;
            }
            return starterStat.resetTime > starterStat2.resetTime ? 1 : -1;
        }
    }

    private class ReadThread
    extends Thread {
        private ArrayList<String> hostList;

        private ReadThread(ArrayList<String> arrayList) {
            this.hostList = arrayList;
        }

        @Override
        public void run() {
            AstorUtil.startSplash("Statistics ");
            AstorUtil.increaseSplashProgress(5, "Reading....");
            StatisticsPanel.this.setCursor(new Cursor(3));
            ArrayList<StarterStat> arrayList = Utils.readHostStatistics(this.hostList);
            Collections.sort(arrayList, new CompareStarterResetTime());
            StatisticsPanel.this.globalStatistics = new GlobalStatistics(arrayList);
            StatisticsPanel.this.displayGlobalStatistics();
            StatisticsPanel.this.setCursor(new Cursor(0));
            AstorUtil.stopSplash();
        }
    }
}

