/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.LogRecord;
import admin.astor.statistics.ServerStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StarterStat
extends ArrayList<ServerStat> {
    public String name;
    public boolean readOK = false;
    public long resetTime = System.currentTimeMillis();
    public String error = "";
    public static final String className = "StarterStat";
    private static final String hostStr = "host";
    private static final String readStr = "read";
    private static final String resetStr = "reset";
    private static final String description = "<StarterStat host=\"HOST\" read=\"READ\" reset=\"RESET\">";
    private static final String tab = "\t\t";
    public static final String[] tableHeader = new String[]{"Server", "Run Time", "Failures", "Failure Duration"};

    public StarterStat(String string) {
        this.name = string;
        this.readStatisticsFromStarter(string);
    }

    public StarterStat(ArrayList<String> arrayList) throws DevFailed {
        this.parseXmlStatistics(arrayList);
    }

    private void readStatisticsFromStarter(String string) {
        DeviceProxy deviceProxy;
        String string2 = "Tango/admin/" + string;
        try {
            deviceProxy = new DeviceProxy(string2);
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
            this.error = devFailed.errors[0].desc;
            return;
        }
        try {
            this.buildControlledServerList(deviceProxy);
            this.readStatisticsFileFromStarter(deviceProxy);
            this.readOK = true;
        }
        catch (DevFailed devFailed) {
            System.err.println(string + ":\t" + devFailed.errors[0].desc);
            this.error = devFailed.errors[0].desc;
            this.resetTime = System.currentTimeMillis();
        }
    }

    private void buildControlledServerList(DeviceProxy deviceProxy) throws DevFailed {
        String[] stringArray;
        DeviceAttribute deviceAttribute = deviceProxy.read_attribute("Servers");
        for (String string : stringArray = deviceAttribute.extractStringArray()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string3.equals("0") || string4.equals("0")) continue;
            this.add(new ServerStat(string2, this));
        }
    }

    public void readStatisticsFileFromStarter(DeviceProxy deviceProxy) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert("Statistics");
        DeviceData deviceData2 = deviceProxy.command_inout("DevReadLog", deviceData);
        String string = deviceData2.extractString();
        ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            LogRecord logRecord = new LogRecord(stringTokenizer.nextToken());
            arrayList.add(logRecord);
        }
        this.resetTime = System.currentTimeMillis();
        this.buildServerStatistics(arrayList);
        for (ServerStat serverStat : this) {
            long l;
            serverStat.computeStatistics();
            if (serverStat.size() <= 0 || (l = serverStat.oldestTime) >= this.resetTime) continue;
            this.resetTime = l;
        }
    }

    private void buildServerStatistics(ArrayList<LogRecord> arrayList) {
        for (LogRecord logRecord : arrayList) {
            ServerStat serverStat = this.getServerStat(logRecord.name);
            if (serverStat == null) {
                serverStat = new ServerStat(logRecord.name, this);
                this.add(serverStat);
            }
            serverStat.addLog(logRecord);
        }
    }

    public ServerStat getServerStat(String string) {
        for (ServerStat serverStat : this) {
            if (!serverStat.name.equals(string)) continue;
            return serverStat;
        }
        return null;
    }

    public String[][] toTable() {
        String[][] stringArray = new String[this.size()][tableHeader.length];
        int n = 0;
        for (ServerStat serverStat : this) {
            int n2 = 0;
            stringArray[n][n2++] = serverStat.name;
            stringArray[n][n2++] = Utils.formatDuration(serverStat.runDuration);
            stringArray[n][n2++] = Integer.toString(serverStat.nbFailures);
            stringArray[n][n2] = serverStat.nbFailures > 0 ? Utils.formatDuration(serverStat.failedDuration) : "";
            ++n;
        }
        return stringArray;
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getServerStat(string).recordsToString());
        return stringBuilder.toString();
    }

    private String toXmlLine() {
        String string = description;
        string = Utils.strReplace(string, "HOST", this.name);
        string = Utils.strReplace(string, "READ", Boolean.toString(this.readOK));
        string = Utils.strReplace(string, "RESET", Long.toString(this.resetTime));
        return string;
    }

    private void parseXmlStatistics(ArrayList<String> arrayList) throws DevFailed {
        if (arrayList.size() >= 0) {
            this.parseXmlProperties(arrayList.get(0));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (int i = 1; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            if (!bl && string.startsWith("<ServerStat")) {
                bl = true;
                arrayList2.add(string);
                continue;
            }
            if (string.startsWith("</ServerStat")) {
                ServerStat serverStat = new ServerStat(arrayList2);
                serverStat.starterStat = this;
                this.add(serverStat);
                bl = false;
                arrayList2.clear();
                continue;
            }
            if (!bl) continue;
            arrayList2.add(string);
        }
    }

    private void parseXmlProperties(String string) throws DevFailed {
        this.name = Utils.parseXmlProperty(string, hostStr);
        try {
            this.readOK = Boolean.parseBoolean(Utils.parseXmlProperty(string, readStr));
            this.resetTime = Long.parseLong(Utils.parseXmlProperty(string, resetStr));
        }
        catch (NumberFormatException numberFormatException) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)numberFormatException.toString(), (String)"StarterStat.parseLine()");
        }
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tab).append(this.toXmlLine()).append("\n");
        for (ServerStat serverStat : this) {
            stringBuilder.append(serverStat.toXml()).append("\n");
        }
        stringBuilder.append(tab).append("</").append(className).append(">");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        long l = System.currentTimeMillis() - this.resetTime;
        stringBuilder.append("   Since ").append(Utils.formatDate(this.resetTime)).append("  (").append(Utils.formatDuration(l)).append(")\n");
        for (ServerStat serverStat : this) {
            stringBuilder.append(serverStat).append("\n");
        }
        return stringBuilder.toString();
    }
}

