/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.ctrl_system_info;

import admin.astor.ctrl_system_info.Monitor;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFrame;

public class ScanningThread
extends Thread {
    private ArrayList<String> classList = new ArrayList();
    private ArrayList<String> binaryList = new ArrayList();
    private ArrayList<String> stoppedList = new ArrayList();
    private ArrayList<TangoCommand> dserverCommands = new ArrayList();
    private ArrayList<String> hostNames;
    private StringBuilder results = new StringBuilder();
    private Monitor monitor;

    public ScanningThread(ArrayList<String> hostNames, Monitor monitor) {
        this.hostNames = hostNames;
        this.monitor = monitor;
    }

    public String getResults() {
        return this.results.toString();
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        try {
            this.monitor.setProgressValue(0.05, "Browsing  database");
            ArrayList<TangoHost> hostList = new ArrayList<TangoHost>();
            int i = 0;
            for (String hostName : this.hostNames) {
                double ratio = (double)(++i) / (double)(this.hostNames.size() + 1);
                hostList.add(new TangoHost(hostName, ratio));
            }
            int nbServers = 0;
            int nbDevices = 0;
            int nbControlPoints = 0;
            int nbAttributes = 0;
            int nbCommands = 0;
            for (TangoHost tangoHost : hostList) {
                nbServers += tangoHost.size();
                for (TangoServer tangoServer : tangoHost) {
                    nbDevices += tangoServer.size();
                    for (TangoDevice tangoDevice : tangoServer) {
                        nbAttributes += tangoDevice.size();
                        nbCommands += tangoDevice.commands.size();
                        for (TangoAttribute attribute : tangoDevice) {
                            nbControlPoints += attribute.controlPoint;
                        }
                        for (TangoCommand command : tangoDevice.commands) {
                            nbControlPoints += command.controlPoint;
                        }
                    }
                }
                if (!this.monitor.isCanceled()) continue;
                return;
            }
            this.results.append("Controlled under Starter:\n");
            this.results.append("    - Hosts:\t\t\t\t").append(hostList.size()).append("\n");
            this.results.append("    - Server types:\t\t").append(this.binaryList.size()).append("\n");
            this.results.append("    - Server/Instances:\t").append(nbServers).append("\n");
            this.results.append("    - Classes:\t\t\t").append(this.classList.size()).append("\n");
            this.results.append("    - Devices:\t\t\t").append(nbDevices).append("\n");
            this.results.append("    - Control Points:\t\t").append(nbControlPoints).append("\n");
            this.results.append("\t\t- ").append(nbAttributes).append(" attributes").append("\n");
            this.results.append("\t\t- ").append(nbCommands).append(" commands").append("\n");
            if (this.stoppedList.size() > 0) {
                this.results.append("\n").append(this.stoppedList.size()).append(" Server(s) cannot be checked !\n");
            }
            this.results.append("\n").append("Elapsed time ").append(this.formatTime(t0)).append("\n");
            this.results.append("Measurements done ").append(new Date()).append("\n");
            this.monitor.stop();
            this.printComplementaryResults();
        }
        catch (DevFailed e) {
            this.monitor.stop();
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private void printComplementaryResults() {
        System.out.println(this.stoppedList.size() + " stopped server(s)");
        for (String stopped : this.stoppedList) {
            System.out.println(stopped);
        }
    }

    private String formatTime(long t0) {
        long dt = (System.currentTimeMillis() - t0) / 1000L;
        int mn = (int)dt / 60;
        int sec = (int)dt - 60 * mn;
        return mn + " minutes " + sec + " seconds";
    }

    private class TangoHost
    extends ArrayList<TangoServer> {
        String name;

        private TangoHost(String name, double ratio) throws DevFailed {
            String[] serverNames;
            this.name = name;
            DeviceData argIn = new DeviceData();
            argIn.insert(name);
            DeviceData argOut = ApiUtil.get_db_obj().command_inout("DbGetHostServerList", argIn);
            for (String serverName : serverNames = argOut.extractStringArray()) {
                if (ScanningThread.this.monitor.isCanceled()) {
                    return;
                }
                ScanningThread.this.monitor.setProgressValue(ratio, "Checking on " + name + ": " + serverName);
                if (!this.serverControlled(serverName)) continue;
                this.add(new TangoServer(serverName));
            }
        }

        private boolean serverControlled(String serverName) throws DevFailed {
            DbServInfo s = ApiUtil.get_db_obj().get_server_info(serverName);
            return s.controlled;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            for (TangoServer server : this) {
                sb.append(server).append("\n");
            }
            return sb.toString();
        }
    }

    private class TangoServer
    extends ArrayList<TangoDevice> {
        String name;
        String binary;
        boolean running;

        private TangoServer(String name) throws DevFailed {
            this.name = name;
            this.binary = name.substring(0, name.indexOf(47));
            if (!ScanningThread.this.binaryList.contains(this.binary)) {
                ScanningThread.this.binaryList.add(this.binary);
            }
            this.running = this.isRunning();
            DbServer server = new DbServer(name);
            String[] argOut = server.get_device_class_list();
            for (int i = 0; i < argOut.length; i += 2) {
                String className = argOut[i + 1];
                if (!ScanningThread.this.classList.contains(className)) {
                    ScanningThread.this.classList.add(className);
                }
                String deviceName = argOut[i];
                this.add(new TangoDevice(deviceName, this.running));
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        private boolean isRunning() {
            try {
                new DeviceProxy("dserver/" + this.name).ping();
                return true;
            }
            catch (DevFailed e) {
                ScanningThread.this.stoppedList.add(this.name + ":\t" + e.errors[0].desc);
                return false;
            }
        }

        @Override
        public String toString() {
            String tab = "    ";
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            for (TangoDevice device : this) {
                sb.append(device).append("\n");
            }
            return tab + sb.toString().trim();
        }
    }

    private class TangoDevice
    extends ArrayList<TangoAttribute> {
        String name;
        ArrayList<TangoCommand> commands = new ArrayList();

        private TangoDevice(String name, boolean running) {
            this.name = name;
            if (name.startsWith("dserver/")) {
                this.manageDserverDevice(running);
            } else if (running) {
                try {
                    CommandInfo[] commandInfoList;
                    AttributeInfo[] attributeInfoList;
                    DeviceProxy proxy = new DeviceProxy(name);
                    for (AttributeInfo attributeInfo : attributeInfoList = proxy.get_attribute_info()) {
                        this.add(new TangoAttribute(attributeInfo));
                    }
                    for (CommandInfo commandInfo : commandInfoList = proxy.command_list_query()) {
                        this.commands.add(new TangoCommand(commandInfo));
                    }
                }
                catch (DevFailed e) {
                    // empty catch block
                }
            }
        }

        private void manageDserverDevice(boolean running) {
            if (running && ScanningThread.this.dserverCommands.isEmpty()) {
                try {
                    CommandInfo[] commandInfoList;
                    DeviceProxy proxy = new DeviceProxy(this.name);
                    for (CommandInfo commandInfo : commandInfoList = proxy.command_list_query()) {
                        ScanningThread.this.dserverCommands.add(new TangoCommand(commandInfo));
                    }
                }
                catch (DevFailed e) {
                    // empty catch block
                }
            }
            for (TangoCommand tangoCommand : ScanningThread.this.dserverCommands) {
                this.commands.add(tangoCommand);
            }
        }

        private int getControlPointCount() {
            int nb = 0;
            for (TangoAttribute attribute : this) {
                nb += attribute.controlPoint;
            }
            for (TangoCommand command : this.commands) {
                nb += command.controlPoint;
            }
            return nb;
        }

        @Override
        public String toString() {
            String tab = "        ";
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            sb.append(tab).append(this.size()).append(" attributes\n");
            sb.append(tab).append(this.commands.size()).append(" commands\n");
            sb.append(tab).append(tab).append(this.getControlPointCount()).append(" control point\n");
            return tab + sb.toString().trim();
        }
    }

    private class TangoAttribute {
        String name;
        int controlPoint;

        private TangoAttribute(AttributeInfo attributeInfo) {
            this.name = attributeInfo.name;
            this.controlPoint = attributeInfo.writable == AttrWriteType.READ ? 1 : 2;
        }
    }

    private class TangoCommand {
        String name;
        int controlPoint;

        private TangoCommand(CommandInfo commandInfo) {
            this.name = commandInfo.cmd_name;
            this.controlPoint = commandInfo.in_type != 0 && commandInfo.out_type != 0 ? 2 : 1;
        }
    }
}

