/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.TangoServer;
import admin.astor.tools.PollingProfiler;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ManagePollingDialog
extends JDialog
implements TangoConst {
    private Component parent;
    private String[] commands;
    private String[] attributes;
    private TangoServer server;
    private JButton addBtn;
    private JRadioButton attrBtn;
    private JComboBox cmdBox;
    private JRadioButton cmdBtn;
    private JLabel cmdLabel;
    private JComboBox devicesBox;
    private JButton dismissBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton profilerBtn;
    private JButton removeBtn;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JButton updateBtn;

    private void setCmdAttrBox() {
        String[] stringArray;
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.cmdLabel.setText("Command Selection");
            stringArray = this.commands;
        } else {
            this.cmdLabel.setText("Attribute Selection");
            stringArray = this.attributes;
        }
        this.cmdBox.removeAllItems();
        for (String string : stringArray) {
            this.cmdBox.addItem(string);
        }
        this.pack();
    }

    private void initComponentsFromDevices() {
        try {
            String[] stringArray;
            for (String string : stringArray = this.server.queryDevice()) {
                this.devicesBox.addItem(string);
            }
            this.devicesBox.addItem("*");
            this.devicesBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManagePollingDialog.this.devSelectionActionPerformed(actionEvent);
                }
            });
            this.cmdBtn.setSelected(false);
            this.attrBtn.setSelected(true);
            this.getAttrCmdLists(stringArray[0]);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void getAttrCmdLists(String string) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            CommandInfo[] commandInfoArray = deviceProxy.command_list_query();
            int n = 0;
            for (CommandInfo commandInfo : commandInfoArray) {
                if (commandInfo.in_type != 0 || commandInfo.cmd_name.equals("Init")) continue;
                ++n;
            }
            this.commands = new String[n];
            int n2 = 0;
            for (int i = 0; i < commandInfoArray.length; ++i) {
                if (commandInfoArray[i].in_type != 0 || commandInfoArray[i].cmd_name.equals("Init")) continue;
                this.commands[n2++] = commandInfoArray[i].cmd_name;
            }
            this.attributes = deviceProxy.get_attribute_list();
            this.setCmdAttrBox();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void devSelectionActionPerformed(ActionEvent actionEvent) {
        String string = this.devicesBox.getSelectedItem().toString();
        if (!string.equals("*")) {
            this.getAttrCmdLists(string);
        }
    }

    public ManagePollingDialog(JDialog jDialog, TangoServer tangoServer) {
        super((Dialog)jDialog, false);
        this.server = tangoServer;
        this.parent = jDialog;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.displayStatus();
        this.pack();
    }

    public ManagePollingDialog(JFrame jFrame, String string, String string2) throws DevFailed {
        super((Frame)jFrame, false);
        this.server = new TangoServer(new DeviceProxy(string).adm_name());
        this.parent = jFrame;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        this.devicesBox.setSelectedItem(string);
        this.cmdBox.setSelectedItem(string2);
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.displayStatus();
        this.pack();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.updateBtn = new JButton();
        this.jLabel8 = new JLabel();
        this.profilerBtn = new JButton();
        this.jLabel9 = new JLabel();
        this.dismissBtn = new JButton();
        this.jPanel3 = new JPanel();
        this.devicesBox = new JComboBox();
        this.cmdBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cmdLabel = new JLabel();
        this.addBtn = new JButton();
        this.jLabel3 = new JLabel();
        this.removeBtn = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cmdBtn = new JRadioButton();
        this.attrBtn = new JRadioButton();
        this.jLabel7 = new JLabel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ManagePollingDialog.this.closeDialog(windowEvent);
            }
        });
        this.updateBtn.setText("Update Status");
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.updateBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.updateBtn);
        this.jLabel8.setText("        ");
        this.jPanel2.add(this.jLabel8);
        this.profilerBtn.setText("Show Profiler");
        this.profilerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.profilerBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.profilerBtn);
        this.jLabel9.setText("        ");
        this.jPanel2.add(this.jLabel9);
        this.dismissBtn.setText("Dismiss");
        this.dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.dismissBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.dismissBtn);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel3.setLayout(new GridBagLayout());
        this.devicesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.devicesBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.devicesBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.cmdBox, gridBagConstraints);
        this.jLabel2.setText("Device Selection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.cmdLabel.setText("command :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel3.add((Component)this.cmdLabel, gridBagConstraints);
        this.addBtn.setText("Add / Update");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.addBtn, gridBagConstraints);
        this.jLabel3.setFont(new Font("Dialog", 0, 36));
        this.jLabel3.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.jPanel3.add((Component)this.jLabel3, gridBagConstraints);
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.removeBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.removeBtn, gridBagConstraints);
        this.jLabel4.setFont(new Font("Dialog", 0, 36));
        this.jLabel4.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanel3.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Polling  on   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.cmdBtn.setText("Command");
        this.cmdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.cmdBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.cmdBtn, gridBagConstraints);
        this.attrBtn.setText("Attribute");
        this.attrBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagePollingDialog.this.attrBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.attrBtn, gridBagConstraints);
        this.jLabel7.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel3, "West");
        this.textScrollPane.setPreferredSize(new Dimension(450, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        this.textScrollPane.setViewportView(this.textArea);
        this.getContentPane().add((Component)this.textScrollPane, "Center");
        this.pack();
    }

    private void profilerBtnActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.selectedDevices();
        if (this.parent instanceof JFrame) {
            new PollingProfiler((JFrame)this.parent, stringArray).setVisible(true);
        } else {
            new PollingProfiler((JDialog)this.parent, stringArray).setVisible(true);
        }
    }

    private String[] selectedDevices() {
        String[] stringArray;
        String string = this.devicesBox.getSelectedItem().toString();
        if (string.equals("*")) {
            int n = this.devicesBox.getItemCount() - 1;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.devicesBox.getItemAt(i).toString();
            }
        } else {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    private void displayStatus() {
        String[] stringArray = this.selectedDevices();
        String string = "        Polling Status\n\n";
        for (String string2 : stringArray) {
            try {
                string = string + "=============================================\n";
                string = string + string2 + " :\n\n";
                DeviceProxy deviceProxy = new DeviceProxy(string2);
                String[] stringArray2 = deviceProxy.polling_status();
                for (int i = 0; i < stringArray2.length; ++i) {
                    string = string + stringArray2[i] + "\n";
                    if (i >= stringArray2.length - 1) continue;
                    string = string + "   ---------------------------------\n";
                }
                if (stringArray2.length <= 0) continue;
                string = string + "\n\n";
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                return;
            }
        }
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.selectedDevices();
        String string = this.cmdBox.getSelectedItem().toString();
        String string2 = "Remove polling on " + string + " for:\n";
        for (String string3 : stringArray) {
            string2 = string2 + string3 + ",  ";
        }
        if (JOptionPane.showConfirmDialog(this, string2, "Question ?", 0) == 0) {
            string2 = string + " polling has been removed for:\n";
            for (String string3 : stringArray) {
                try {
                    DeviceProxy deviceProxy = new DeviceProxy(string3);
                    if (this.cmdBtn.getSelectedObjects() != null) {
                        deviceProxy.stop_poll_command(string);
                    } else {
                        deviceProxy.stop_poll_attribute(string);
                    }
                    string2 = string2 + string3 + "\n";
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                    return;
                }
            }
            Utils.popupMessage(this, string2);
            this.displayStatus();
        }
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.selectedDevices();
        boolean bl = false;
        String string = "";
        int n = 0;
        while (!bl) {
            if ((string = (String)JOptionPane.showInputDialog(this, "Polling period (ms)  ?", "Polling period", 1, null, null, string)) == null) {
                return;
            }
            try {
                n = Integer.parseInt(string);
                if (n < 20) {
                    Utils.popupError(this, "The polling period minimum value is 20ms");
                    continue;
                }
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                Utils.popupError(this, numberFormatException.toString() + "\n\nBad Value in Polling period field !");
            }
        }
        String string2 = this.cmdBox.getSelectedItem().toString();
        StringBuilder stringBuilder = new StringBuilder(string2 + " polling has been added for:\n");
        for (String string3 : stringArray) {
            try {
                DeviceProxy deviceProxy = new DeviceProxy(string3);
                if (this.cmdBtn.getSelectedObjects() != null) {
                    deviceProxy.poll_command(string2, n);
                } else {
                    deviceProxy.poll_attribute(string2, n);
                }
                stringBuilder.append(string3).append('\n');
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
        Utils.popupMessage(this, stringBuilder.toString());
        this.displayStatus();
    }

    private void attrBtnActionPerformed(ActionEvent actionEvent) {
        if (this.attrBtn.getSelectedObjects() != null) {
            this.cmdBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void cmdBtnActionPerformed(ActionEvent actionEvent) {
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.attrBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void devicesBoxActionPerformed(ActionEvent actionEvent) {
        this.displayStatus();
    }

    private void updateBtnActionPerformed(ActionEvent actionEvent) {
        this.displayStatus();
    }

    private void dismissBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

