/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.tools.BlackBoxTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import javax.swing.JFrame;

public class DbaseObject
implements AstorDefs {
    private AstorTree parent;
    private String tango_host;
    private DbaseState state_thread;
    int state = 0;
    DevFailed except = null;

    public DbaseObject(AstorTree astorTree, String string) {
        this.parent = astorTree;
        this.tango_host = string;
        this.state_thread = new DbaseState();
        this.state_thread.start();
    }

    void start() {
        this.state_thread.start();
    }

    String getCvsTag(DeviceProxy deviceProxy) throws DevFailed {
        int n;
        String string = null;
        DevInfo devInfo = deviceProxy.info();
        String string2 = devInfo.doc_url;
        String string3 = "CVS Tag = ";
        int n2 = string2.indexOf(string3);
        if (n2 > 0 && (n = string2.indexOf(10, n2 += string3.length())) > n2) {
            string = string2.substring(n2, n);
        }
        if (string == null) {
            return "";
        }
        return "CVS Tag:   " + string + "\n";
    }

    String getServerInfo() throws DevFailed {
        String string = this.state_thread.db.get_name();
        DeviceProxy deviceProxy = new DeviceProxy(string);
        String string2 = "TANGO_HOST:    " + this.tango_host + "\n\n";
        string2 = string2 + deviceProxy.get_info() + "\n\n";
        string2 = string2 + this.getCvsTag(deviceProxy);
        try {
            DeviceAttribute deviceAttribute = deviceProxy.read_attribute("StoredProcedureRelease");
            string2 = string2 + "Stored Procedure: " + deviceAttribute.extractString();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        string2 = string2 + "\n\n";
        return string2;
    }

    String getInfo() throws DevFailed {
        Database database = ApiUtil.get_db_obj((String)this.tango_host);
        return database.get_info();
    }

    void blackbox(JFrame jFrame) {
        try {
            new BlackBoxTable(jFrame, this.state_thread.db.getDeviceName()).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jFrame, null, (DevFailed)devFailed);
        }
    }

    public String toString() {
        return this.tango_host;
    }

    private class DbaseState
    extends Thread {
        private String host;
        private String port;
        private DbConnection db = null;

        private DbaseState() {
            this.setName("Database State Thread");
            int n = DbaseObject.this.tango_host.indexOf(":");
            this.host = DbaseObject.this.tango_host.substring(0, n);
            this.port = DbaseObject.this.tango_host.substring(n + 1);
        }

        private synchronized void wait_next_loop() {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void updateParent(int n, DevFailed devFailed) {
            if (DbaseObject.this.state != n || DbaseObject.this.except != devFailed) {
                DbaseObject.this.state = n;
                DbaseObject.this.except = devFailed;
                DbaseObject.this.parent.updateState();
            }
        }

        private void manageState() {
            DevFailed devFailed;
            int n;
            try {
                if (this.db == null) {
                    this.db = new DbConnection(this.host, this.port);
                }
                this.db.ping();
                n = 3;
                devFailed = null;
            }
            catch (DevFailed devFailed2) {
                n = 1;
                devFailed = devFailed2;
            }
            this.updateParent(n, devFailed);
        }

        @Override
        public void run() {
            while (true) {
                this.manageState();
                this.wait_next_loop();
            }
        }
    }

    private class DbConnection
    extends Connection {
        private String devname;

        private DbConnection(String string, String string2) throws DevFailed {
            super(string, string2, false);
            this.devname = this.get_name();
        }

        private String getDeviceName() {
            return this.devname;
        }
    }
}

