/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.HostInfoDialog;
import admin.astor.HostInfoDialogVector;
import admin.astor.HostStateThread;
import admin.astor.RemoteLoginThread;
import admin.astor.RenameDialog;
import admin.astor.TACobject;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.TreePopupMenu;
import admin.astor.access.TangoAccess;
import admin.astor.statistics.ResetStatistics;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive3.MainPanel;

public class AstorTree
extends JTree
implements AstorDefs {
    private JFrame parent;
    public TangoHost[] hosts;
    private TangoHost selectedHost = null;
    private DbaseObject selected_db = null;
    private DbaseObject[] dbase;
    private DefaultTreeModel treeModel;
    private Timer watchDogTimer;
    private TACobject accessControl;
    private TangoAccess tangoAccessPanel = null;
    private MainPanel jive3 = null;
    private TreePopupMenu pMenu;
    private DbPopupMenu dbMenu;
    private TacPopupMenu tacMenu;
    HostInfoDialogVector hostDialogs = new HostInfoDialogVector();
    private static ArrayList<String> collecNames = new ArrayList();
    private static DefaultMutableTreeNode root;
    private static int hostSubscribed;
    public static final Color background;
    private ArrayList<String> subscribeError = new ArrayList();
    private UpdateSplashThread updateSplashThread = null;
    PopupText subscribeErrWindow = null;
    private long startSubscribeTime;
    private Splash splash;
    private boolean jive_is_read_only = false;

    public AstorTree(JFrame jFrame, Splash splash) throws DevFailed {
        this.parent = jFrame;
        this.splash = splash;
        this.initComponent();
        this.setBackground(background);
        hostSubscribed = 0;
        this.updateSplashThread = new UpdateSplashThread(this.hosts.length);
        this.updateSplashThread.start();
        int n = 0;
        for (TangoHost tangoHost : this.hosts) {
            this.updateSplashThread.wakeUp(n++, "Creating  " + (Object)((Object)tangoHost) + "  object");
            tangoHost.thread = new HostStateThread(this, tangoHost);
            tangoHost.thread.start();
        }
        this.updateSplashThread.stopThread();
        if (hostSubscribed == 0) {
            this.updateSplashThread = new UpdateSplashThread(this.hosts.length);
            this.updateSplashThread.start();
            this.startSubscribeTime = System.currentTimeMillis();
            new subscribeThread().start();
            this.updateMonitor(null);
        }
        this.pMenu = jFrame instanceof Astor ? new TreePopupMenu((Astor)jFrame, this) : new TreePopupMenu(this);
        this.dbMenu = new DbPopupMenu(this);
        if (this.isAccessControlled()) {
            this.tacMenu = new TacPopupMenu(this);
        }
        this.expandRow(1);
        int n2 = 10000;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.watchDogTimer = new Timer(n2, actionListener);
        this.watchDogTimer.start();
    }

    void updateMonitor(String string) {
        if (string != null) {
            this.subscribeError.add(string);
        }
        if (hostSubscribed < this.hosts.length) {
            if (this.updateSplashThread != null) {
                TangoHost tangoHost = this.hosts[hostSubscribed];
                String string2 = "Subscribing for  " + tangoHost.getName() + "  (" + (hostSubscribed + 1) + "/" + this.hosts.length + ")";
                this.updateSplashThread.wakeUp(AstorTree.hostSubscribed, string2);
                ++hostSubscribed;
            }
        } else {
            long l = System.currentTimeMillis();
            System.out.println("Total time to subscribe on " + hostSubscribed + " hosts : " + (l - this.startSubscribeTime) + " ms");
            System.out.println("Total time to start Astor " + (l - Astor.t0) + " ms");
            if (this.updateSplashThread != null) {
                this.updateSplashThread.stopThread();
            }
            this.splash.setVisible(false);
            if (this.subscribeError.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < this.subscribeError.size(); ++i) {
                    stringBuilder.append(this.subscribeError.get(i));
                    if (i >= this.subscribeError.size() - 1) continue;
                    stringBuilder.append("\n\n");
                }
                String string3 = "Subscribe events on " + this.subscribeError.size() + "/" + hostSubscribed;
                string3 = this.subscribeError.size() == 1 ? string3 + " host has failed" : string3 + " hosts have failed";
                int n = 50 + this.subscribeError.size() * 75;
                if (n > 560) {
                    n = 560;
                }
                this.subscribeErrWindow = new PopupText((Frame)this.parent, true);
                this.subscribeErrWindow.setTitle(string3);
                this.subscribeErrWindow.addText(stringBuilder.toString());
                this.subscribeErrWindow.setSize(900, n);
            }
        }
    }

    void stopThreads() {
        this.watchDogTimer.stop();
        for (TangoHost tangoHost : this.hosts) {
            tangoHost.stopThread();
        }
    }

    void expand(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.hosts.length + collecNames.size() + 1; ++i) {
                this.expandRow(i);
            }
        } else {
            for (int i = 1; i <= collecNames.size(); ++i) {
                this.collapseRow(i);
            }
        }
    }

    public boolean isAccessControlled() {
        return this.accessControl != null;
    }

    private void initComponent() throws DevFailed {
        root = new DefaultMutableTreeNode("Control System");
        this.initTangoObjects();
        this.createNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                AstorTree.this.hostSelectionPerformed(treeSelectionEvent);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                AstorTree.this.collapsedPerformed(treeExpansionEvent);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AstorTree.this.treeMouseClicked(mouseEvent);
            }
        });
        this.setExpandsSelectedPaths(true);
    }

    private void initTangoObjects() throws DevFailed {
        String string = AstorUtil.getTangoHost();
        if (string == null || string.length() == 0) {
            Except.throw_connection_failed((String)"TangoApi_TANGO_HOST_NOT_SET", (String)"TANGO_HOST is not set", (String)"AstorTree.initTangoObjects()");
        }
        StringTokenizer stringTokenizer = string != null && string.indexOf(",") > 0 ? new StringTokenizer(string, ",") : new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.dbase = new DbaseObject[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.dbase[i] = new DbaseObject(this, (String)arrayList.get(i));
        }
        AstorUtil astorUtil = AstorUtil.getInstance();
        this.hosts = astorUtil.getTangoHostList();
        collecNames = astorUtil.getCollectionList(this.hosts);
        String string2 = AstorUtil.getAccessControlDeviceName();
        if (string2 != null) {
            this.accessControl = new TACobject(this, string2);
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.updateSplashThread = new UpdateSplashThread(this.hosts.length);
        this.updateSplashThread.start();
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (String string : collecNames) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            arrayList.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        for (DbaseObject dbaseObject : this.dbase) {
            ((DefaultMutableTreeNode)arrayList.get(0)).add(new DefaultMutableTreeNode(dbaseObject));
        }
        if (this.accessControl != null) {
            ((DefaultMutableTreeNode)arrayList.get(0)).add(new DefaultMutableTreeNode(this.accessControl));
        }
        int n = 0;
        for (TangoHost tangoHost : this.hosts) {
            this.updateSplashThread.wakeUp(n++, "Creating " + (Object)((Object)tangoHost) + " node");
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((Object)tangoHost);
            tangoHost.state = 0;
            int n2 = this.getHostCollection(tangoHost);
            ((DefaultMutableTreeNode)arrayList.get(n2)).add(defaultMutableTreeNode3);
        }
        this.updateSplashThread.stopThread();
    }

    ArrayList<String> getCollectionList() {
        return collecNames;
    }

    private int getHostCollection(TangoHost tangoHost) {
        for (int i = 0; i < collecNames.size(); ++i) {
            if (tangoHost.collection == null) {
                return collecNames.size() - 1;
            }
            if (!tangoHost.collection.equals(collecNames.get(i))) continue;
            return i;
        }
        return collecNames.size() - 1;
    }

    public void collapsedPerformed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        boolean bl = ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getUserObject() instanceof DbaseObject;
        if (treePath.getPathCount() == 1 || bl) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
            Object[] objectArray = defaultMutableTreeNode2.getPath();
            this.setExpandedState(new TreePath(objectArray), true);
            if (treePath.getPathCount() == 1) {
                String string = "TANGO Control System\n\n";
                string = string + this.hosts.length + " hosts controlled.\n";
                int n = 0;
                for (TangoHost tangoHost : this.hosts) {
                    if (!tangoHost.onEvents) continue;
                    ++n;
                }
                if (n == this.hosts.length) {
                    string = string + "All are controlled on events.";
                } else if (n > 0) {
                    string = string + n + " are controlled on events.";
                }
                Utils.popupMessage(this.parent, string, "tango_icon.jpg");
            }
        }
    }

    private Rectangle computeBounds(TreePath treePath) {
        this.scrollPathToVisible(treePath);
        Rectangle rectangle = this.getPathBounds(treePath);
        if (rectangle != null) {
            Point point = rectangle.getLocation();
            SwingUtilities.convertPointToScreen(point, this);
            rectangle.setLocation(point);
            rectangle.width += 20;
            rectangle.height += 2;
        }
        return rectangle;
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    void changeNodeName() {
        Rectangle rectangle = this.computeBounds(this.getSelectionPath());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        RenameDialog renameDialog = new RenameDialog((Frame)this.parent, defaultMutableTreeNode.toString(), rectangle);
        if (renameDialog.showDlg()) {
            String string = renameDialog.getNewName();
            try {
                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
                int n = defaultMutableTreeNode2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextNode();
                    TangoHost tangoHost = (TangoHost)((Object)defaultMutableTreeNode2.getUserObject());
                    tangoHost.setCollection(string);
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                return;
            }
            defaultMutableTreeNode.setUserObject(string);
        }
    }

    void addBranch(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
        collecNames.add(string);
    }

    void moveNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        Object[] objectArray = new String[collecNames.size() - 1];
        int n = 0;
        for (int i = 1; i < collecNames.size(); ++i) {
            if (collecNames.get(i).equals(defaultMutableTreeNode2.toString())) continue;
            objectArray[n++] = collecNames.get(i);
        }
        objectArray[n] = "New Branch";
        String string = (String)JOptionPane.showInputDialog(this, "Move " + defaultMutableTreeNode + "  to :", "", 1, null, objectArray, objectArray[0]);
        if (string != null) {
            if (string.equals(objectArray[n])) {
                string = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
                if (string == null) {
                    return;
                }
                this.addBranch(string);
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)root.getChildAt(i);
                if (!defaultMutableTreeNode3.toString().equals(string)) continue;
                try {
                    object = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
                    ((TangoHost)((Object)object)).setCollection(string);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
                    return;
                }
                object = (DefaultTreeModel)this.getModel();
                ((DefaultTreeModel)object).removeNodeFromParent(defaultMutableTreeNode);
                ((DefaultTreeModel)object).insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode3, 0);
                if (defaultMutableTreeNode2.getChildCount() == 0) {
                    ((DefaultTreeModel)object).removeNodeFromParent(defaultMutableTreeNode2);
                    collecNames.remove(defaultMutableTreeNode2.toString());
                }
                this.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
                Object[] objectArray2 = defaultMutableTreeNode.getPath();
                this.setSelectionPath(new TreePath(objectArray2));
            }
        }
    }

    public void hostSelectionPerformed(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            if (object instanceof TangoHost) {
                this.selectedHost = (TangoHost)((Object)object);
                this.selected_db = null;
            } else if (object instanceof DbaseObject) {
                this.selectedHost = null;
                this.selected_db = (DbaseObject)object;
            } else {
                this.selectedHost = null;
                this.selected_db = null;
            }
        } else {
            this.selectedHost = null;
            this.selected_db = null;
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.setSelectionPath(treePath);
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2) {
            if ((n & 0x10) != 0) {
                if (this.selectedHost != null) {
                    this.displayHostInfo();
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (this.selected_db != null || object.toString().equals(collecNames.get(0))) {
                        this.displayJiveAppli();
                    }
                }
            }
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if ((n & 4) != 0) {
                if (object instanceof DbaseObject) {
                    this.dbMenu.showMenu(mouseEvent);
                } else if (object instanceof TACobject) {
                    this.tacMenu.showMenu(mouseEvent);
                } else {
                    this.pMenu.showMenu(mouseEvent);
                }
            }
        }
    }

    public void setSelectionRoot() {
        this.setSelectionPath(new TreePath(root.getPath()));
    }

    public void setSelectionPath(String string) throws DevFailed {
        boolean bl = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)root.getChildAt(i);
            for (int j = 0; j < defaultMutableTreeNode.getChildCount(); ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TangoHost)) continue;
                String string2 = defaultMutableTreeNode2.toString();
                int n = string2.indexOf(40);
                if (n > 0) {
                    string2 = string2.substring(0, n).trim();
                }
                if (!string2.equals(string)) continue;
                this.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                bl = true;
            }
        }
        if (!bl) {
            Except.throw_exception((String)"HOST_NOT_FOUND", (String)(string + "  is not controlled by Astor !"), (String)"AstorTree.setSelectionPath()");
        }
    }

    void displayJiveAppli() {
        if (this.selected_db != null && this.selected_db.state == 1) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)this.selected_db.except);
        } else {
            boolean bl = false;
            boolean bl2 = AstorUtil.getInstance().jiveIsReadOnly();
            if (Astor.rwMode != 0) {
                bl2 = true;
            }
            if (this.jive_is_read_only != bl2 || this.jive3 == null) {
                this.jive3 = new MainPanel(bl, bl2);
            }
            this.jive3.setVisible(true);
            this.jive3.toFront();
            this.jive_is_read_only = bl2;
        }
    }

    public void showJive(TangoServer tangoServer) {
        this.displayJiveAppli();
        this.jive3.goToServerNode(tangoServer.getName());
    }

    void changeHostNode(TangoHost tangoHost) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        int n = 0;
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
            n = i;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode((Object)tangoHost);
        this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        Object[] objectArray = defaultMutableTreeNode3.getPath();
        this.setSelectionPath(new TreePath(objectArray));
    }

    public void displayHostInfoDialog(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            string = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string, ".");
            string = stringTokenizer.nextToken();
            this.parent.setVisible(true);
            this.setSelectionPath(new TreePath(root.getPath()));
            this.setSelectionPath(string);
            this.displayHostInfo();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    public void displayHostInfo(String string) {
        try {
            String string2 = new IORdump(string).get_host();
            if (string2 == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            string2 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string2, ".");
            string2 = stringTokenizer.nextToken();
            this.parent.setVisible(true);
            this.setSelectionPath(new TreePath(root.getPath()));
            this.setSelectionPath(string2);
            this.displayHostInfo();
            String string3 = new DeviceProxy(string).adm_name();
            string3 = string3.substring(string3.indexOf(47) + 1);
            HostInfoDialog hostInfoDialog = this.hostDialogs.getByHostName(this.selectedHost);
            if (hostInfoDialog != null) {
                hostInfoDialog.setSelection(string3);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    public void displayHostInfo() {
        if (this.selectedHost == null) {
            Utils.popupError(this, "this Host is not controlled by Astor !");
            return;
        }
        this.selectedHost.updateData();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.selectedHost.state == 1 && this.selectedHost.except != null) {
            String string = this.selectedHost.except.errors[0].reason;
            String string2 = this.selectedHost.except.errors[0].desc;
            if (string.equals("TangoApi_DEVICE_NOT_EXPORTED") || string2.indexOf("CORBA.TRANSIENT: Retries exceeded,") > 0) {
                if (AstorUtil.osIsUnix()) {
                    if (JOptionPane.showConfirmDialog(this.parent, "Starter is not running on " + (Object)((Object)this.selectedHost) + "\n\n\n" + "Do you want a remote login to start it ?", "Dialog", 0) == 0) {
                        new RemoteLoginThread(this.selectedHost.getName(), this.parent).start();
                    }
                } else {
                    Utils.popupError(this.parent, "Starter is not running on " + (Object)((Object)this.selectedHost) + " !!!");
                }
            } else {
                ErrorPane.showErrorMessage((Component)this.parent, (String)("Starter on " + (Object)((Object)this.selectedHost)), (DevFailed)this.selectedHost.except);
            }
        } else if (this.selectedHost.state == 0) {
            Utils.popupMessage(this.parent, "Connection with Starter device server is blocked !");
        } else if (this.parent instanceof Astor) {
            this.hostDialogs.add((Astor)this.parent, this.selectedHost);
        }
    }

    void resetCollectionStatistics() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
            TangoHost tangoHost = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
            arrayList.add(tangoHost.name());
        }
        if (JOptionPane.showConfirmDialog(this.parent, "Do you want to reset statistics on " + arrayList.size() + " hosts  ?", "Dialog", 0) == 0) {
            new ResetStatistics(this.parent);
        }
    }

    void displayBranchInfo() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        String string = defaultMutableTreeNode + ":\n\n";
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
            TangoHost tangoHost = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
            string = string + tangoHost.hostStatus();
        }
        Utils.popupMessage(this.parent, string);
    }

    public void startTACpanel() {
        try {
            if (this.tangoAccessPanel == null || !this.tangoAccessPanel.isVisible()) {
                if (TangoAccess.checkPassword(this.parent) == 0) {
                    this.tangoAccessPanel = new TangoAccess(this.parent);
                } else {
                    return;
                }
            }
            this.tangoAccessPanel.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)devFailed);
        }
    }

    public void updateState() {
        this.repaint();
        if (this.hostDialogs != null && this.hosts != null) {
            for (TangoHost tangoHost : this.hosts) {
                if (tangoHost.state != 1) continue;
                this.hostDialogs.close(tangoHost);
            }
        }
    }

    static {
        hostSubscribed = 0;
        background = new Color(240, 240, 240);
    }

    class TacPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private final String[] menuLabels = new String[]{"Server Info", "Black  Box", "Manager Panel"};
        private final int OFFSET = 2;
        private final int SERVER_INFO = 0;
        private final int BLACKBOX = 1;
        private final int MANAGER_PANEL = 2;

        TacPopupMenu(JTree jTree) {
            this.tree = jTree;
            JLabel jLabel = new JLabel("Access Control Server :");
            jLabel.setFont(new Font("Dialog", 1, 16));
            this.add(jLabel);
            this.add(new JPopupMenu.Separator());
            for (String string : this.menuLabels) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TacPopupMenu.this.treeActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent) {
            Object object = AstorTree.this.getSelectedObject();
            JLabel jLabel = (JLabel)this.getComponent(0);
            jLabel.setText(object.toString() + "  :");
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
            this.getComponent(4).setEnabled(Astor.rwMode == 0);
        }

        private void treeActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            TACobject tACobject = (TACobject)AstorTree.this.getSelectedObject();
            PopupText popupText = new PopupText((Frame)AstorTree.this.parent, true);
            try {
                switch (n) {
                    case 0: {
                        popupText.show(tACobject.getServerInfo());
                        break;
                    }
                    case 1: {
                        tACobject.blackbox(AstorTree.this.parent);
                        break;
                    }
                    case 2: {
                        AstorTree.this.startTACpanel();
                    }
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    class DbPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private final String[] menuLabels = new String[]{"Server Info", "Database Info", "Database Black Box", "Browse Database (Jive)"};
        private final int OFFSET = 2;
        private final int SERVER_INFO = 0;
        private final int DATABASE_INFO = 1;
        private final int DATABASE_BLACKBOX = 2;
        private final int BROWSE_DATABASE = 3;

        DbPopupMenu(JTree jTree) {
            this.tree = jTree;
            JLabel jLabel = new JLabel("Datbase Server :");
            jLabel.setFont(new Font("Dialog", 1, 16));
            this.add(jLabel);
            this.add(new JPopupMenu.Separator());
            for (String string : this.menuLabels) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DbPopupMenu.this.treeActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        public void showMenu(MouseEvent mouseEvent) {
            Object object = AstorTree.this.getSelectedObject();
            JLabel jLabel = (JLabel)this.getComponent(0);
            jLabel.setText(object.toString() + "  :");
            this.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
        }

        private void treeActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            try {
                switch (n) {
                    case 3: {
                        AstorTree.this.displayJiveAppli();
                        break;
                    }
                    default: {
                        this.manageOneDbaseOption(n);
                        break;
                    }
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }

        private void manageOneDbaseOption(int n) throws DevFailed {
            DbaseObject dbaseObject = (DbaseObject)AstorTree.this.getSelectedObject();
            PopupText popupText = new PopupText((Frame)AstorTree.this.parent, true);
            switch (n) {
                case 0: {
                    popupText.show(dbaseObject.getServerInfo());
                    break;
                }
                case 1: {
                    popupText.show(dbaseObject.getInfo());
                    break;
                }
                case 2: {
                    dbaseObject.blackbox(AstorTree.this.parent);
                }
            }
        }
    }

    class subscribeThread
    extends Thread {
        subscribeThread() {
        }

        @Override
        public void run() {
            for (TangoHost tangoHost : AstorTree.this.hosts) {
                if (!tangoHost.onEvents) continue;
                tangoHost.thread.subscribeChangeStateEvent();
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private ImageIcon dbIcon = Utils.getInstance().getIcon("MySql.gif");
        private Font[] fonts;
        private Font rootFont;

        public TangoRenderer() {
            this.tangoIcon = Utils.getInstance().getIcon("TangoLogo.gif", 0.25);
            this.fonts = new Font[2];
            this.rootFont = new Font("helvetica", 1, 24);
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            if (n == 0) {
                this.setBackgroundSelectionColor(background);
                this.setIcon(this.tangoIcon);
                this.setFont(this.rootFont);
            } else if (this.isDatabase(object)) {
                if (bl3) {
                    this.setBackgroundSelectionColor(Color.lightGray);
                    DbaseObject dbaseObject = this.getDbase(object);
                    this.setIcon(AstorUtil.state_icons[dbaseObject.state]);
                    this.setFont(this.fonts[1]);
                } else {
                    this.setBackgroundSelectionColor(background);
                    int n2 = 3;
                    for (DbaseObject dbaseObject : AstorTree.this.dbase) {
                        if (dbaseObject.state != 1) continue;
                        n2 = 1;
                    }
                    if (n2 == 1) {
                        this.setForeground(Color.red);
                    }
                    this.setIcon(this.dbIcon);
                    this.setFont(this.fonts[0]);
                }
            } else if (this.isTAC(object)) {
                this.setBackgroundSelectionColor(Color.lightGray);
                TACobject tACobject = this.getTACobject(object);
                this.setIcon(AstorUtil.state_icons[tACobject.state]);
                this.setFont(this.fonts[1]);
            } else if (this.isHost(object)) {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[1]);
                this.setBackgroundNonSelectionColor(background);
                TangoHost tangoHost = this.getHost(object);
                int n3 = tangoHost.state;
                if (n3 == 0) {
                    n3 = 5;
                }
                this.setIcon(AstorUtil.state_icons[n3]);
            } else {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setFont(this.fonts[0]);
                int n4 = this.branchState(object);
                this.setIcon(AstorUtil.state_icons[n4]);
            }
            return this;
        }

        protected int branchState(Object object) {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            int n2 = defaultMutableTreeNode.getChildCount();
            TangoHost[] tangoHostArray = new TangoHost[n2];
            for (n = 0; n < n2; ++n) {
                defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
                tangoHostArray[n] = (TangoHost)((Object)defaultMutableTreeNode.getUserObject());
            }
            n = 0;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                if (tangoHostArray[i].state == 0) {
                    return 0;
                }
                if (tangoHostArray[i].state == 1) {
                    n = 1;
                    continue;
                }
                if (tangoHostArray[i].state == 2) {
                    bl = true;
                    continue;
                }
                if (tangoHostArray[i].state != 4) continue;
                bl2 = true;
            }
            int n3 = n != 0 ? 1 : (bl2 ? 4 : (bl ? 2 : 3));
            return n3;
        }

        protected boolean isHost(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            return object2 instanceof TangoHost;
        }

        protected TangoHost getHost(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof TangoHost) {
                return (TangoHost)((Object)object2);
            }
            return null;
        }

        protected DbaseObject getDbase(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof DbaseObject) {
                return (DbaseObject)object2;
            }
            return null;
        }

        protected boolean isDatabase(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof DbaseObject) {
                return true;
            }
            if (object2 instanceof String) {
                String string = (String)object2;
                return string.equals(collecNames.get(0));
            }
            return false;
        }

        protected TACobject getTACobject(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof TACobject) {
                return (TACobject)object2;
            }
            return null;
        }

        protected boolean isTAC(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            return object2 instanceof TACobject;
        }
    }

    class UpdateSplashThread
    extends Thread {
        private String message = "";
        private int ratio;
        private boolean stop = false;

        private UpdateSplashThread(int n) {
            AstorTree.this.splash.setAlwaysOnTop(true);
            AstorTree.this.splash.setVisible(true);
            AstorTree.this.splash.setMaxProgress(n);
        }

        @Override
        public void run() {
            while (!this.stop) {
                AstorTree.this.splash.progress(this.ratio);
                AstorTree.this.splash.setMessage(this.message);
                this.doSleep();
            }
        }

        private synchronized void doSleep() {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private synchronized void wakeUp(int n, String string) {
            this.ratio = n;
            this.message = string;
            this.notify();
        }

        private synchronized void stopThread() {
            this.stop = true;
            this.notify();
        }
    }
}

