/*
 * Decompiled with CFR 0.152.
 */
package comecaTestBench;

import comecaTestBench.TestBenchConstants;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.command.ArrayArrayCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.attribute.StatusViewer;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.RestrictedFolderJFileChooser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jdoorWrapViewer.JDoorwSmoothProgressDialog;

public class TestSequencesPanel
extends JPanel
implements IDevStateScalarListener {
    private JFrame parentJFrame = null;
    private AttributeList attl = new AttributeList();
    private CommandList cmdl = new CommandList();
    private IDevStateScalar doorwStateAtt = null;
    private IStringScalar doorwStatusAtt = null;
    private INumberScalar doorwMacroProgressAtt = null;
    private INumberSpectrum doorwProgressRangeAtt = null;
    private ICommand doorwRunMacroCmd = null;
    private ICommand doorwStopMacroCmd = null;
    private INumberScalar comecaSerialNbAtt = null;
    private JDoorwSmoothProgressDialog jdwProgDialog = null;
    private String oldState = "UNKNOWN";
    private RestrictedFolderJFileChooser restrictJFC = null;
    private JPanel buttonJPanel;
    private JLabel ch1CurrentLabel;
    private JTextField ch1CurrentTextField;
    private JLabel ch2CurrentLabel;
    private JTextField ch2CurrentTextField;
    private JLabel ch3CurrentLabel;
    private JTextField ch3CurrentTextField;
    private JPanel dcInputChangeParamJPanel;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;
    private JButton fileSelJButton;
    private JButton fnameResetJButton;
    private JLabel folderNameLabel;
    private JTextField folderNameTextField;
    private JPanel globalJPanel;
    private SimpleScalarViewer hiddenSimpleScalarViewer;
    private JLabel hintJLabel;
    private JLabel ihmFwLabel;
    private JTextField ihmFwTextField;
    private VoidVoidCommandViewer macroStopVvcmdv;
    private JPanel outputFileJPanel;
    private JRadioButton seq1JRadioButton;
    private JRadioButton seq2JRadioButton;
    private JRadioButton seq3JRadioButton;
    private JButton seqExecuteJButton;
    private ButtonGroup seqNameButtonGroup;
    private JPanel seqSelectionJPanel;
    private JPanel sequenceJPanel;
    private JLabel serialNumberLabel;
    private JTextField serialNumberTextField;
    private JPanel stateStatusJPanel;
    private StateViewer stateViewer1;
    private StatusViewer statusViewer1;

    public TestSequencesPanel(JFrame parent) {
        this.parentJFrame = parent;
        this.initComponents();
        this.initProgressBar();
        this.attl = new AttributeList();
        this.attl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.attl.addSetErrorListener((ISetErrorListener)ErrorPopup.getInstance());
        this.cmdl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
        this.connectToAttributesAndCommands();
        this.setPreferredSize(new Dimension(600, 500));
        this.seq1JRadioButton.doClick();
        this.attl.startRefresher();
        this.hiddenSimpleScalarViewer.setVisible(false);
        this.initFileParameters();
        this.restrictJFC = new RestrictedFolderJFileChooser(TestBenchConstants.SEQ_OUTPUT_FOLDER);
    }

    private void initProgressBar() {
        this.jdwProgDialog = new JDoorwSmoothProgressDialog("In Progress ...", this.parentJFrame);
        this.jdwProgDialog.setSize(200, 50);
        this.jdwProgDialog.setProgressMaxValue(100);
        this.jdwProgDialog.setDoorDevice(TestBenchConstants.JDOOR_WRAPPER_PROXY, 1);
    }

    private String buildAutoFileName() {
        String fname = new String(TestBenchConstants.SEQ_FILE_PREFIX);
        Date dNow = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HHmm");
        if (this.hiddenSimpleScalarViewer.getNumberModel() != null) {
            String strValue = this.hiddenSimpleScalarViewer.getText();
            System.out.println("k" + strValue.trim() + "k");
            if (strValue != null && !strValue.isEmpty()) {
                fname = fname.concat(strValue.trim());
                fname = fname.concat("_");
            }
        }
        String dateStr = sdf.format(dNow);
        fname = fname.concat(dateStr);
        System.out.println("getAutoFileName : " + fname);
        return fname;
    }

    void initFileParameters() {
        this.folderNameTextField.setText(TestBenchConstants.SEQ_OUTPUT_FOLDER);
        this.fileNameTextField.setText(this.buildAutoFileName());
    }

    String getSelectedMacroName() {
        if (this.seq1JRadioButton.isSelected()) {
            return "CurrentLinearity";
        }
        if (this.seq2JRadioButton.isSelected()) {
            return "VoltageLinearity";
        }
        if (this.seq3JRadioButton.isSelected()) {
            return "DcInputChange";
        }
        return "dummy";
    }

    int getIhmFwVersionNumber() {
        String ihmstr = this.ihmFwTextField.getText();
        if (ihmstr == null) {
            return 0;
        }
        try {
            int ihmFwVersion = Integer.parseInt(ihmstr);
            return ihmFwVersion;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    String getSerialNumber() throws IllegalArgumentException {
        String serialN = this.serialNumberTextField.getText();
        if (serialN == null) {
            throw new IllegalArgumentException("Serial Number field is empty");
        }
        if (serialN.isEmpty()) {
            throw new IllegalArgumentException("Serial Number field is empty");
        }
        return serialN;
    }

    String getAbsoluteFileName() throws IllegalArgumentException {
        String folderName = this.folderNameTextField.getText();
        if (folderName == null) {
            throw new IllegalArgumentException("Folder field is empty");
        }
        if (folderName.isEmpty()) {
            throw new IllegalArgumentException("Folder field is empty");
        }
        String filename = this.fileNameTextField.getText();
        if (filename == null) {
            throw new IllegalArgumentException("File name is empty");
        }
        if (filename.isEmpty()) {
            throw new IllegalArgumentException("File name is empty");
        }
        String absfname = folderName + "/" + filename;
        return absfname;
    }

    double getChannelCurrent(int channelnb) throws IllegalArgumentException {
        JTextField jtf;
        switch (channelnb) {
            case 1: {
                jtf = this.ch1CurrentTextField;
                break;
            }
            case 2: {
                jtf = this.ch2CurrentTextField;
                break;
            }
            case 3: {
                jtf = this.ch3CurrentTextField;
                break;
            }
            default: {
                jtf = null;
            }
        }
        if (jtf == null) {
            throw new IllegalArgumentException("The channel number is wrong");
        }
        String chCurrentStr = jtf.getText();
        if (chCurrentStr == null) {
            throw new IllegalArgumentException("Channel current is empty");
        }
        if (chCurrentStr.isEmpty()) {
            throw new IllegalArgumentException("Channel current is empty");
        }
        try {
            double channelCurrent = Double.parseDouble(chCurrentStr);
            return channelCurrent;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Channel current is not a double");
        }
    }

    void executeMacro(String macroName, String absFilePath, int ihmv, String serialNb) {
        ArrayList<String> listArg = new ArrayList<String>();
        int argNb = 0;
        listArg.add(argNb, macroName);
        ++argNb;
        if (macroName.equalsIgnoreCase("DcInputChange")) {
            for (int i = 0; i < 3; ++i) {
                try {
                    double chCurrent = this.getChannelCurrent(i + 1);
                    listArg.add(argNb, Double.toString(chCurrent));
                    ++argNb;
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(this, "Failed to get the value for the channel " + (i + 1) + " current", "Channel " + (i + 1) + "current error", 0);
                    return;
                }
            }
        }
        listArg.add(argNb, absFilePath);
        listArg.add(++argNb, Integer.toString(ihmv));
        listArg.add(++argNb, serialNb);
        this.doorwRunMacroCmd.execute(listArg);
    }

    private void initComponents() {
        this.seqNameButtonGroup = new ButtonGroup();
        this.stateStatusJPanel = new JPanel();
        this.stateViewer1 = new StateViewer();
        this.statusViewer1 = new StatusViewer();
        this.globalJPanel = new JPanel();
        this.ihmFwLabel = new JLabel();
        this.ihmFwTextField = new JTextField();
        this.serialNumberLabel = new JLabel();
        this.serialNumberTextField = new JTextField();
        this.outputFileJPanel = new JPanel();
        this.folderNameLabel = new JLabel();
        this.folderNameTextField = new JTextField();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.fileSelJButton = new JButton();
        this.fnameResetJButton = new JButton();
        this.sequenceJPanel = new JPanel();
        this.seqSelectionJPanel = new JPanel();
        this.seq1JRadioButton = new JRadioButton();
        this.seq2JRadioButton = new JRadioButton();
        this.seq3JRadioButton = new JRadioButton();
        this.dcInputChangeParamJPanel = new JPanel();
        this.hintJLabel = new JLabel();
        this.ch1CurrentLabel = new JLabel();
        this.ch1CurrentTextField = new JTextField();
        this.ch2CurrentLabel = new JLabel();
        this.ch2CurrentTextField = new JTextField();
        this.ch3CurrentLabel = new JLabel();
        this.ch3CurrentTextField = new JTextField();
        this.buttonJPanel = new JPanel();
        this.seqExecuteJButton = new JButton();
        this.macroStopVvcmdv = new VoidVoidCommandViewer();
        this.hiddenSimpleScalarViewer = new SimpleScalarViewer();
        this.setLayout(new GridBagLayout());
        this.stateStatusJPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.stateStatusJPanel.add((Component)this.stateViewer1, gridBagConstraints);
        this.statusViewer1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.stateStatusJPanel.add((Component)this.statusViewer1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.add((Component)this.stateStatusJPanel, gridBagConstraints);
        this.globalJPanel.setLayout(new GridBagLayout());
        this.ihmFwLabel.setFont(new Font("Dialog", 1, 14));
        this.ihmFwLabel.setText("Visu Software Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 7, 7, 7);
        this.globalJPanel.add((Component)this.ihmFwLabel, gridBagConstraints);
        this.ihmFwTextField.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 7, 7);
        this.globalJPanel.add((Component)this.ihmFwTextField, gridBagConstraints);
        this.serialNumberLabel.setFont(new Font("Dialog", 1, 14));
        this.serialNumberLabel.setText("Serial Number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 7, 7, 7);
        this.globalJPanel.add((Component)this.serialNumberLabel, gridBagConstraints);
        this.serialNumberTextField.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 7, 7);
        this.globalJPanel.add((Component)this.serialNumberTextField, gridBagConstraints);
        this.outputFileJPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output File"));
        this.outputFileJPanel.setLayout(new GridBagLayout());
        this.folderNameLabel.setFont(new Font("Dialog", 1, 14));
        this.folderNameLabel.setText("Folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.outputFileJPanel.add((Component)this.folderNameLabel, gridBagConstraints);
        this.folderNameTextField.setFont(new Font("Dialog", 0, 14));
        this.folderNameTextField.setText(TestBenchConstants.SEQ_OUTPUT_FOLDER);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.outputFileJPanel.add((Component)this.folderNameTextField, gridBagConstraints);
        this.fileNameLabel.setFont(new Font("Dialog", 1, 14));
        this.fileNameLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.outputFileJPanel.add((Component)this.fileNameLabel, gridBagConstraints);
        this.fileNameTextField.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.outputFileJPanel.add((Component)this.fileNameTextField, gridBagConstraints);
        this.fileSelJButton.setText("Select ...");
        this.fileSelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestSequencesPanel.this.fileSelJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.outputFileJPanel.add((Component)this.fileSelJButton, gridBagConstraints);
        this.fnameResetJButton.setText("Reset File Name");
        this.fnameResetJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestSequencesPanel.this.fnameResetJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.outputFileJPanel.add((Component)this.fnameResetJButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.globalJPanel.add((Component)this.outputFileJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 9, 5);
        this.add((Component)this.globalJPanel, gridBagConstraints);
        this.sequenceJPanel.setBorder(BorderFactory.createEtchedBorder());
        this.sequenceJPanel.setLayout(new GridBagLayout());
        this.seqSelectionJPanel.setBorder(BorderFactory.createTitledBorder("Sequence selection"));
        this.seqSelectionJPanel.setLayout(new GridBagLayout());
        this.seqNameButtonGroup.add(this.seq1JRadioButton);
        this.seq1JRadioButton.setText("seq1JRadioButton");
        this.seq1JRadioButton.setText("CurrentLinearity");
        this.seq1JRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestSequencesPanel.this.seq1JRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.seqSelectionJPanel.add((Component)this.seq1JRadioButton, gridBagConstraints);
        this.seqNameButtonGroup.add(this.seq2JRadioButton);
        this.seq2JRadioButton.setText("seq2JRadioButton");
        this.seq2JRadioButton.setText("VoltageLinearity");
        this.seq2JRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestSequencesPanel.this.seq2JRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.seqSelectionJPanel.add((Component)this.seq2JRadioButton, gridBagConstraints);
        this.seqNameButtonGroup.add(this.seq3JRadioButton);
        this.seq3JRadioButton.setText("seq3JRadioButton");
        this.seq3JRadioButton.setText("DcInputChange");
        this.seq3JRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestSequencesPanel.this.seq3JRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.seqSelectionJPanel.add((Component)this.seq3JRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 9);
        this.sequenceJPanel.add((Component)this.seqSelectionJPanel, gridBagConstraints);
        this.dcInputChangeParamJPanel.setBorder(BorderFactory.createTitledBorder("Currents"));
        this.dcInputChangeParamJPanel.setLayout(new GridBagLayout());
        this.hintJLabel.setFont(new Font("Dialog", 3, 12));
        this.hintJLabel.setText("Unit is Amp");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(8, 5, 8, 5);
        this.dcInputChangeParamJPanel.add((Component)this.hintJLabel, gridBagConstraints);
        this.ch1CurrentLabel.setFont(new Font("Dialog", 1, 14));
        this.ch1CurrentLabel.setText("channel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dcInputChangeParamJPanel.add((Component)this.ch1CurrentLabel, gridBagConstraints);
        this.ch1CurrentTextField.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dcInputChangeParamJPanel.add((Component)this.ch1CurrentTextField, gridBagConstraints);
        this.ch2CurrentLabel.setFont(new Font("Dialog", 1, 14));
        this.ch2CurrentLabel.setText("channel2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dcInputChangeParamJPanel.add((Component)this.ch2CurrentLabel, gridBagConstraints);
        this.ch2CurrentTextField.setFont(new Font("Dialog", 0, 14));
        this.ch2CurrentTextField.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dcInputChangeParamJPanel.add((Component)this.ch2CurrentTextField, gridBagConstraints);
        this.ch3CurrentLabel.setFont(new Font("Dialog", 1, 14));
        this.ch3CurrentLabel.setText("channel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dcInputChangeParamJPanel.add((Component)this.ch3CurrentLabel, gridBagConstraints);
        this.ch3CurrentTextField.setFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.dcInputChangeParamJPanel.add((Component)this.ch3CurrentTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(8, 5, 10, 5);
        this.sequenceJPanel.add((Component)this.dcInputChangeParamJPanel, gridBagConstraints);
        this.buttonJPanel.setLayout(new GridBagLayout());
        this.seqExecuteJButton.setText("Run Sequence");
        this.seqExecuteJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestSequencesPanel.this.seqExecuteJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonJPanel.add((Component)this.seqExecuteJButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.buttonJPanel.add((Component)this.macroStopVvcmdv, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.sequenceJPanel.add((Component)this.buttonJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.sequenceJPanel, gridBagConstraints);
        this.hiddenSimpleScalarViewer.setText("Not Displayed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.hiddenSimpleScalarViewer, gridBagConstraints);
    }

    private void seq3JRadioButtonActionPerformed(ActionEvent evt) {
        this.dcInputChangeParamJPanel.setVisible(this.seq3JRadioButton.isSelected());
    }

    private void seq1JRadioButtonActionPerformed(ActionEvent evt) {
        this.dcInputChangeParamJPanel.setVisible(this.seq3JRadioButton.isSelected());
    }

    private void seq2JRadioButtonActionPerformed(ActionEvent evt) {
        this.dcInputChangeParamJPanel.setVisible(this.seq3JRadioButton.isSelected());
    }

    private void seqExecuteJButtonActionPerformed(ActionEvent evt) {
        String serialNb;
        String fabsName;
        if (this.doorwRunMacroCmd == null) {
            JOptionPane.showMessageDialog(this, "Failed to connect to RunMacro command.", "RunMacro connection error", 0);
            return;
        }
        try {
            fabsName = this.getAbsoluteFileName();
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(this, "Failed to get absolute file name", "File Name error", 0);
            return;
        }
        try {
            serialNb = this.getSerialNumber();
        }
        catch (IllegalArgumentException iae) {
            JOptionPane.showMessageDialog(this, "Failed to get the serial number", "Serial Number error", 0);
            return;
        }
        int ihmFwVersion = this.getIhmFwVersionNumber();
        this.executeMacro(this.getSelectedMacroName(), fabsName, ihmFwVersion, serialNb);
    }

    private void fileSelJButtonActionPerformed(ActionEvent evt) {
        File selectedFile = null;
        this.restrictJFC.setSelectedFile(new File(this.fileNameTextField.getText()));
        selectedFile = this.restrictJFC.showDialog((Component)this.getRootPane(), "Set Output File Name", null);
        if (selectedFile == null) {
            return;
        }
        String absFileName = selectedFile.getAbsolutePath();
        String relativeFileName = absFileName.substring(absFileName.lastIndexOf("/") + 1);
        String folderName = absFileName.substring(0, absFileName.lastIndexOf("/"));
        this.folderNameTextField.setText(folderName);
        this.fileNameTextField.setText(relativeFileName);
    }

    private void fnameResetJButtonActionPerformed(ActionEvent evt) {
        this.initFileParameters();
    }

    private void connectToAttributesAndCommands() {
        IEntity oneEntity;
        String entityname;
        String msgatt = "Cannot connect to the attribute : ";
        String msgcmd = "Cannot connect to the command : ";
        String msg = null;
        this.doorwStateAtt = TestBenchConstants.JDOOR_WRAPPER_PROXY.getJDoorw1StateAtt();
        if (this.doorwStateAtt != null) {
            this.doorwStateAtt.addDevStateScalarListener((IDevStateScalarListener)this);
            this.stateViewer1.setModel(this.doorwStateAtt);
        }
        this.doorwStatusAtt = TestBenchConstants.JDOOR_WRAPPER_PROXY.getJDoorw1StatusAtt();
        if (this.doorwStatusAtt != null) {
            this.statusViewer1.setModel(this.doorwStatusAtt);
        }
        try {
            entityname = "test/doorwrap-bench/1/RunMacro";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof ArrayArrayCommand) {
                this.doorwRunMacroCmd = (ICommand)oneEntity;
                this.seqExecuteJButton.setToolTipText(this.doorwRunMacroCmd.getName());
            }
            entityname = "test/doorwrap-bench/1/StopMacro";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof VoidVoidCommand) {
                this.doorwStopMacroCmd = (ICommand)oneEntity;
                this.macroStopVvcmdv.setModel(this.doorwStopMacroCmd);
                this.macroStopVvcmdv.setToolTipText(this.doorwStopMacroCmd.getName());
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + "test/doorwrap-bench/1" + " is responding?\n", "TestSequencesPanel : Command connection", 0);
        }
        try {
            entityname = "test/ps-conv-rack/1/SerialNumber";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof INumberScalar) {
                this.comecaSerialNbAtt = (INumberScalar)oneEntity;
                this.hiddenSimpleScalarViewer.setModel(this.comecaSerialNbAtt);
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + "test/ps-conv-rack/1" + " is responding?\n", "TestSequencesPanel : Attribute connection", 0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jf = new JFrame();
                jf.setDefaultCloseOperation(3);
                TestSequencesPanel testPanel = new TestSequencesPanel(jf);
                jf.setContentPane(testPanel);
                jf.pack();
                jf.setVisible(true);
            }
        });
    }

    public void devStateScalarChange(DevStateScalarEvent dsse) {
        if (this.oldState.equalsIgnoreCase(dsse.getValue())) {
            return;
        }
        this.oldState = dsse.getValue();
        if (this.jdwProgDialog == null) {
            return;
        }
        final String newState = dsse.getValue();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ATKGraphicsUtils.centerDialog((Dialog)TestSequencesPanel.this.jdwProgDialog);
                TestSequencesPanel.this.jdwProgDialog.setVisible(newState.equalsIgnoreCase("RUNNING"));
            }
        });
    }

    public void stateChange(AttributeStateEvent ase) {
    }

    public void errorChange(ErrorEvent ee) {
    }
}

