/*
 * Decompiled with CFR 0.152.
 */
package comecaTestBench;

import comecaTestBench.SettingsWindow;
import comecaTestBench.TestBenchConstants;
import comecaTestBench.TestBenchTrendWindow;
import comecaTestBench.TestSequencesPanel;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.jdraw.SynopticFileViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jdoorWrapViewer.JDoorwMsgFrame;

public class TestBenchMainWindow
extends JFrame {
    private CommandList cmdl = new CommandList();
    private VoidVoidCommand dmm1TakeMeasureCmd = null;
    private VoidVoidCommand dmm2TakeMeasureCmd = null;
    private VoidVoidCommand pmTakeMeasureCmd = null;
    private SettingsWindow setWind = null;
    private TestBenchTrendWindow trendWindow = null;
    private TestSequencesPanel testSeqPanel = null;
    private JDoorwMsgFrame jdoorwLogWindow = null;
    private final GregorianCalendar calendar = new GregorianCalendar();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss");
    private JLabel dateTimeLabel;
    private JMenuItem diagJMenuItem;
    private JMenuItem errHistJMenuItem;
    private JMenu fileJMenu;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JMenuItem quitJMenuItem;
    private JButton refreshJButton;
    private JMenuItem seqLogJMenuItem;
    private JMenuItem settingsJMenuItem;
    private SynopticFileViewer synopticFileViewer1;
    private JPanel synopticJPanel;
    private JPanel testJPanel;
    private JMenuItem trendJMenuItem;
    private JMenu viewJMenu;

    public TestBenchMainWindow() {
        this.initComponents();
        try {
            this.synopticFileViewer1.setErrorHistoryWindow(TestBenchConstants.errorHistory);
            this.synopticFileViewer1.setAutoZoom(true);
        }
        catch (Exception setErrwExcept) {
            System.out.println("Cannot set Error History Window for Synoptic");
        }
        InputStream jdFileInStream = TestBenchMainWindow.class.getClassLoader().getResourceAsStream("comecaTB.jdw");
        if (jdFileInStream == null) {
            JOptionPane.showMessageDialog(null, "Failed to get the inputStream for the synoptic file resource : /comecaTestBench/comecaTB.jdw \n\n", "Resource error", 0);
            System.exit(-1);
        }
        InputStreamReader inStrReader = new InputStreamReader(jdFileInStream);
        try {
            this.synopticFileViewer1.loadSynopticFromStream(inStrReader);
            this.synopticFileViewer1.setToolTipMode(3);
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(null, "Cannot find load the synoptic input stream reader.\n Application will abort ...\n" + ioex, "Resource access failed", 0);
            System.exit(-1);
        }
        catch (MissingResourceException mrEx) {
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : comecaTB.jdw.\n Application will abort ...\n" + mrEx, "Cannot parse the file", 0);
            System.exit(-1);
        }
        this.cmdl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
        try {
            IEntity ie = this.cmdl.add("test/k2701/curr/TakeMeasurement");
            if (ie instanceof VoidVoidCommand) {
                this.dmm1TakeMeasureCmd = (VoidVoidCommand)ie;
            }
            if ((ie = this.cmdl.add("test/k2701/volt/TakeMeasurement")) instanceof VoidVoidCommand) {
                this.dmm2TakeMeasureCmd = (VoidVoidCommand)ie;
            }
            if ((ie = this.cmdl.add("test/lmg670/1/TakeMeasurement")) instanceof VoidVoidCommand) {
                this.pmTakeMeasureCmd = (VoidVoidCommand)ie;
            }
        }
        catch (ConnectionException ce) {
            // empty catch block
        }
        if (this.dmm1TakeMeasureCmd == null || this.dmm2TakeMeasureCmd == null || this.pmTakeMeasureCmd == null) {
            this.refreshJButton.setEnabled(false);
        }
        this.setWind = new SettingsWindow();
        this.trendWindow = new TestBenchTrendWindow();
        this.testSeqPanel = new TestSequencesPanel(this);
        this.jdoorwLogWindow = new JDoorwMsgFrame(TestBenchConstants.JDOOR_WRAPPER_PROXY);
        this.jdoorwLogWindow.setTitle("Sequence Log Messages");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.testJPanel.add((Component)this.testSeqPanel, gbc);
        this.startDateRefreshThread();
        this.setTitle("Comeca Test Bench " + TestBenchConstants.APPLI_VERSION_TAG);
        ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        this.pack();
    }

    private void updateDateTimeLabel(String newDateTime) {
        final String newText = newDateTime;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestBenchMainWindow.this.dateTimeLabel.setText(newText);
            }
        });
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.synopticJPanel = new JPanel();
        this.refreshJButton = new JButton();
        this.synopticFileViewer1 = new SynopticFileViewer();
        this.dateTimeLabel = new JLabel();
        this.testJPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.fileJMenu = new JMenu();
        this.quitJMenuItem = new JMenuItem();
        this.viewJMenu = new JMenu();
        this.settingsJMenuItem = new JMenuItem();
        this.trendJMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.seqLogJMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.errHistJMenuItem = new JMenuItem();
        this.diagJMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.synopticJPanel.setLayout(new GridBagLayout());
        this.refreshJButton.setText("Refresh");
        this.refreshJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.refreshJButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.synopticJPanel.add((Component)this.refreshJButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.synopticJPanel.add((Component)this.synopticFileViewer1, gridBagConstraints);
        this.dateTimeLabel.setFont(new Font("Dialog", 1, 16));
        this.dateTimeLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 12);
        this.synopticJPanel.add((Component)this.dateTimeLabel, gridBagConstraints);
        this.jTabbedPane1.addTab("Synoptic", this.synopticJPanel);
        this.testJPanel.setLayout(new GridBagLayout());
        this.jTabbedPane1.addTab("Test", this.testJPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.fileJMenu.setText("File");
        this.quitJMenuItem.setText("Quit");
        this.quitJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.quitJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.quitJMenuItem);
        this.jMenuBar1.add(this.fileJMenu);
        this.viewJMenu.setText("View");
        this.settingsJMenuItem.setText("Settings ...");
        this.settingsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.settingsJMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.settingsJMenuItem);
        this.trendJMenuItem.setText("Trends ....");
        this.trendJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.trendJMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.trendJMenuItem);
        this.viewJMenu.add(this.jSeparator1);
        this.seqLogJMenuItem.setText("Sequence Logs ...");
        this.seqLogJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.seqLogJMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.seqLogJMenuItem);
        this.viewJMenu.add(this.jSeparator2);
        this.errHistJMenuItem.setText("Error History ...");
        this.errHistJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.errHistJMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.errHistJMenuItem);
        this.diagJMenuItem.setText("Diagnostic ...");
        this.diagJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestBenchMainWindow.this.diagJMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.diagJMenuItem);
        this.jMenuBar1.add(this.viewJMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void quitJMenuItemActionPerformed(ActionEvent evt) {
        this.endApplication();
    }

    private void errHistJMenuItemActionPerformed(ActionEvent evt) {
        TestBenchConstants.errorHistory.setVisible(true);
    }

    private void diagJMenuItemActionPerformed(ActionEvent evt) {
        ATKDiagnostic.showDiagnostic();
    }

    private void refreshJButtonActionPerformed(ActionEvent evt) {
        this.dmm1TakeMeasureCmd.execute();
        this.dmm2TakeMeasureCmd.execute();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pmTakeMeasureCmd.execute();
    }

    private void settingsJMenuItemActionPerformed(ActionEvent evt) {
        if (this.setWind != null) {
            ATKGraphicsUtils.centerFrame((JComponent)this.getRootPane(), (Frame)this.setWind);
            this.setWind.setVisible(true);
        }
    }

    private void trendJMenuItemActionPerformed(ActionEvent evt) {
        if (this.trendWindow != null) {
            ATKGraphicsUtils.centerFrame((JComponent)this.getRootPane(), (Frame)this.trendWindow);
            this.trendWindow.setVisible(true);
        }
    }

    private void seqLogJMenuItemActionPerformed(ActionEvent evt) {
        if (this.jdoorwLogWindow != null) {
            ATKGraphicsUtils.centerFrame((JComponent)this.getRootPane(), (Frame)this.jdoorwLogWindow);
            this.jdoorwLogWindow.setVisible(true);
        }
    }

    private void endApplication() {
        System.exit(0);
    }

    private void startDateRefreshThread() {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    TestBenchMainWindow.this.calendar.setTimeInMillis(System.currentTimeMillis());
                    Date date = TestBenchMainWindow.this.calendar.getTime();
                    TestBenchMainWindow.this.updateDateTimeLabel(TestBenchMainWindow.this.dateFormat.format(date));
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        System.out.println(e);
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TestBenchMainWindow().setVisible(true);
            }
        });
    }
}

