/*
 * Decompiled with CFR 0.152.
 */
package comecaTestBench;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.SplashTimer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jdoorWrapViewer.JDoorWrapperProxy;

public abstract class TestBenchConstants {
    public static final SplashTimer splash = new SplashTimer(2000L, 200L);
    public static final ErrorHistory errorHistory = new ErrorHistory();
    public static final String COMECA_TB_SYNOPTIC_FILE_NAME = "comecaTB.jdw";
    public static final String COMECA_DEV = "test/ps-conv-rack/1";
    public static final String AC_DC_PS_DEV = "test/sm15k/1";
    public static final String ELOAD_DEV = "test/ea9250/1";
    public static final String COMECA_CH1_DEV = "test/ps-conv/1";
    public static final String COMECA_CH2_DEV = "test/ps-conv/2";
    public static final String COMECA_CH3_DEV = "test/ps-conv/3";
    public static final String DMM_DEV1 = "test/k2701/curr";
    public static final String DMM_DEV2 = "test/k2701/volt";
    public static final String PM_DEV = "test/lmg670/1";
    public static final String PM_CH1_DEV = "test/lmg670/ch1";
    public static final String PM_CH2_DEV = "test/lmg670/ch2";
    public static final String PM_CH3_DEV = "test/lmg670/ch3";
    public static final String PM_CH4_DEV = "test/lmg670/ch4";
    public static final String DOOR_WRAPPER = "test/doorwrap-bench/1";
    public static final String SEQUENCE_1 = "CurrentLinearity";
    public static final String SEQUENCE_2 = "VoltageLinearity";
    public static final String SEQUENCE_3 = "DcInputChange";
    public static final String APPLI_VERSION_TAG;
    private static final String TEST_BENCH_FREE_PROP = "JComecaTestBench";
    private static final String SEQ_OUTPUT_FOLDER_PROP = "SequenceOutputFolder";
    private static final String DEFAULT_SEQ_OUTPUT_FOLDER = "/home/bench/SequenceOutput";
    public static String SEQ_OUTPUT_FOLDER;
    private static final String SEQ_FILE_PREFIX_PROP = "SequenceOutputFilePrefix";
    private static final String DEFAULT_SEQ_FILE_PREFIX = "comecaTest_";
    public static String SEQ_FILE_PREFIX;
    public static JDoorWrapperProxy JDOOR_WRAPPER_PROXY;

    private static String getPropFromTangoDB(Database tangodb, String prop) {
        if (tangodb == null) {
            return null;
        }
        DbDatum dbd = null;
        try {
            dbd = tangodb.get_property(TEST_BENCH_FREE_PROP, prop);
        }
        catch (DevFailed ex) {
            // empty catch block
        }
        if (dbd == null) {
            return null;
        }
        if (dbd.is_empty()) {
            return null;
        }
        String argout = dbd.extractString();
        return argout;
    }

    static {
        JDOOR_WRAPPER_PROXY = null;
        Properties props = new Properties();
        InputStream stream = TestBenchConstants.class.getClassLoader().getResourceAsStream("jComTB.properties");
        String propValue = null;
        try {
            props.load(stream);
            propValue = props.getProperty("jcomTB.version");
            System.out.println(propValue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        APPLI_VERSION_TAG = propValue == null ? "xx" : propValue;
        Database dbConnection = null;
        try {
            dbConnection = ApiUtil.get_db_obj();
        }
        catch (DevFailed ex) {
            // empty catch block
        }
        if (dbConnection == null) {
            SEQ_OUTPUT_FOLDER = DEFAULT_SEQ_OUTPUT_FOLDER;
            SEQ_FILE_PREFIX = DEFAULT_SEQ_FILE_PREFIX;
        } else {
            String propValue2 = TestBenchConstants.getPropFromTangoDB(dbConnection, SEQ_OUTPUT_FOLDER_PROP);
            SEQ_OUTPUT_FOLDER = propValue2 == null ? DEFAULT_SEQ_OUTPUT_FOLDER : propValue2;
            propValue2 = TestBenchConstants.getPropFromTangoDB(dbConnection, SEQ_FILE_PREFIX_PROP);
            SEQ_FILE_PREFIX = propValue2 == null ? DEFAULT_SEQ_FILE_PREFIX : propValue2;
        }
        JDOOR_WRAPPER_PROXY = new JDoorWrapperProxy(DOOR_WRAPPER);
    }
}

