/*
 * Decompiled with CFR 0.152.
 */
package comecaTestBench;

import atkpanel.MainPanel;
import comecaTestBench.TestBenchConstants;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.attribute.ScalarListViewer;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.attribute.StatusViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PmChannelWindow
extends JFrame {
    private String pmChannelDevName = null;
    private Device pmChannelDevice = null;
    private AttributeList attl = new AttributeList();
    private AttributeList scalarAttl = new AttributeList();
    private IDevStateScalar stateAtt = null;
    private IStringScalar statusAtt = null;
    private MainPanel pmChannelAtkPanel = null;
    private JPanel chJPanel;
    private NumberSpectrumViewer chNsv;
    private JPanel cmdJPanel;
    private JButton expertJButton;
    private JPanel harmonicsPanel;
    private JTabbedPane jTabbedPane1;
    private ScalarListViewer scalarListViewer1;
    private StateViewer stateViewer1;
    private StatusViewer statusViewer1;
    private JPanel topJPanel;
    private JPanel vhJPanel;
    private NumberSpectrumViewer vhNsv;

    public PmChannelWindow(String devName) {
        JLDataView dv;
        JLChart chart;
        this.initComponents();
        if (devName == null) {
            JOptionPane.showMessageDialog(null, "Cannot create the panel for the PM channel device.\nThe device name is null.\n", "PmChannelWindow", 0);
            return;
        }
        this.pmChannelDevName = devName;
        try {
            this.pmChannelDevice = DeviceFactory.getInstance().getDevice(this.pmChannelDevName);
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, "Cannot connect to the PM channel device.\nFix the problem and restart the application.\n", "PmChannelWindow", 0);
            return;
        }
        JComponent jc = this.chNsv.getComponent();
        if (jc instanceof JLChart) {
            chart = (JLChart)jc;
            chart.getY1Axis().setScale(1);
            chart.getY1Axis().setGridVisible(true);
            chart.getXAxis().setName("Harmonic rank");
            dv = this.chNsv.getDataView();
            dv.setBarWidth(1);
            dv.setViewType(1);
        }
        if ((jc = this.vhNsv.getComponent()) instanceof JLChart) {
            chart = (JLChart)jc;
            chart.getY1Axis().setScale(1);
            chart.getY1Axis().setGridVisible(true);
            chart.getXAxis().setName("Harmonic rank");
            dv = this.vhNsv.getDataView();
            dv.setColor(Color.BLUE);
            dv.setBarWidth(1);
            dv.setViewType(1);
        }
        this.attl = new AttributeList();
        this.attl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.attl.addSetErrorListener((ISetErrorListener)ErrorPopup.getInstance());
        this.connectToAttributesAndCommands();
        this.scalarListViewer1.setModel(this.scalarAttl);
        this.attl.startRefresher();
        this.setPreferredSize(new Dimension(600, 450));
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.topJPanel = new JPanel();
        this.stateViewer1 = new StateViewer();
        this.statusViewer1 = new StatusViewer();
        this.cmdJPanel = new JPanel();
        this.expertJButton = new JButton();
        this.scalarListViewer1 = new ScalarListViewer();
        this.harmonicsPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.chJPanel = new JPanel();
        this.chNsv = new NumberSpectrumViewer();
        this.chNsv.setChartBackground(Color.WHITE);
        this.vhJPanel = new JPanel();
        this.vhNsv = new NumberSpectrumViewer();
        this.vhNsv.setChartBackground(Color.WHITE);
        this.setDefaultCloseOperation(0);
        this.setTitle("PM Channel Window");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PmChannelWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.topJPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.topJPanel.add((Component)this.stateViewer1, gridBagConstraints);
        this.statusViewer1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.topJPanel.add((Component)this.statusViewer1, gridBagConstraints);
        this.cmdJPanel.setLayout(new GridBagLayout());
        this.expertJButton.setText("Expert Panel ...");
        this.expertJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PmChannelWindow.this.expertJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.expertJButton, gridBagConstraints);
        this.scalarListViewer1.setPropertyButtonVisible(false);
        this.scalarListViewer1.setTheFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.scalarListViewer1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.topJPanel.add((Component)this.cmdJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.topJPanel, gridBagConstraints);
        this.harmonicsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Harmonics"));
        this.harmonicsPanel.setLayout(new GridBagLayout());
        this.chJPanel.setLayout(new GridBagLayout());
        this.chNsv.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.chJPanel.add((Component)this.chNsv, gridBagConstraints);
        this.jTabbedPane1.addTab("Current  (A)", this.chJPanel);
        this.vhJPanel.setLayout(new GridBagLayout());
        this.vhNsv.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.vhJPanel.add((Component)this.vhNsv, gridBagConstraints);
        this.jTabbedPane1.addTab("Voltage  (V)", this.vhJPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.harmonicsPanel.add((Component)this.jTabbedPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.harmonicsPanel, gridBagConstraints);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.attl.stopRefresher();
        this.stateViewer1.clearModel();
        this.statusViewer1.clearModel();
        this.attl.clear();
        this.scalarAttl.clear();
        this.closePmChannelAtkPanel();
        this.dispose();
    }

    private void expertJButtonActionPerformed(ActionEvent evt) {
        if (this.pmChannelDevice == null || this.pmChannelDevName == null) {
            return;
        }
        if (this.pmChannelAtkPanel == null) {
            this.launchPmChannelAtkPanel();
            return;
        }
        if (this.pmChannelAtkPanel == null) {
            return;
        }
        this.pmChannelAtkPanel.setVisible(true);
        this.pmChannelAtkPanel.toFront();
    }

    private void launchPmChannelAtkPanel() {
        this.pmChannelAtkPanel = new MainPanel(this.pmChannelDevName);
        if (this.pmChannelAtkPanel == null) {
            return;
        }
        this.pmChannelAtkPanel.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                PmChannelWindow.this.pmChannelAtkPanelExited();
            }
        });
        this.pmChannelAtkPanel.setExpertView(true);
        ATKGraphicsUtils.centerFrame((JComponent)this.expertJButton, (Frame)this.pmChannelAtkPanel);
        this.pmChannelAtkPanel.toFront();
    }

    private void pmChannelAtkPanelExited() {
        this.pmChannelAtkPanel = null;
    }

    private void closePmChannelAtkPanel() {
        if (this.pmChannelAtkPanel == null) {
            return;
        }
        this.pmChannelAtkPanel.dispatchEvent((AWTEvent)new WindowEvent((Window)this.pmChannelAtkPanel, 201));
        this.pmChannelAtkPanel = null;
    }

    private void connectToAttributesAndCommands() {
        String msgatt = "Cannot connect to the attribute : ";
        String msgcmd = "Cannot connect to the command : ";
        String msg = null;
        try {
            String entityname = this.pmChannelDevName + "/State";
            msg = msgatt + entityname;
            IEntity oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IDevStateScalar) {
                this.stateAtt = (IDevStateScalar)oneEntity;
                this.stateViewer1.setModel(this.stateAtt);
            }
            entityname = this.pmChannelDevName + "/Status";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IStringScalar) {
                this.statusAtt = (IStringScalar)oneEntity;
                this.statusViewer1.setModel(this.statusAtt);
            }
            entityname = this.pmChannelDevName + "/HarmonicPointNumber";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof INumberScalar) {
                this.scalarAttl.add(oneEntity);
            }
            entityname = this.pmChannelDevName + "/CurrentHarmonics";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof INumberSpectrum) {
                this.chNsv.setModel((INumberSpectrum)oneEntity);
            }
            entityname = this.pmChannelDevName + "/VoltageHarmonics";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof INumberSpectrum) {
                this.vhNsv.setModel((INumberSpectrum)oneEntity);
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + this.pmChannelDevName + " is responding?\n", "PmChannelWindow : Attribute connection", 0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PmChannelWindow("test/lmg670/ch4").setVisible(true);
            }
        });
    }
}

