/*
 * Decompiled with CFR 0.152.
 */
package comecaTestBench;

import atkpanel.MainPanel;
import comecaTestBench.TestBenchConstants;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanSpectrumEvent;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.IBooleanSpectrumListener;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.attribute.ScalarListViewer;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.attribute.StatusViewer;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class KeithleyWindow
extends JFrame
implements IBooleanSpectrumListener {
    private String keithleyDevName = null;
    private Device keithleyDevice = null;
    private AttributeList attl = new AttributeList();
    private AttributeList scalarAttl = new AttributeList();
    private final CommandList cmdl = new CommandList();
    private IDevStateScalar stateAtt = null;
    private IStringScalar statusAtt = null;
    private IBooleanSpectrum channelsAtt = null;
    private ICommand takeMeasureCmd = null;
    private ICommand resetCmd = null;
    private String[] channelBooleanLabels = null;
    private HashMap<String, JCheckBox> cbMap = new HashMap();
    private MainPanel keithleyAtkPanel = null;
    private boolean do_refresh = false;
    private JPanel channelSelectionJPanel;
    private JPanel channelsJPanel;
    private JPanel cmdJPanel;
    private JButton expertJButton;
    private JPanel jPanel1;
    private VoidVoidCommandViewer measureVVcmdv;
    private VoidVoidCommandViewer resetVVcmdv;
    private ScalarListViewer scalarListViewer1;
    private StateViewer stateViewer1;
    private StatusViewer statusViewer1;

    public KeithleyWindow(String devName) {
        this.initComponents();
        if (devName == null) {
            JOptionPane.showMessageDialog(null, "Cannot create the panel for the Keithley device.\nThe device name is null.\n", "KeithleyWindow", 0);
            return;
        }
        this.keithleyDevName = devName;
        try {
            this.keithleyDevice = DeviceFactory.getInstance().getDevice(this.keithleyDevName);
            this.keithleyDevice.setDevTimeout(12000);
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, "Cannot connect to the Keithley device.\nFix the problem and restart the application.\n", "KeithleyWindow", 0);
            return;
        }
        this.attl = new AttributeList();
        this.attl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.attl.addSetErrorListener((ISetErrorListener)ErrorPopup.getInstance());
        this.cmdl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
        this.connectToAttributesAndCommands();
        this.scalarListViewer1.setModel(this.scalarAttl);
        this.addChannelsCheckBoxes();
        this.do_refresh = true;
        this.attl.startRefresher();
        this.setPreferredSize(new Dimension(600, 320));
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.stateViewer1 = new StateViewer();
        this.statusViewer1 = new StatusViewer();
        this.cmdJPanel = new JPanel();
        this.measureVVcmdv = new VoidVoidCommandViewer();
        this.resetVVcmdv = new VoidVoidCommandViewer();
        this.expertJButton = new JButton();
        this.scalarListViewer1 = new ScalarListViewer();
        this.channelSelectionJPanel = new JPanel();
        this.channelsJPanel = new JPanel();
        this.setDefaultCloseOperation(0);
        this.setTitle("DMM Window");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                KeithleyWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.stateViewer1, gridBagConstraints);
        this.statusViewer1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.statusViewer1, gridBagConstraints);
        this.cmdJPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.measureVVcmdv, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.resetVVcmdv, gridBagConstraints);
        this.expertJButton.setText("Expert Panel ...");
        this.expertJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeithleyWindow.this.expertJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.expertJButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.cmdJPanel, gridBagConstraints);
        this.scalarListViewer1.setPropertyButtonVisible(false);
        this.scalarListViewer1.setTheFont(new Font("Dialog", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.scalarListViewer1, gridBagConstraints);
        this.channelSelectionJPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Measurement Channels"));
        this.channelSelectionJPanel.setLayout(new GridBagLayout());
        this.channelsJPanel.setLayout(new GridLayout(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.channelSelectionJPanel.add((Component)this.channelsJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.channelSelectionJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.attl.stopRefresher();
        this.stateViewer1.clearModel();
        this.statusViewer1.clearModel();
        this.attl.clear();
        this.scalarAttl.clear();
        this.cmdl.clear();
        this.cbMap.clear();
        this.closeKeithleyAtkPanel();
        this.dispose();
    }

    private void expertJButtonActionPerformed(ActionEvent evt) {
        if (this.keithleyDevice == null || this.keithleyDevName == null) {
            return;
        }
        if (this.keithleyAtkPanel == null) {
            this.launchKeithleyAtkPanel();
            return;
        }
        if (this.keithleyAtkPanel == null) {
            return;
        }
        this.keithleyAtkPanel.setVisible(true);
        this.keithleyAtkPanel.toFront();
    }

    private void launchKeithleyAtkPanel() {
        this.keithleyAtkPanel = new MainPanel(this.keithleyDevName);
        if (this.keithleyAtkPanel == null) {
            return;
        }
        this.keithleyAtkPanel.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                KeithleyWindow.this.keithleyAtkPanelExited();
            }
        });
        this.keithleyAtkPanel.setExpertView(true);
        ATKGraphicsUtils.centerFrame((JComponent)this.expertJButton, (Frame)this.keithleyAtkPanel);
        this.keithleyAtkPanel.toFront();
    }

    private void keithleyAtkPanelExited() {
        this.keithleyAtkPanel = null;
    }

    private void closeKeithleyAtkPanel() {
        if (this.keithleyAtkPanel == null) {
            return;
        }
        this.keithleyAtkPanel.dispatchEvent((AWTEvent)new WindowEvent((Window)this.keithleyAtkPanel, 201));
        this.keithleyAtkPanel = null;
    }

    private void connectToAttributesAndCommands() {
        IEntity oneEntity;
        String entityname;
        String msgatt = "Cannot connect to the attribute : ";
        String msgcmd = "Cannot connect to the command : ";
        String msg = null;
        try {
            entityname = this.keithleyDevName + "/State";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IDevStateScalar) {
                this.stateAtt = (IDevStateScalar)oneEntity;
                this.stateViewer1.setModel(this.stateAtt);
            }
            entityname = this.keithleyDevName + "/Status";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IStringScalar) {
                this.statusAtt = (IStringScalar)oneEntity;
                this.statusViewer1.setModel(this.statusAtt);
            }
            entityname = this.keithleyDevName + "/Trigger";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IEnumScalar) {
                this.scalarAttl.add(oneEntity);
            }
            entityname = this.keithleyDevName + "/MeasurementChannel";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IBooleanSpectrum) {
                this.channelsAtt = (IBooleanSpectrum)oneEntity;
                this.channelsAtt.addBooleanSpectrumListener((IBooleanSpectrumListener)this);
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + this.keithleyDevName + " is responding?\n", "KeithleyWindow : Attribute connection", 0);
        }
        try {
            entityname = this.keithleyDevName + "/TakeMeasurement";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof VoidVoidCommand) {
                this.takeMeasureCmd = (ICommand)oneEntity;
                this.measureVVcmdv.setModel(this.takeMeasureCmd);
            }
            entityname = this.keithleyDevName + "/Reset";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof VoidVoidCommand) {
                this.resetCmd = (ICommand)oneEntity;
                this.resetVVcmdv.setModel(this.resetCmd);
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + this.keithleyDevName + " is responding?\n", "ComecaChannelPanel : Command connection", 0);
        }
    }

    private String getKeyFromIndex(int i) {
        String key = "Channel " + (i + 1);
        return key;
    }

    private void channelCheckBoxActionPerformed() {
        this.do_refresh = false;
        boolean[] selChannels = this.getSelectedChannels();
        if (selChannels == null) {
            return;
        }
        try {
            this.channelsAtt.setValue(selChannels);
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
        this.do_refresh = true;
    }

    private void addChannelsCheckBoxes() {
        if (this.channelsAtt == null) {
            return;
        }
        if (!this.channelsAtt.areAttPropertiesLoaded()) {
            this.channelsAtt.loadAttProperties();
        }
        this.channelBooleanLabels = this.channelsAtt.getBooleanLabels();
        this.channelsAtt.refresh();
        boolean[] channels = null;
        channels = this.channelsAtt.getValue();
        if (channels == null) {
            return;
        }
        if (channels.length < 1) {
            return;
        }
        JCheckBox jcb = null;
        for (int i = 0; i < channels.length; ++i) {
            String jcbText = this.getKeyFromIndex(i);
            if (this.channelBooleanLabels != null && i < this.channelBooleanLabels.length) {
                jcbText = this.channelBooleanLabels[i];
            }
            jcb = new JCheckBox(jcbText);
            jcb.setSelected(channels[i]);
            jcb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KeithleyWindow.this.channelCheckBoxActionPerformed();
                }
            });
            this.channelsJPanel.add(jcb);
            this.cbMap.put(this.getKeyFromIndex(i), jcb);
        }
    }

    private void updateChannelCheckBoxes(boolean[] chValues) {
        if (chValues == null) {
            return;
        }
        if (chValues.length < 1) {
            return;
        }
        for (int i = 0; i < chValues.length; ++i) {
            String key = this.getKeyFromIndex(i);
            JCheckBox jcb = this.cbMap.get(key);
            if (jcb == null) continue;
            jcb.setSelected(chValues[i]);
        }
    }

    private boolean[] getSelectedChannels() {
        int nbCheckBoxes = this.cbMap.size();
        if (nbCheckBoxes < 1) {
            return null;
        }
        boolean[] selectedChannels = new boolean[nbCheckBoxes];
        for (int i = 0; i < nbCheckBoxes; ++i) {
            selectedChannels[i] = false;
            String key = this.getKeyFromIndex(i);
            JCheckBox jcb = this.cbMap.get(key);
            if (jcb == null) continue;
            selectedChannels[i] = jcb.isSelected();
        }
        return selectedChannels;
    }

    public void booleanSpectrumChange(BooleanSpectrumEvent bse) {
        if (!this.do_refresh) {
            return;
        }
        boolean[] channels = bse.getValue();
        this.updateChannelCheckBoxes(channels);
    }

    public void stateChange(AttributeStateEvent ase) {
    }

    public void errorChange(ErrorEvent ee) {
        int nbCheckBoxes = this.cbMap.size();
        if (nbCheckBoxes < 1) {
            return;
        }
        boolean[] selectedChannels = new boolean[nbCheckBoxes];
        for (int i = 0; i < nbCheckBoxes; ++i) {
            selectedChannels[i] = false;
        }
        this.updateChannelCheckBoxes(selectedChannels);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new KeithleyWindow("test/k2701/curr").setVisible(true);
            }
        });
    }
}

