/*
 * Decompiled with CFR 0.152.
 */
package comecaTestBench;

import atkpanel.MainPanel;
import comecaTestBench.ComecaEventsWindow;
import comecaTestBench.TestBenchConstants;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.core.command.ScalarArrayCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.attribute.StatusViewer;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ComecaWindow
extends JFrame
implements IResultListener {
    private static final int EVENT_NUMBER = 5;
    private int default_dev_timeout = 3000;
    private int long_dev_timeout = 15000;
    private String comecaDevName = null;
    private Device comecaDevice = null;
    private AttributeList attl = new AttributeList();
    private final CommandList cmdl = new CommandList();
    private IDevStateScalar stateAtt = null;
    private IStringScalar statusAtt = null;
    private ICommand resetCmd = null;
    private ICommand clearEventsCmd = null;
    private ICommand readEventsCmd = null;
    private ComecaEventsWindow comEvents = null;
    private MainPanel comecaAtkPanel = null;
    private VoidVoidCommandViewer clearEventsVVcmdv;
    private JPanel cmdJPanel;
    private JButton expertJButton;
    private JPanel jPanel1;
    private JButton readEventsJButton;
    private VoidVoidCommandViewer resetVVcmdv;
    private StateViewer stateViewer1;
    private StatusViewer statusViewer1;

    public ComecaWindow(String devName) {
        this.initComponents();
        if (devName == null) {
            JOptionPane.showMessageDialog(null, "Cannot create the panel for the Comeca device.\nThe device name is null.\n", "ComecaWindow", 0);
            return;
        }
        this.comecaDevName = devName;
        try {
            this.comecaDevice = DeviceFactory.getInstance().getDevice(this.comecaDevName);
            this.default_dev_timeout = this.comecaDevice.getDevTimeout();
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, "Cannot connect to the Comeca device.\nFix the problem and restart the application.\n", "ComecaWindow", 0);
            return;
        }
        this.attl = new AttributeList();
        this.attl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.attl.addSetErrorListener((ISetErrorListener)ErrorPopup.getInstance());
        this.cmdl.addErrorListener((IErrorListener)TestBenchConstants.errorHistory);
        this.cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
        this.connectToAttributesAndCommands();
        this.createComecaSubWindows();
        this.setPreferredSize(new Dimension(650, 300));
        this.pack();
        this.setVisible(true);
    }

    private void createComecaSubWindows() {
        this.comEvents = new ComecaEventsWindow();
        this.comEvents.setTitle("Comeca Events");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.stateViewer1 = new StateViewer();
        this.statusViewer1 = new StatusViewer();
        this.cmdJPanel = new JPanel();
        this.resetVVcmdv = new VoidVoidCommandViewer();
        this.clearEventsVVcmdv = new VoidVoidCommandViewer();
        this.readEventsJButton = new JButton();
        this.expertJButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Comeca Window");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ComecaWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.stateViewer1, gridBagConstraints);
        this.statusViewer1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.statusViewer1, gridBagConstraints);
        this.cmdJPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.resetVVcmdv, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.clearEventsVVcmdv, gridBagConstraints);
        this.readEventsJButton.setText("jButton1");
        this.readEventsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComecaWindow.this.readEventsJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.readEventsJButton, gridBagConstraints);
        this.expertJButton.setText("Expert Panel ...");
        this.expertJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComecaWindow.this.expertJButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.cmdJPanel.add((Component)this.expertJButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.cmdJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void readEventsJButtonActionPerformed(ActionEvent evt) {
        int nbEvent = 5;
        String nbEventStr = JOptionPane.showInputDialog(this, "Event Number ", new Integer(5));
        if (nbEventStr == null) {
            return;
        }
        try {
            int nb;
            nbEvent = nb = Integer.parseInt(nbEventStr);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
            return;
        }
        try {
            this.comecaDevice.setDevTimeout(this.long_dev_timeout);
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(this, "Failed to change the device timeout to " + this.long_dev_timeout + ".\n\n" + ex.getMessage(), "Device Timeout Change", 0);
        }
        ArrayList<String> listArg = new ArrayList<String>();
        String str = Integer.toString(nbEvent);
        listArg.add(str);
        this.readEventsCmd.execute(listArg);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.attl.stopRefresher();
        if (this.readEventsCmd != null) {
            this.readEventsCmd.removeResultListener((IResultListener)this);
        }
        this.stateViewer1.clearModel();
        this.statusViewer1.clearModel();
        this.resetVVcmdv.setModel((ICommand)null);
        this.clearEventsVVcmdv.setModel((ICommand)null);
        this.attl.clear();
        this.cmdl.clear();
        if (this.comEvents != null) {
            this.comEvents = null;
        }
        this.dispose();
    }

    private void expertJButtonActionPerformed(ActionEvent evt) {
        if (this.comecaDevice == null || this.comecaDevName == null) {
            return;
        }
        if (this.comecaAtkPanel == null) {
            this.launchComecaAtkPanel();
            return;
        }
        if (this.comecaAtkPanel == null) {
            return;
        }
        this.comecaAtkPanel.setVisible(true);
        this.comecaAtkPanel.toFront();
    }

    private void launchComecaAtkPanel() {
        this.comecaAtkPanel = new MainPanel(this.comecaDevName);
        if (this.comecaAtkPanel == null) {
            return;
        }
        this.comecaAtkPanel.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                ComecaWindow.this.comecaAtkPanelExited();
            }
        });
        this.comecaAtkPanel.setExpertView(true);
        ATKGraphicsUtils.centerFrame((JComponent)this.expertJButton, (Frame)this.comecaAtkPanel);
        this.comecaAtkPanel.toFront();
    }

    private void comecaAtkPanelExited() {
        this.comecaAtkPanel = null;
    }

    private void closeComecaAtkPanel() {
        if (this.comecaAtkPanel == null) {
            return;
        }
        this.comecaAtkPanel.dispatchEvent((AWTEvent)new WindowEvent((Window)this.comecaAtkPanel, 201));
        this.comecaAtkPanel = null;
    }

    private void connectToAttributesAndCommands() {
        IEntity oneEntity;
        String entityname;
        String msgatt = "Cannot connect to the attribute : ";
        String msgcmd = "Cannot connect to the command : ";
        String msg = null;
        try {
            entityname = this.comecaDevName + "/State";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IDevStateScalar) {
                this.stateAtt = (IDevStateScalar)oneEntity;
                this.stateViewer1.setModel(this.stateAtt);
            }
            entityname = this.comecaDevName + "/Status";
            msg = msgatt + entityname;
            oneEntity = this.attl.add(entityname);
            if (oneEntity instanceof IStringScalar) {
                this.statusAtt = (IStringScalar)oneEntity;
                this.statusViewer1.setModel(this.statusAtt);
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + this.comecaDevName + " is responding?\n", "ComecaWindow : Attribute connection", 0);
        }
        try {
            entityname = this.comecaDevName + "/Reset";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof VoidVoidCommand) {
                this.resetCmd = (ICommand)oneEntity;
                this.resetVVcmdv.setModel(this.resetCmd);
            }
            entityname = this.comecaDevName + "/ClearEvents";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof VoidVoidCommand) {
                this.clearEventsCmd = (ICommand)oneEntity;
                this.clearEventsVVcmdv.setModel(this.clearEventsCmd);
            }
            entityname = this.comecaDevName + "/ReadEvents";
            msg = msgcmd + entityname;
            oneEntity = this.cmdl.add(entityname);
            if (oneEntity instanceof ScalarArrayCommand) {
                this.readEventsCmd = (ICommand)oneEntity;
                this.readEventsCmd.addResultListener((IResultListener)this);
                this.readEventsJButton.setText("ReadEvents");
            }
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(null, msg + " .\n" + "Check if the device " + this.comecaDevName + " is responding?\n", "ComecaWindow : Command connection", 0);
        }
    }

    private void displayEvents(String events) {
        if (this.comEvents == null) {
            return;
        }
        this.comEvents.setText(events);
        ATKGraphicsUtils.centerFrame((JComponent)this.getRootPane(), (Frame)this.comEvents);
        this.comEvents.setVisible(true);
    }

    public void resultChange(ResultEvent re) {
        if (re.getSource() != this.readEventsCmd) {
            return;
        }
        try {
            this.comecaDevice.setDevTimeout(this.default_dev_timeout);
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(this, "Failed to change the device timeout back to " + this.default_dev_timeout + ".\n\n" + ex.getMessage(), "Device Timeout Change", 0);
        }
        List res = re.getResult();
        String allEvents = null;
        for (int i = 0; i < res.size(); ++i) {
            Object obj = res.get(i);
            if (!(obj instanceof String)) continue;
            String str = (String)obj;
            allEvents = allEvents + str + "\n";
        }
        this.displayEvents(allEvents);
    }

    public void errorChange(ErrorEvent ee) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ComecaWindow("test/ps-conv-rack/1").setVisible(true);
            }
        });
    }
}

