/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.TuningCmdList;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.util.Splash;

public class TuningConfig {
    private AttributeList attList;
    private TuningCmdList[] cmdList;
    private String title;
    private int startIndex;
    private int nbItem = 0;

    public TuningConfig(String[] list, boolean runFromShell, Splash splashScreen, AttributeList globalList, Object serr) {
        this.attList = globalList;
        this.startIndex = this.attList.size();
        String splashMsg = splashScreen.getMessage();
        this.title = list[0];
        int i = 1;
        while (i < list.length) {
            splashScreen.setMessage(splashMsg + "Init " + list[i]);
            try {
                this.attList.add(list[i]);
            }
            catch (ConnectionException e) {
                System.out.println(e.getDescription());
            }
            splashScreen.progress((int)((double)i / (double)list.length * 50.0));
            ++i;
        }
        this.nbItem = this.attList.size() - this.startIndex;
        this.cmdList = new TuningCmdList[this.nbItem];
        i = 0;
        while (i < this.nbItem) {
            String devName = this.extractDeviceName(this.getAtt(i).getName());
            splashScreen.setMessage(splashMsg + "Init " + devName);
            TuningCmdList newList = TuningCmdList.findList(this.cmdList, i, devName);
            if (newList == null) {
                this.cmdList[i] = new TuningCmdList();
                this.cmdList[i].addErrorListener((IErrorListener)serr);
                this.cmdList[i].setModel(devName);
            } else {
                this.cmdList[i] = newList;
            }
            splashScreen.progress((int)((double)i / (double)list.length * 50.0) + 50);
            ++i;
        }
    }

    public int getNbItem() {
        return this.nbItem;
    }

    public String getTitle() {
        return this.title;
    }

    public INumberScalar getAtt(int index) {
        return (INumberScalar)this.attList.get(this.startIndex + index);
    }

    public CommandList getCmds(int index) {
        return this.cmdList[index];
    }

    public String extractDeviceName(String s) {
        int i = s.lastIndexOf(47);
        if (i > 0) {
            return s.substring(0, i);
        }
        return "";
    }
}

