/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.TuningConfig;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.command.CommandMenuViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class TuningPanel
extends JPanel {
    private JSmoothLabel title;
    private JSmoothLabel[] labels;
    private SimpleScalarViewer[] values;
    private NumberScalarWheelEditor[] setters;
    private CommandMenuViewer[] commands;
    private int maxLabWidth = 0;
    private int height = 0;
    private TuningConfig theCfg;
    private Font theFont;

    public TuningPanel(TuningConfig cfg, Font f, Font tf, int maxH) {
        INumberScalar m;
        int nb = cfg.getNbItem();
        this.theCfg = cfg;
        this.theFont = f;
        this.height = maxH;
        this.computeMaxLabelWidth();
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.title = new JSmoothLabel();
        this.title.setFont(tf);
        this.title.setBackground(this.getBackground());
        this.title.setHorizontalAlignment(JSmoothLabel.CENTER_ALIGNMENT);
        this.title.setBounds(2, 2, 266 + this.maxLabWidth, 28);
        this.title.setText(this.getConfig().getTitle());
        this.title.setValueOffsets(0, -5);
        this.add((Component)this.title);
        this.labels = new JSmoothLabel[nb];
        int i = 0;
        while (i < nb) {
            this.labels[i] = new JSmoothLabel();
            this.labels[i].setFont(f);
            m = cfg.getAtt(i);
            this.labels[i].setText(m.getLabel());
            this.labels[i].setToolTipText(m.getName());
            this.labels[i].setBackground(this.getBackground());
            this.add((Component)this.labels[i]);
            this.labels[i].setBounds(2, (i + 1) * 30, this.maxLabWidth, 28);
            this.labels[i].setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            ++i;
        }
        this.values = new SimpleScalarViewer[nb];
        i = 0;
        while (i < nb) {
            this.values[i] = new SimpleScalarViewer();
            this.values[i].setFont(f);
            this.values[i].setBorder(BorderFactory.createLoweredBevelBorder());
            this.add((Component)this.values[i]);
            this.values[i].setBounds(this.maxLabWidth + 4, (i + 1) * 30, 150, 28);
            this.values[i].setHorizontalAlignment(JAutoScrolledText.CENTER_ALIGNMENT);
            this.values[i].setModel(cfg.getAtt(i));
            ++i;
        }
        this.setters = new NumberScalarWheelEditor[nb];
        i = 0;
        while (i < nb) {
            m = cfg.getAtt(i);
            if (m.isWriteable()) {
                this.setters[i] = new NumberScalarWheelEditor();
                this.setters[i].setFont(f);
                this.setters[i].setBackground(this.getBackground());
                this.add((Component)this.setters[i]);
                this.setters[i].setBounds(this.maxLabWidth + 156, (i + 1) * 30, 80, 30);
                this.setters[i].setModel(m);
            }
            ++i;
        }
        this.commands = new CommandMenuViewer[nb];
        i = 0;
        while (i < nb) {
            this.commands[i] = new CommandMenuViewer();
            this.commands[i].setBackground(this.getBackground());
            this.add((Component)this.commands[i]);
            this.commands[i].setBounds(this.maxLabWidth + 237, (i + 1) * 30, 30, 28);
            this.commands[i].setModel(cfg.getCmds(i));
            ++i;
        }
    }

    private void computeMaxLabelWidth() {
        BufferedImage img = new BufferedImage(10, 10, 1);
        Graphics g = img.getGraphics();
        g.setFont(this.theFont);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        this.maxLabWidth = 0;
        int i = 0;
        while (i < this.theCfg.getNbItem()) {
            String text = this.theCfg.getAtt(i).getLabel();
            Rectangle2D bounds = g.getFont().getStringBounds(text, frc);
            int w = (int)bounds.getWidth();
            if (w > this.maxLabWidth) {
                this.maxLabWidth = w;
            }
            ++i;
        }
        this.maxLabWidth += 5;
        g.dispose();
    }

    public Dimension getPreferredSize() {
        return new Dimension(270 + this.maxLabWidth, this.height + 2);
    }

    public Dimension getMinimunSize() {
        return this.getPreferredSize();
    }

    public TuningConfig getConfig() {
        return this.theCfg;
    }
}

