/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.util.Splash;

public class TuningConfig {
    private AttributeList attList = new AttributeList();
    private CommandList[] cmdList;
    private String title;

    public TuningConfig(String[] list, boolean runFromShell, Splash splashScreen, Object err, Object serr) {
        this.attList.addErrorListener((IErrorListener)err);
        this.attList.addSetErrorListener((ISetErrorListener)serr);
        IEntityFilter attfilter = new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberScalar) {
                    return true;
                }
                System.out.println(entity.getName() + " not supported.");
                return false;
            }
        };
        this.attList.setFilter(attfilter);
        this.title = list[0];
        int i = 1;
        while (i < list.length) {
            try {
                this.attList.add(list[i]);
                if (runFromShell) {
                    splashScreen.progress((int)((double)i / (double)list.length * 50.0));
                }
            }
            catch (Exception e) {
                System.out.println(list[i] + " failed :" + e.getMessage());
            }
            ++i;
        }
        this.cmdList = new CommandList[list.length];
        IEntityFilter cmdfilter = new IEntityFilter(){

            public boolean keep(IEntity entity) {
                return entity instanceof VoidVoidCommand;
            }
        };
        i = 0;
        while (i < this.attList.size()) {
            this.cmdList[i] = new CommandList();
            this.cmdList[i].addErrorListener((IErrorListener)serr);
            this.cmdList[i].setFilter(cmdfilter);
            try {
                this.cmdList[i].add(this.extractField(this.getAtt(i).getName()));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            if (runFromShell) {
                splashScreen.progress((int)((double)i / (double)list.length * 50.0) + 50);
            }
            ++i;
        }
    }

    public void start() {
        this.attList.startRefresher();
    }

    public int getNbItem() {
        return this.attList.size();
    }

    public String getTitle() {
        return this.title;
    }

    public INumberScalar getAtt(int index) {
        return (INumberScalar)this.attList.get(index);
    }

    public CommandList getCmds(int index) {
        return this.cmdList[index];
    }

    public String extractField(String s) {
        int i = s.lastIndexOf(47);
        if (i > 0) {
            return s.substring(0, i + 1) + "*";
        }
        return "";
    }

    public void setRefreshInterval(int ms) {
        this.attList.setRefreshInterval(ms);
    }

    public int getRefreshInterval() {
        return this.attList.getRefreshInterval();
    }

    public AttributeList getAttList() {
        return this.attList;
    }
}

