/*
 * Decompiled with CFR 0.152.
 */
package atktuning;

import atktuning.TuningConfig;
import atktuning.TuningPanel;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MainPanel
extends JFrame
implements IErrorListener,
ISetErrorListener {
    private JPanel thePanel;
    private JScrollPane theView;
    private JMenuBar mainMenu;
    private Font theFont;
    private Font titleFont;
    private int nbPanel = 0;
    private TuningPanel[] panels;
    private JMenuItem[] jTrendMenuItem = null;
    private boolean runFromShell;
    ErrorHistory errorHistory;
    private String appVersion = "AtkTuning 2.0";

    public MainPanel(String filename) {
        this.runFromShell = false;
        this.initComponents(filename);
    }

    public MainPanel(String filename, boolean b) {
        this.runFromShell = b;
        this.initComponents(filename);
    }

    private void initComponents(String filename) {
        int w;
        Splash splashScreen = null;
        this.errorHistory = new ErrorHistory();
        if (this.runFromShell) {
            splashScreen = new Splash();
            splashScreen.setTitle(this.appVersion);
            splashScreen.setMessage("Reading " + filename + "...");
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.getContentPane().setLayout(null);
        this.setTitle(this.appVersion + "[" + filename + "]");
        String[][] list = this.readConfigFile(filename);
        this.nbPanel = list.length;
        this.theFont = new Font("Dialog", 0, 14);
        this.titleFont = new Font("Dialog", 1, 16);
        this.thePanel = new JPanel();
        this.thePanel.setBackground(this.getBackground());
        this.thePanel.setLayout(new FlowLayout());
        this.thePanel.setBorder(null);
        int max = 0;
        int i = 0;
        while (i < this.nbPanel) {
            if (list[i].length > max) {
                max = list[i].length;
            }
            ++i;
        }
        this.panels = new TuningPanel[this.nbPanel];
        i = 0;
        while (i < this.nbPanel) {
            if (this.runFromShell) {
                splashScreen.setMessage("Creating Panel " + (i + 1) + "...");
            }
            TuningConfig cfg = new TuningConfig(list[i], this.runFromShell, splashScreen, this.errorHistory, this);
            this.panels[i] = new TuningPanel(cfg, this.theFont, this.titleFont, max * 30);
            this.thePanel.add(this.panels[i]);
            ++i;
        }
        i = 0;
        while (i < this.nbPanel) {
            this.panels[i].getConfig().start();
            ++i;
        }
        if (this.runFromShell) {
            splashScreen.progress(100);
        }
        this.mainMenu = new JMenuBar();
        JMenu jMenu1 = new JMenu();
        JMenu jMenu2 = new JMenu();
        JMenu jMenu3 = new JMenu();
        JMenuItem jMenuItem1 = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenu1.setText("File");
        jMenu2.setText("Options");
        jMenu3.setText("Trends");
        jMenuItem1.setText("Exit");
        jMenuItem2.setText("Set refresh interval");
        jMenuItem3.setText("View errors");
        this.jTrendMenuItem = new JMenuItem[this.nbPanel];
        i = 0;
        while (i < this.nbPanel) {
            this.jTrendMenuItem[i] = new JMenuItem();
            this.jTrendMenuItem[i].setText("Trend " + this.panels[i].getConfig().getTitle());
            this.jTrendMenuItem[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MainPanel.this.showTrend(evt);
                }
            });
            jMenu3.add(this.jTrendMenuItem[i]);
            ++i;
        }
        jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.exitForm();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.setRefreshInterval();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.errorHistory.setVisible(true);
            }
        });
        jMenu1.add(jMenuItem1);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem3);
        this.mainMenu.add(jMenu1);
        this.mainMenu.add(jMenu2);
        this.mainMenu.add(jMenu3);
        this.setJMenuBar(this.mainMenu);
        this.theView = new JScrollPane(this.thePanel);
        this.theView.setHorizontalScrollBarPolicy(32);
        this.theView.setVerticalScrollBarPolicy(20);
        this.getContentPane().add(this.theView);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                MainPanel.this.placeComponents();
            }

            public void componentShown(ComponentEvent e) {
                MainPanel.this.placeComponents();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainPanel.this.exitForm();
            }
        });
        this.pack();
        Dimension d = this.thePanel.getPreferredSize();
        int h = d.height + 85;
        if (h > 768) {
            h = 768;
        }
        if ((w = d.width + 30) > 1024) {
            w = 1024;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = new Dimension(w, h);
        int x = (scrsize.width - appsize.width) / 2;
        int y = (scrsize.height - appsize.height) / 2;
        this.setBounds(x, y, appsize.width, appsize.height);
        Image image = toolkit.getImage(this.getClass().getResource("/atktuning/icon.gif"));
        if (image != null) {
            this.setIconImage(image);
        }
        if (this.runFromShell) {
            splashScreen.hide();
        }
        this.setVisible(true);
    }

    private void showTrend(ActionEvent evt) {
        JMenuItem sel = (JMenuItem)evt.getSource();
        int i = 0;
        boolean found = false;
        while (i < this.nbPanel && !found) {
            boolean bl = found = sel == this.jTrendMenuItem[i];
            if (found) continue;
            ++i;
        }
        if (!found) {
            return;
        }
        JFrame f = new JFrame();
        Trend graph = new Trend(f);
        f.setTitle("Trend [" + this.panels[i].getConfig().getTitle() + "]");
        graph.setModel(this.panels[i].getConfig().getAttList());
        f.setContentPane((Container)graph);
        f.pack();
        f.setSize(640, 480);
        f.setVisible(true);
    }

    private void placeComponents() {
        Dimension d = this.getContentPane().getSize();
        this.theView.setBounds(5, 5, d.width - 10, d.height - 10);
        this.theView.revalidate();
    }

    private void setRefreshInterval() {
        if (this.nbPanel <= 0) {
            return;
        }
        int old_it = this.panels[0].getConfig().getRefreshInterval();
        String i = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(old_it));
        if (i != null) {
            try {
                int it = Integer.parseInt(i);
                int j = 0;
                while (j < this.nbPanel) {
                    this.panels[j].getConfig().setRefreshInterval(it);
                    ++j;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, i + " invalid nunber.", "Error", 0);
            }
        }
    }

    private String[][] readConfigFile(String filename) {
        FileReader f = null;
        Vector items = new Vector();
        try {
            f = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            this.fatalError(filename + " not found.");
        }
        String s = this.readLine(f);
        if (s != null) {
            Vector<String> attlist;
            if (s.startsWith("#")) {
                boolean eof = false;
                while (!eof) {
                    attlist = new Vector();
                    String title = s.substring(1);
                    attlist.add(title);
                    boolean eop = false;
                    while (!eop) {
                        s = this.readLine(f);
                        if (s != null) {
                            eop = s.startsWith("#");
                            if (eop) continue;
                            attlist.add(s);
                            continue;
                        }
                        eof = true;
                        eop = true;
                    }
                    items.add(attlist);
                }
            } else {
                attlist = new Vector<String>();
                attlist.add(s);
                while ((s = this.readLine(f)) != null) {
                    attlist.add(s);
                }
                items.add(attlist);
            }
        }
        try {
            f.close();
        }
        catch (IOException e) {
            System.out.println("Warning " + e.getMessage());
        }
        String[][] ret = new String[items.size()][];
        int i = 0;
        while (i < items.size()) {
            Vector lst = (Vector)items.get(i);
            ret[i] = new String[lst.size()];
            int j = 0;
            while (j < lst.size()) {
                ret[i][j] = (String)lst.get(j);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private String readLine(FileReader f) {
        int c = 0;
        String result = "";
        boolean eor = false;
        while (!eor) {
            boolean ok;
            try {
                c = f.read();
            }
            catch (IOException e) {
                this.fatalError(f.toString() + " " + e.getMessage());
            }
            boolean bl = ok = c >= 32;
            if (ok) {
                result = result + (char)c;
            }
            boolean bl2 = eor = c == -1 || !ok && result.length() > 0;
        }
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    public String getErrorSource(ErrorEvent evt) {
        Object o = evt.getSource();
        if (o instanceof IEntity) {
            IEntity src = (IEntity)evt.getSource();
            return "Error from " + src.getName();
        }
        Device src = (Device)evt.getSource();
        return "Error from " + src.getName();
    }

    public void errorChange(ErrorEvent evt) {
        this.setErrorOccured(evt);
    }

    public void setErrorOccured(ErrorEvent evt) {
        JOptionPane.showMessageDialog(this, evt.getError().getMessage(), this.getErrorSource(evt), 0);
    }

    private void fatalError(String message) {
        JOptionPane.showMessageDialog(null, message, "Fatal Error", 0);
        this.exitForm();
    }

    private void exitForm() {
        if (this.runFromShell) {
            System.exit(0);
        } else {
            this.hide();
            this.dispose();
        }
    }

    public void printParams() {
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: AtkTuning [-?] config_filename");
            System.exit(0);
        }
        if ("-?".equals(args[0])) {
            System.out.println("Usage: AtkTuning [-?] config_filename");
            System.out.println("  The config file is a list of tango attributes, each line is");
            System.out.println("  an attribute name (ex: eas/test-api/1/Long_attr).");
            System.out.println("  AtkTuning supports only number scalar attributes.");
            System.out.println("  The first line of the config file is the panel title.");
            System.out.println("  Sine the version 2.0, AtkTuning also supports multiple panels");
            System.out.println("  Configuration file examples:");
            System.out.println("   Version1                      Version2 (AtkTunig >2.0)");
            System.out.println("  Test panel                     #Test panel1");
            System.out.println("  jlp/test/1/att_un              jlp/test/1/att_un");
            System.out.println("  jlp/test/1/att_deux            jlp/test/1/att_deux");
            System.out.println("  jlp/test/1/att_trois           #Test panel 2");
            System.out.println("  jlp/test/1/att_quatre          jlp/test/1/att_trois");
            System.out.println("                                 jlp/test/2/att_un");
            System.exit(0);
        }
        MainPanel mainPanel = new MainPanel(args[0], true);
    }
}

