/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.BlackBoxTable;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class TopDialog
extends JDialog {
    private BlackBoxTable.BlackBox blackBox;
    private List<JTextArea> textAreaList;
    private String deviceName;
    private JTextArea hostTxt;
    private JTextArea nameTxt;
    private JTextArea operationTxt;
    private JTextArea processTxt;
    private JTextArea sourceTxt;
    private JTabbedPane tabbedPane;
    private JLabel titleLabel;

    public TopDialog(JDialog parent, String deviceName, BlackBoxTable.BlackBox blackBox) {
        super((Dialog)parent, false);
        this.blackBox = blackBox;
        this.deviceName = deviceName;
        this.initComponents();
        this.textAreaList = new ArrayList<JTextArea>();
        this.textAreaList.add(null);
        this.textAreaList.add(this.operationTxt);
        this.textAreaList.add(this.nameTxt);
        this.textAreaList.add(this.sourceTxt);
        this.textAreaList.add(this.hostTxt);
        this.textAreaList.add(this.processTxt);
        for (int i = 1; i <= 5; ++i) {
            this.textAreaList.get(i).getParent().setPreferredSize(new Dimension(500, 350));
            this.textAreaList.get(i).setFont(new Font("dialog", 1, 12));
        }
        this.tabbedPane.setSelectedIndex(4);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    void displayTop() {
        if (this.blackBox == null) {
            return;
        }
        for (int i = 1; i <= 5; ++i) {
            this.textAreaList.get(i).setText(this.computeTop(i).toString());
        }
        this.titleLabel.setText("Top on  " + this.deviceName + " during " + this.blackBox.getDeltaTimeStr());
    }

    private TopObject computeTop(int index) {
        TopObject topObject = new TopObject();
        for (int i = 0; i < this.blackBox.nbRecords(); ++i) {
            ArrayList<String> line = this.blackBox.getLine(i);
            String item = line.get(index);
            if (index == 5) {
                if (item.isEmpty()) {
                    item = "? ?";
                }
                item = item + "  (" + line.get(4) + ")";
            }
            boolean found = false;
            for (ArrayList lineItems : topObject) {
                if (!((String)lineItems.get(0)).equals(item)) continue;
                lineItems.add(item);
                found = true;
            }
            if (found) continue;
            ArrayList<String> lineItems = new ArrayList<String>();
            lineItems.add(item);
            topObject.add(lineItems);
        }
        Collections.sort(topObject, new StringListComparator());
        return topObject;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        JPanel operationPanel = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.operationTxt = new JTextArea();
        JPanel namePanel = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.nameTxt = new JTextArea();
        JPanel sourcePanel = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.sourceTxt = new JTextArea();
        JPanel hostPanel = new JPanel();
        JScrollPane jScrollPane4 = new JScrollPane();
        this.hostTxt = new JTextArea();
        JPanel pocessPanel = new JPanel();
        JScrollPane jScrollPane5 = new JScrollPane();
        this.processTxt = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TopDialog.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        operationPanel.setLayout(new BorderLayout());
        this.operationTxt.setColumns(20);
        this.operationTxt.setEditable(false);
        this.operationTxt.setRows(5);
        jScrollPane1.setViewportView(this.operationTxt);
        operationPanel.add((Component)jScrollPane1, "Center");
        this.tabbedPane.addTab("Operation", operationPanel);
        namePanel.setLayout(new BorderLayout());
        this.nameTxt.setColumns(20);
        this.nameTxt.setEditable(false);
        this.nameTxt.setRows(5);
        jScrollPane2.setViewportView(this.nameTxt);
        namePanel.add((Component)jScrollPane2, "Center");
        this.tabbedPane.addTab("Name", namePanel);
        sourcePanel.setLayout(new BorderLayout());
        this.sourceTxt.setColumns(20);
        this.sourceTxt.setEditable(false);
        this.sourceTxt.setRows(5);
        jScrollPane3.setViewportView(this.sourceTxt);
        sourcePanel.add((Component)jScrollPane3, "Center");
        this.tabbedPane.addTab("Source", sourcePanel);
        hostPanel.setLayout(new BorderLayout());
        this.hostTxt.setColumns(20);
        this.hostTxt.setEditable(false);
        this.hostTxt.setRows(5);
        jScrollPane4.setViewportView(this.hostTxt);
        hostPanel.add((Component)jScrollPane4, "Center");
        this.tabbedPane.addTab("Host", hostPanel);
        pocessPanel.setLayout(new BorderLayout());
        this.processTxt.setColumns(20);
        this.processTxt.setEditable(false);
        this.processTxt.setRows(5);
        jScrollPane5.setViewportView(this.processTxt);
        pocessPanel.add((Component)jScrollPane5, "Center");
        this.tabbedPane.addTab("Process", pocessPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        this.displayTop();
        this.setVisible(true);
    }

    class StringListComparator
    implements Comparator<ArrayList<String>> {
        StringListComparator() {
        }

        @Override
        public int compare(ArrayList<String> list1, ArrayList<String> list2) {
            if (list1.size() == list2.size()) {
                return 0;
            }
            return list1.size() < list2.size() ? 1 : -1;
        }
    }

    private class TopObject
    extends ArrayList<ArrayList<String>> {
        private TopObject() {
        }

        private double[] computeRatios() {
            int sum = 0;
            double[] ratios = new double[this.size()];
            for (List line : this) {
                sum += line.size();
            }
            int i = 0;
            for (List line : this) {
                ratios[i++] = 100.0 * (double)line.size() / (double)sum;
            }
            return ratios;
        }

        @Override
        public String toString() {
            double[] ratios = this.computeRatios();
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (List line : this) {
                sb.append(String.format("%3d", line.size())).append(" calls(").append(String.format("%5.1f", ratios[i++])).append(" %):\t").append((String)line.get(0)).append('\n');
            }
            return sb.toString();
        }
    }
}

