/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class PopupText
extends JDialog {
    private JScrollPane scrollPane;
    private JTextPane textPane;

    public PopupText(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this.pack();
        try {
            Point p = parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PopupText(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.pack();
        try {
            Point p = parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        JButton cancelButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.textPane = new JTextPane();
        this.textPane.setFont(new Font("monospaced", 1, 12));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupText.this.closeDialog(evt);
            }
        });
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        cancelButton.setText("Dismiss");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupText.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.scrollPane.setViewportView(this.textPane);
        this.getContentPane().add((Component)this.scrollPane, "Center");
    }

    @Override
    public void setFont(Font font) {
        this.textPane.setFont(font);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void showMsg(String text, SimpleAttributeSet attrs) {
        Document doc = this.textPane.getDocument();
        try {
            doc.insertString(doc.getLength(), text, attrs);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void showFormatted(String text) {
        int end;
        int nbLines = 0;
        int start = 0;
        while ((end = text.indexOf(10, start)) >= 0) {
            String line = text.substring(start, ++end);
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            if (line.indexOf(58) < 0) {
                StyleConstants.setBold(attrs, false);
            } else {
                StyleConstants.setBold(attrs, true);
            }
            int start1 = line.indexOf("Running");
            if (start1 > 0) {
                this.showMsg(line.substring(0, start1), attrs);
                StyleConstants.setForeground(attrs, Color.green);
                this.showMsg(line.substring(start1), attrs);
            } else {
                start1 = line.indexOf("Stopped");
                if (start1 > 0) {
                    this.showMsg(line.substring(0, start1), attrs);
                    StyleConstants.setForeground(attrs, Color.red);
                    this.showMsg(line.substring(start1), attrs);
                } else {
                    StyleConstants.setForeground(attrs, Color.black);
                    this.showMsg(line, attrs);
                }
            }
            start = end;
            ++nbLines;
        }
        this.textPane.setEditable(false);
        this.textPane.setSize(400, 300);
        this.scrollPane.setPreferredSize(new Dimension(450, 350));
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void setTitle(String title) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        int fs = StyleConstants.getFontSize(attrs);
        StyleConstants.setBold(attrs, true);
        StyleConstants.setUnderline(attrs, true);
        StyleConstants.setFontSize(attrs, fs + 4);
        this.showMsg(title + "\n\n", attrs);
    }

    public void show(String text) {
        this.textPane.setText(text);
        this.textPane.setEditable(false);
        this.scrollPane.setPreferredSize(new Dimension(450, 350));
        this.pack();
        this.setVisible(true);
    }

    public void show(String title, String[] array, int width, int height) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        int fs = StyleConstants.getFontSize(attrs);
        StyleConstants.setBold(attrs, true);
        StyleConstants.setUnderline(attrs, true);
        StyleConstants.setFontSize(attrs, fs + 4);
        this.showMsg(title + "\n\n", attrs);
        StyleConstants.setBold(attrs, false);
        StyleConstants.setUnderline(attrs, false);
        StyleConstants.setFontSize(attrs, fs);
        for (String str : array) {
            this.showMsg(str + "\n", attrs);
        }
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(width, height));
        this.scrollPane.setPreferredSize(new Dimension(width, height));
        this.pack();
        this.setVisible(true);
    }

    public void show(String title, String[] array) {
        this.show(title, array, 800, 600);
    }

    public void show(String text, int sizeX, int sizeY) {
        this.textPane.setText(text);
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(sizeX, sizeY));
        this.scrollPane.setPreferredSize(new Dimension(sizeX, sizeY));
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void setSize(int width, int height) {
        this.textPane.setPreferredSize(new Dimension(width, height));
        this.scrollPane.setPreferredSize(new Dimension(width, height));
        this.pack();
    }

    public void addText(String text) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        int fs = StyleConstants.getFontSize(attrs);
        StyleConstants.setBold(attrs, false);
        StyleConstants.setUnderline(attrs, false);
        StyleConstants.setFontSize(attrs, fs);
        this.showMsg(text + "\n", attrs);
        this.textPane.setEditable(false);
    }

    public static void main(String[] args) {
        PopupText pt = new PopupText(new JFrame(), true);
        pt.show("My Title", new String[]{"Line #1", "line #2", "Bla bla bla !"});
    }
}

