/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.PoolThreadsTree;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class PoolThreadsManager
extends JDialog {
    private Component parent;
    private TangoHost host;
    private TangoServer server;
    private PoolThreadsTree tree;
    private JScrollPane scrollPane = null;
    private JPanel centerPanel;
    private JMenu editMenu;
    private JMenuItem newThreadItem;
    private JMenuItem removeThreadItem;
    private JTextArea warningTextArea;

    public PoolThreadsManager(JFrame parent, TangoHost host, TangoServer server) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.host = host;
        this.server = server;
        this.createForm();
    }

    public PoolThreadsManager(JFrame parent, TangoServer server) throws DevFailed {
        this(parent, null, server);
    }

    public PoolThreadsManager(JDialog parent, TangoHost host, TangoServer server) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.host = host;
        this.server = server;
        this.createForm();
    }

    public PoolThreadsManager(JDialog parent, TangoServer server) throws DevFailed {
        this(parent, null, server);
    }

    public PoolThreadsManager(JFrame parent, TangoHost host, String servname) throws DevFailed {
        this(parent, host, new TangoServer(servname.startsWith("dserver/") ? servname : "dserver/" + servname));
    }

    public PoolThreadsManager(JDialog parent, TangoHost host, String servname) throws DevFailed {
        this(parent, host, new TangoServer(servname.startsWith("dserver/") ? servname : "dserver/" + servname));
    }

    public PoolThreadsManager(JFrame parent, String servname) throws DevFailed {
        this(parent, null, servname);
    }

    public PoolThreadsManager(JDialog parent, String servname) throws DevFailed {
        this(parent, null, servname);
    }

    private void createForm() throws DevFailed {
        int idl;
        this.initComponents();
        try {
            idl = this.server.get_idl_version();
        }
        catch (DevFailed e) {
            idl = 0;
        }
        if (idl > 0 && idl < 4) {
            Except.throw_non_supported_exception((String)"BAD_IDL_VERSION", (String)("The server is compiled with IDL " + idl + "\nThis feature is allowed only with IDL 4 (TANGO 7) and above"), (String)"PoolThreadsManager.PoolThreadsManager()");
        }
        this.warningTextArea.setVisible(idl == 0);
        this.initializeTree();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public void initializeTree() throws DevFailed {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(new Dimension(350, 400));
            this.centerPanel.add((Component)this.scrollPane, "Center");
        } else if (this.tree != null) {
            this.scrollPane.remove(this.tree);
        }
        this.tree = new PoolThreadsTree(this, this.server);
        this.scrollPane.setViewportView(this.tree);
        this.editMenu.setMnemonic('E');
        this.newThreadItem.setMnemonic('N');
        this.removeThreadItem.setMnemonic('R');
        this.newThreadItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.removeThreadItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.centerPanel = new JPanel();
        this.warningTextArea = new JTextArea();
        JPanel jPanel1 = new JPanel();
        JLabel titleLabel = new JLabel();
        JMenuBar jMenuBar = new JMenuBar();
        this.editMenu = new JMenu();
        this.newThreadItem = new JMenuItem();
        this.removeThreadItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PoolThreadsManager.this.closeDialog(evt);
            }
        });
        okBtn.setText("Apply");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoolThreadsManager.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoolThreadsManager.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.warningTextArea.setColumns(20);
        this.warningTextArea.setEditable(false);
        this.warningTextArea.setFont(new Font("Dialog", 1, 12));
        this.warningTextArea.setRows(3);
        this.warningTextArea.setText("Warning:\nIDL server cannot be checked.\nThis feature is avalable only for TANGO-7 (or above) servers.");
        this.centerPanel.add((Component)this.warningTextArea, "South");
        titleLabel.setFont(new Font("Dialog", 1, 14));
        titleLabel.setText("Polling Threads Mangement");
        jPanel1.add(titleLabel);
        this.centerPanel.add((Component)jPanel1, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.editMenu.setText("Edit");
        this.newThreadItem.setText("New Thread");
        this.newThreadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoolThreadsManager.this.newThreadItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.newThreadItem);
        this.removeThreadItem.setText("Remove Thread");
        this.removeThreadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PoolThreadsManager.this.removeThreadItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.removeThreadItem);
        jMenuBar.add(this.editMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
    }

    private void removeThreadItemActionPerformed(ActionEvent evt) {
        if (this.tree.selectedObjectIsThread()) {
            this.tree.removeThread();
        }
    }

    private void newThreadItemActionPerformed(ActionEvent evt) {
        this.tree.addThreadNode();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this.parent, "Apply pool thread configuration to database ?", "Confirm Dialog", 0) == 0) {
            this.tree.putPoolThreadInfo();
            if (this.host != null) {
                this.server.restart(this.parent, this.host, false);
            } else {
                JOptionPane.showMessageDialog(this, "Database has been updated.\nRestart the server now.", "Command Done", 1);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent != null) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                Except.throw_exception((String)"BAD_SYNTAX", (String)"Server name ?", (String)"admin.astor.tools.PoolThreadsManager.main()");
            }
            new PoolThreadsManager((JFrame)null, args[0]).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), (String)"", (DevFailed)e);
            System.exit(0);
        }
    }
}

