/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconStateDialog
extends JDialog {
    private JFrame parent;
    private JPanel centerPanel;
    private JLabel titleLabel;

    public IconStateDialog(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.buildIconStatePanel();
        this.titleLabel.setText("Help on state icons");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void buildIconStatePanel() {
        int i;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 20, 2, 20);
        JLabel label = new JLabel("On Hosts");
        label.setFont(new Font("Dialog", 1, 14));
        this.centerPanel.add((Component)label, gbc);
        gbc.insets = new Insets(2, 20, 2, 20);
        for (i = 0; i < AstorDefs.iconHelpForHosts.length; ++i) {
            label = new JLabel(AstorDefs.iconHelpForHosts[i]);
            label.setIcon(AstorUtil.state_icons[i]);
            ++gbc.gridy;
            this.centerPanel.add((Component)label, gbc);
        }
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 20, 2, 20);
        label = new JLabel("On Servers");
        label.setFont(new Font("Dialog", 1, 14));
        gbc.insets = new Insets(10, 20, 2, 20);
        this.centerPanel.add((Component)label, gbc);
        gbc.insets = new Insets(2, 20, 2, 20);
        for (i = 0; i < AstorDefs.iconHelpForServers.length; ++i) {
            if (AstorDefs.iconHelpForServers[i] == null) continue;
            label = new JLabel(AstorDefs.iconHelpForServers[i]);
            label.setIcon(AstorUtil.state_icons[i]);
            ++gbc.gridy;
            this.centerPanel.add((Component)label, gbc);
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                IconStateDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconStateDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        AstorUtil.getInstance().initIcons();
        new IconStateDialog(null).setVisible(true);
    }
}

