/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.tools.DeviceHierarchy;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class DeviceHierarchyDialog
extends JDialog {
    private Component parent;
    private DeviceHierarchy tree = null;
    private String name;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JTextArea textArea;
    private JLabel titleLabel;

    public DeviceHierarchyDialog(JFrame parent, String name) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.name = name;
        this.init();
    }

    public DeviceHierarchyDialog(JDialog parent, String name) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.name = name;
        this.init();
    }

    private void init() throws DevFailed {
        try {
            AstorUtil.startSplash("Device Hierarchy");
            this.initComponents();
            this.initOwnComponents();
            this.titleLabel.setText("Device hierarchy for  " + this.name);
            this.pack();
            if (this.parent != null) {
                Point p = this.parent.getLocation();
                p.translate(40, 30);
                this.setLocation(p);
            }
            AstorUtil.stopSplash();
        }
        catch (DevFailed e) {
            AstorUtil.stopSplash();
            throw e;
        }
    }

    private void initOwnComponents() throws DevFailed {
        if (this.tree != null) {
            this.tree.stopThread();
        }
        Astor astor = null;
        if (this.parent instanceof HostInfoDialog) {
            astor = ((HostInfoDialog)this.parent).getAstorObject();
        }
        this.tree = new DeviceHierarchy(this, astor, this.name);
        this.scrollPane1.setViewportView(this.tree);
        this.scrollPane1.setPreferredSize(new Dimension(400, 400));
        this.scrollPane2.setPreferredSize(new Dimension(400, 400));
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JSplitPane splitPane = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.scrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DeviceHierarchyDialog.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceHierarchyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        splitPane.setLeftComponent(this.scrollPane1);
        this.textArea.setColumns(20);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Monospaced", 1, 12));
        this.textArea.setRows(5);
        this.scrollPane2.setViewportView(this.textArea);
        splitPane.setRightComponent(this.scrollPane2);
        this.getContentPane().add((Component)splitPane, "Center");
        this.pack();
    }

    void setText(String str) {
        this.textArea.setText(str);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    void update() {
        try {
            AstorUtil.startSplash("Device Hierarchy");
            this.initOwnComponents();
            AstorUtil.stopSplash();
        }
        catch (DevFailed e) {
            AstorUtil.stopSplash();
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void doClose() {
        if (this.parent != null) {
            this.setVisible(false);
            this.tree.stopThread();
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        String serverName = "VacGaugeServer/sr_c27-ip";
        if (args.length > 0) {
            serverName = args[0];
        }
        try {
            AstorUtil.getInstance().initIcons();
            DeviceHierarchyDialog dlg = new DeviceHierarchyDialog((JFrame)null, serverName);
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
        }
    }
}

