/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.DevPropertyDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DbServerArchitecture
extends JDialog {
    private Component parent;
    private Server server;
    private ServerTree tree;
    static final Dimension dimension = new Dimension(290, 400);
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public DbServerArchitecture(JFrame parent, String servname) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.createDialog(servname);
    }

    public DbServerArchitecture(JDialog parent, String servname) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.createDialog(servname);
    }

    private void createDialog(String servname) throws DevFailed {
        new DeviceProxy("dserver/" + servname);
        this.initComponents();
        this.setTitle("Server in Database");
        this.titleLabel.setText(servname + " architecture");
        this.server = new Server(servname);
        JScrollPane spane = new JScrollPane();
        spane.setPreferredSize(dimension);
        this.tree = new ServerTree(this);
        spane.add(this.tree);
        spane.setViewportView(this.tree);
        this.getContentPane().add((Component)spane, "Center");
        this.okBtn.setVisible(false);
        this.cancelBtn.setText("Dismiss");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DbServerArchitecture.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbServerArchitecture.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbServerArchitecture.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        String servname = null;
        if (args.length > 0) {
            servname = args[0];
        }
        try {
            if (servname == null) {
                Except.throw_exception((String)"ServerName_Unknown", (String)"No Server name ?????", (String)"DbServerArchitecture()");
            }
            new DbServerArchitecture((JFrame)null, servname).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"DbServerArchitecture", (DevFailed)e);
            System.exit(0);
        }
    }

    private class ServerRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon root_icon = Utils.getInstance().getIcon("server.gif");
        private ImageIcon server_icon = Utils.getInstance().getIcon("server.gif");
        private ImageIcon class_icon = Utils.getInstance().getIcon("class.gif");
        private ImageIcon device_icon = Utils.getInstance().getIcon("device.gif");
        private ImageIcon list_icon = Utils.getInstance().getIcon("greenbal.gif");
        private ImageIcon empty_icon = Utils.getInstance().getIcon("greyball.gif");
        private ImageIcon att_icon = Utils.getInstance().getIcon("uleaf.gif");
        private Font[] fonts = new Font[4];
        private static final int ROOT = 0;
        private static final int SERVER = 1;
        private static final int CLASS = 2;
        private static final int DEVICE = 2;
        private static final int ATTR = 3;

        public ServerRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
            this.fonts[3] = new Font("Dialog", 0, 10);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object o = node.getUserObject();
            if (row == 0) {
                this.setIcon(this.root_icon);
                this.setBackgroundSelectionColor(Color.white);
                this.setBackgroundNonSelectionColor(Color.white);
                this.setFont(this.fonts[0]);
            } else if (o instanceof Server) {
                this.setIcon(this.server_icon);
                this.setFont(this.fonts[1]);
            } else if (o instanceof TangoClass) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[2]);
            } else if (o instanceof TangoDevice) {
                this.setIcon(this.device_icon);
                this.setFont(this.fonts[2]);
            } else if (o instanceof String) {
                if (node.isLeaf()) {
                    this.setIcon(this.empty_icon);
                } else {
                    this.setIcon(this.list_icon);
                }
                this.setFont(this.fonts[3]);
            } else if (o instanceof TangoAtt) {
                this.setIcon(this.att_icon);
                this.setFont(this.fonts[3]);
            }
            return this;
        }
    }

    class ServerTree
    extends JTree {
        private JDialog dialog;
        private DefaultTreeModel treeModel;

        public ServerTree(JDialog dialog) {
            this.dialog = dialog;
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(((DbServerArchitecture)DbServerArchitecture.this).server.name);
            for (int i = 0; i < ((DbServerArchitecture)DbServerArchitecture.this).server.classes.length; ++i) {
                DefaultMutableTreeNode cn = new DefaultMutableTreeNode(((DbServerArchitecture)DbServerArchitecture.this).server.classes[i]);
                this.craateDeviceNodes(cn, ((DbServerArchitecture)DbServerArchitecture.this).server.classes[i]);
                root.add(cn);
            }
            this.getSelectionModel().setSelectionMode(4);
            this.treeModel = new DefaultTreeModel(root);
            this.setModel(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setCellRenderer(new ServerRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ServerTree.this.treeMouseClicked(evt);
                }
            });
        }

        private void craateDeviceNodes(DefaultMutableTreeNode p_node, TangoClass _class) {
            for (int i = 0; i < _class.devices.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)_class.devices[i]);
                this.craateAttributeNodes(node, _class.devices[i]);
                p_node.add(node);
            }
        }

        private void craateAttributeNodes(DefaultMutableTreeNode p_node, TangoDevice dev) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode("Attributes");
            p_node.add(n);
            for (int i = 0; i < dev.attributes.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(dev.attributes[i]);
                n.add(node);
            }
        }

        private void treeMouseClicked(MouseEvent evt) {
            if (DbServerArchitecture.this.tree.getRowForLocation(evt.getX(), evt.getY()) < 1) {
                return;
            }
            TreePath selectedPath = DbServerArchitecture.this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
            Object o = node.getUserObject();
            int mask = evt.getModifiers();
            if (evt.getClickCount() == 2 && (mask & 0x10) != 0 && o instanceof TangoAtt) {
                TangoAtt att = (TangoAtt)o;
                TangoDevice dev = null;
                for (int idx = selectedPath.getPathCount() - 2; dev == null && idx > 0; --idx) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)selectedPath.getPathComponent(idx);
                    Object obj = n.getUserObject();
                    if (!(obj instanceof TangoDevice)) continue;
                    dev = (TangoDevice)((Object)obj);
                }
                if (dev == null) {
                    System.out.println("TangoDevice not found");
                } else {
                    DevPropertyDialog dlg = new DevPropertyDialog(this.dialog, dev, att);
                    dlg.setVisible(true);
                }
            }
        }
    }

    class TangoAttProp {
        String name;
        String strval;

        public TangoAttProp(String name, String strval) {
            this.name = name;
            this.strval = strval;
        }

        public String toString() {
            return this.name;
        }
    }

    class TangoAtt {
        String name;
        DbAttribute att;
        TangoAttProp[] prop;

        public TangoAtt(DbAttribute att) throws DevFailed {
            this.name = att.name;
            this.att = att;
            String[] attprop = att.get_property_list();
            this.prop = new TangoAttProp[attprop.length];
            for (int j = 0; j < attprop.length; ++j) {
                this.prop[j] = new TangoAttProp(attprop[j], att.get_string_value(attprop[j]));
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class TangoDevice
    extends DbDevice {
        String name;
        DbDatum[] properties;
        TangoAtt[] attributes;

        public TangoDevice(String name) throws DevFailed {
            String[] attnames;
            super(name);
            this.name = name;
            this.properties = this.get_property(this.get_property_list("*"));
            Database db = ApiUtil.get_db_obj();
            try {
                attnames = this.get_attribute_list();
            }
            catch (NoSuchMethodError e) {
                System.out.println(e);
                System.out.println("get_device_attribute_list() not found in Database class");
                DeviceData argin = new DeviceData();
                argin.insert(new String[]{name, "*"});
                DeviceData argout = db.command_inout("DbGetDeviceAttributeList", argin);
                attnames = argout.extractStringArray();
            }
            DbAttribute[] db_att = db.get_device_attribute_property(name, attnames);
            this.attributes = new TangoAtt[attnames.length];
            for (int i = 0; i < attnames.length; ++i) {
                this.attributes[i] = new TangoAtt(db_att[i]);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class TangoClass {
        String name;
        TangoDevice[] devices;

        public TangoClass(String classname, String[] devnames) throws DevFailed {
            this.name = classname;
            this.devices = new TangoDevice[devnames.length];
            for (int i = 0; i < devnames.length; ++i) {
                this.devices[i] = new TangoDevice(devnames[i]);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class Server
    extends DbServer {
        String name;
        TangoClass[] classes;

        public Server(String name) throws DevFailed {
            super(name);
            this.name = name;
            String[] classnames = this.get_class_list();
            this.classes = new TangoClass[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                String[] devnames = this.get_device_name(classnames[i]);
                this.classes[i] = new TangoClass(classnames[i], devnames);
            }
        }

        public String toString() {
            String str = this.name + "\n";
            for (TangoClass _class : this.classes) {
                str = str + _class + "\n";
            }
            return str.trim();
        }
    }
}

