/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.tango_release.TangoClassRelease;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TangoServerRelease
extends ArrayList<TangoClassRelease> {
    String name;
    String exeName;
    String instanceName;
    double releaseNumber = 0.0;
    String error = "";
    private static final String dserverClassName = "DServer";

    public TangoServerRelease(String serverName) {
        this.name = serverName;
        StringTokenizer stk = new StringTokenizer(serverName, "/");
        this.exeName = stk.nextToken();
        this.instanceName = stk.nextToken();
        try {
            DbServer dbServer = new DbServer(serverName);
            int release = new DeviceProxy("dserver/" + serverName).getTangoVersion();
            String[] classNames = this.getClasses(dbServer);
            if (release >= 100) {
                this.releaseNumber = 0.01 * (double)release;
            }
            if (classNames.length > 0) {
                for (String className : classNames) {
                    this.add(new TangoClassRelease(dbServer, className));
                }
            } else {
                this.error = "No class found on server " + this.name;
            }
        }
        catch (DevFailed e) {
            this.error = e.errors[0].desc;
        }
        catch (NoSuchMethodError e) {
            this.error = "TangORB is too old to check Tango release.";
        }
    }

    public String[] getClasses(DbServer dbServer) throws DevFailed {
        return dbServer.get_class_list();
    }

    public boolean hasIDL(int idl) {
        for (TangoClassRelease classRelease : this) {
            if (classRelease.idl != idl || classRelease.className.equals(dserverClassName)) continue;
            return true;
        }
        return false;
    }

    public List<TangoClassRelease> getIdlClasses(int idl) {
        ArrayList<TangoClassRelease> list = new ArrayList<TangoClassRelease>();
        for (TangoClassRelease classRelease : this) {
            if (classRelease.idl != idl || classRelease.className.equals(dserverClassName)) continue;
            list.add(classRelease);
        }
        return list;
    }

    public String toStringFull() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append("\n");
        for (TangoClassRelease classRelease : this) {
            sb.append(classRelease).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name + " (");
        if (this.releaseNumber >= 1.0) {
            sb.append("Tango-").append(String.format("%4.2f", this.releaseNumber));
        } else {
            sb.append(this.error);
        }
        sb.append(")");
        return sb.toString();
    }

    public static void main(String[] args) {
        String serverName = "VacGaugeServer/sr_c1-pen";
        if (args.length > 0) {
            serverName = args[0];
        }
        try {
            TangoServerRelease client = new TangoServerRelease(serverName);
            System.out.println(client);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

