/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.AstorUtil;
import admin.astor.statistics.LogRecord;
import admin.astor.statistics.ServerStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class StarterStat
extends ArrayList<ServerStat> {
    public String name;
    public boolean readOK = false;
    public long resetTime = System.currentTimeMillis();
    public String error = "";
    public List<String> runningTwiceList = new ArrayList<String>();
    public static final String className = "StarterStat";
    private static final String hostStr = "host";
    private static final String readStr = "read";
    private static final String resetStr = "reset";
    private static final String description = "<StarterStat host=\"HOST\" read=\"READ\" reset=\"RESET\">";
    private static final String tab = "\t\t";
    public static final String[] tableHeader = new String[]{"Server", "Run Time", "Failures", "Failure Duration"};

    public StarterStat(String name) {
        this.name = name;
        this.readStatisticsFromStarter(name);
    }

    public StarterStat(List<String> lines) throws DevFailed {
        this.parseXmlStatistics(lines);
    }

    private void readStatisticsFromStarter(String name) {
        DeviceProxy proxy;
        String devName = AstorUtil.getStarterDeviceHeader() + name;
        try {
            proxy = new DeviceProxy(devName);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
            this.error = e.errors[0].desc;
            return;
        }
        try {
            this.buildControlledServerList(proxy);
            this.readStatisticsFileFromStarter(proxy);
            this.readOK = true;
        }
        catch (DevFailed e) {
            System.err.println(name + ":\t" + e.errors[0].desc);
            this.error = e.errors[0].desc;
            this.resetTime = System.currentTimeMillis();
        }
    }

    private void buildControlledServerList(DeviceProxy dev) throws DevFailed {
        String[] lines;
        DeviceAttribute att = dev.read_attribute("Servers");
        for (String line : lines = att.extractStringArray()) {
            StringTokenizer stk = new StringTokenizer(line);
            String serverName = stk.nextToken();
            stk.nextToken();
            String strLevel = stk.nextToken();
            String strCtrl = stk.nextToken();
            if (strLevel.equals("0") || strCtrl.equals("0")) continue;
            this.add(new ServerStat(serverName, this));
        }
    }

    public void readStatisticsFileFromStarter(DeviceProxy proxy) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert("Statistics");
        DeviceData argOut = proxy.command_inout("DevReadLog", argIn);
        String str = argOut.extractString();
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        StringTokenizer stk = new StringTokenizer(str, "\n");
        while (stk.hasMoreTokens()) {
            LogRecord record = new LogRecord(stk.nextToken());
            records.add(record);
        }
        this.resetTime = System.currentTimeMillis();
        this.buildServerStatistics(records);
        for (ServerStat server : this) {
            long t;
            server.computeStatistics();
            if (server.size() <= 0 || (t = server.oldestTime) >= this.resetTime) continue;
            this.resetTime = t;
        }
        try {
            String[] lines;
            DeviceAttribute attribute = proxy.read_attribute("Servers");
            for (String line : lines = attribute.extractStringArray()) {
                stk = new StringTokenizer(line);
                if (stk.countTokens() < 5) {
                    return;
                }
                String serverName = stk.nextToken();
                stk.nextToken();
                stk.nextToken();
                stk.nextToken();
                try {
                    if (Integer.parseInt(stk.nextToken()) <= 1) continue;
                    this.runningTwiceList.add(serverName);
                }
                catch (NumberFormatException e) {
                    System.err.println(this.name + ": " + e.toString());
                    return;
                }
            }
        }
        catch (DevFailed e) {
            System.err.println(this.name + ": " + e.errors[0].desc);
        }
    }

    private void buildServerStatistics(List<LogRecord> records) {
        for (LogRecord rec : records) {
            ServerStat server = this.getServerStat(rec.name);
            if (server == null) {
                server = new ServerStat(rec.name, this);
                this.add(server);
            }
            server.addLog(rec);
        }
    }

    public ServerStat getServerStat(String name) {
        for (ServerStat server : this) {
            if (!server.name.equals(name)) continue;
            return server;
        }
        return null;
    }

    public String[][] toTable() {
        String[][] array = new String[this.size()][tableHeader.length];
        int row = 0;
        for (ServerStat server : this) {
            int col = 0;
            array[row][col++] = server.name;
            array[row][col++] = Utils.formatDuration(server.runDuration);
            array[row][col++] = Integer.toString(server.nbFailures);
            array[row][col] = server.nbFailures > 0 ? Utils.formatDuration(server.failedDuration) : "";
            ++row;
        }
        return array;
    }

    public String toString(String serverName) {
        return this.getServerStat(serverName).recordsToString();
    }

    private String toXmlLine() {
        String str = description;
        str = Utils.strReplace(str, "HOST", this.name);
        str = Utils.strReplace(str, "READ", Boolean.toString(this.readOK));
        str = Utils.strReplace(str, "RESET", Long.toString(this.resetTime));
        return str;
    }

    private void parseXmlStatistics(List<String> lines) throws DevFailed {
        this.parseXmlProperties(lines.get(0));
        ArrayList<String> records = new ArrayList<String>();
        boolean inServer = false;
        for (int i = 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!inServer && line.startsWith("<ServerStat")) {
                inServer = true;
                records.add(line);
                continue;
            }
            if (line.startsWith("</ServerStat")) {
                ServerStat serverStat = new ServerStat((List<String>)records);
                serverStat.starterStat = this;
                this.add(serverStat);
                inServer = false;
                records.clear();
                continue;
            }
            if (!inServer) continue;
            records.add(line);
        }
    }

    private void parseXmlProperties(String line) throws DevFailed {
        this.name = Utils.parseXmlProperty(line, hostStr);
        try {
            this.readOK = Boolean.parseBoolean(Utils.parseXmlProperty(line, readStr));
            this.resetTime = Long.parseLong(Utils.parseXmlProperty(line, resetStr));
        }
        catch (NumberFormatException e) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)e.toString(), (String)"StarterStat.parseLine()");
        }
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append(tab).append(this.toXmlLine()).append("\n");
        for (ServerStat serverStat : this) {
            sb.append(serverStat.toXml()).append("\n");
        }
        sb.append(tab).append("</").append(className).append(">");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        long duration = System.currentTimeMillis() - this.resetTime;
        sb.append("   Since ").append(Utils.formatDate(this.resetTime)).append("  (").append(Utils.formatDuration(duration)).append(")\n");
        for (ServerStat server : this) {
            sb.append(server).append("\n");
        }
        return sb.toString();
    }
}

