/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerRecord;
import admin.astor.statistics.ServerStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ServerStatisticsTable
extends JTable {
    private ServerStat serverStatistics;
    private ServerStat filteredStatistics;
    private DataTableModel model;
    private static final int STATE = 0;
    private static final int START_TIME = 1;
    private static final int END_TIME = 2;
    private static final int DURATION = 3;
    private static final int AUTO_START = 4;
    private final Column[] columns = new Column[]{new Column("State", 50), new Column("Begin", 150), new Column("End", 150), new Column("Duration", 170), new Column("Started", 50)};

    public ServerStatisticsTable(ServerStat serverStatistics) {
        this.serverStatistics = serverStatistics;
        this.copyServerStat();
        this.buildTableComponent();
    }

    private void copyServerStat() {
        this.filteredStatistics = new ServerStat(this.serverStatistics.name);
        this.filteredStatistics.starterStat = this.serverStatistics.starterStat;
        this.filteredStatistics.nbFailures = this.serverStatistics.nbFailures;
        this.filteredStatistics.failedDuration = this.serverStatistics.failedDuration;
        this.filteredStatistics.runDuration = this.serverStatistics.runDuration;
        this.filteredStatistics.oldestTime = this.serverStatistics.oldestTime;
        for (ServerRecord rec : this.serverStatistics) {
            this.filteredStatistics.add(rec);
        }
    }

    private void buildTableComponent() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setDragEnabled(false);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ServerStatisticsTable.this.tableActionPerformed(evt);
            }
        });
        this.model = new DataTableModel();
        this.setModel(this.model);
        this.setDefaultRenderer(String.class, new StatCellRenderer());
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ServerStatisticsTable.this.headerTableActionPerformed(evt);
            }
        });
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tc = enumeration.nextElement();
            tc.setPreferredWidth(this.columns[i++].width);
        }
        this.sort(1);
    }

    public int getDefaultHeight() {
        int max = 600;
        int height = 22 + 17 * this.filteredStatistics.size();
        if (height > max) {
            height = max;
        }
        return height;
    }

    public int getDefaultWidth() {
        int width = 0;
        for (Column column : this.columns) {
            width += column.width;
        }
        return width;
    }

    private void tableActionPerformed(MouseEvent evt) {
    }

    private void headerTableActionPerformed(MouseEvent evt) {
        this.sort(this.getTableHeader().columnAtPoint(new Point(evt.getX(), evt.getY())));
    }

    private void sort(int column) {
        MyCompare compare = new MyCompare();
        compare.setSelectedColumn(column);
        Collections.sort(this.filteredStatistics, compare);
        this.model.fireTableDataChanged();
    }

    private String getRecordValueString(ServerRecord record, int column) {
        switch (column) {
            case 0: {
                return record.stateName;
            }
            case 1: {
                return Utils.formatDate(record.startTime);
            }
            case 2: {
                return Utils.formatDate(record.endTime);
            }
            case 3: {
                return Utils.formatDuration(record.duration);
            }
            case 4: {
                if (record.state == DevState.ON) {
                    if (record.autoRestart == 2) {
                        return "Auto";
                    }
                    if (record.autoRestart == 1) {
                        return "On Req.";
                    }
                    return "";
                }
                return "";
            }
        }
        return "--";
    }

    public void setFilterOnRunning(boolean b) {
        this.filteredStatistics.clear();
        for (ServerRecord rec : this.serverStatistics) {
            if (!b && rec.state != DevState.FAULT) continue;
            this.filteredStatistics.add(rec);
        }
        this.model.fireTableDataChanged();
    }

    class MyCompare
    implements Comparator<ServerRecord> {
        private int column;

        MyCompare() {
        }

        private void setSelectedColumn(int column) {
            this.column = column;
        }

        @Override
        public int compare(ServerRecord record1, ServerRecord record2) {
            switch (this.column) {
                case 1: {
                    return record1.startTime < record2.startTime ? 1 : 0;
                }
                case 2: {
                    return record1.endTime < record2.endTime ? 1 : 0;
                }
                case 3: {
                    return record1.duration < record2.duration ? 1 : 0;
                }
                case 4: {
                    return record1.autoRestart < record2.autoRestart ? 1 : 0;
                }
            }
            return record1.stateName.compareTo(record2.stateName) > 0 ? 1 : 0;
        }
    }

    public class StatCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public StatCellRenderer() {
            this.setFont(new Font("Dialog", 0, 12));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ServerRecord record = (ServerRecord)ServerStatisticsTable.this.filteredStatistics.get(row);
            if (record.state == DevState.FAULT) {
                this.setBackground(Color.orange);
            } else {
                this.setBackground(Color.green);
            }
            this.setText(ServerStatisticsTable.this.getRecordValueString(record, column));
            if (column == 4) {
                if (record.autoRestart == 2) {
                    this.setToolTipText("Auto restarted by Starter");
                } else if (record.autoRestart == 1) {
                    this.setToolTipText("Started on Request");
                } else {
                    this.setToolTipText("");
                }
            } else {
                this.setToolTipText("");
            }
            return this;
        }
    }

    public class DataTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return ServerStatisticsTable.this.columns.length;
        }

        @Override
        public int getRowCount() {
            return ServerStatisticsTable.this.filteredStatistics.size();
        }

        @Override
        public String getColumnName(int col) {
            return ((ServerStatisticsTable)ServerStatisticsTable.this).columns[col].name;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ServerRecord record = (ServerRecord)ServerStatisticsTable.this.filteredStatistics.get(row);
            return ServerStatisticsTable.this.getRecordValueString(record, col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class Column {
        String name;
        int width;

        Column(String name, int width) {
            this.name = name;
            this.width = width;
        }
    }
}

