/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.ServerStatisticsTable;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ServerStatisticsPanel
extends JDialog {
    private Window parent;
    private ServerStatisticsTable statisticsTable;
    private JRadioButton filterBtn;
    private JLabel titleLabel;

    public ServerStatisticsPanel(JFrame parent, String title, ServerStat serverStat) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.buildForm(serverStat);
        this.titleLabel.setText(title);
    }

    public ServerStatisticsPanel(JDialog parent, String title, ServerStat serverStat) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.initComponents();
        this.buildForm(serverStat);
        this.titleLabel.setText(title);
    }

    private void buildForm(ServerStat serverStat) {
        this.statisticsTable = new ServerStatisticsTable(serverStat);
        JScrollPane scp = new JScrollPane();
        scp.setPreferredSize(new Dimension(this.statisticsTable.getDefaultWidth(), this.statisticsTable.getDefaultHeight()));
        scp.setViewportView(this.statisticsTable);
        this.getContentPane().add((Component)scp, "Center");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        this.filterBtn = new JRadioButton();
        JLabel dummyLbl = new JLabel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServerStatisticsPanel.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.filterBtn.setSelected(true);
        this.filterBtn.setText("Display Running ones");
        this.filterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatisticsPanel.this.filterBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.filterBtn);
        dummyLbl.setText("                                 ");
        bottomPanel.add(dummyLbl);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerStatisticsPanel.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void filterBtnActionPerformed(ActionEvent evt) {
        boolean b = this.filterBtn.getSelectedObjects() != null;
        this.statisticsTable.setFilterOnRunning(b);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent == null) {
            System.exit(0);
        }
    }
}

