/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.ctrl_system_info;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;

public class ScanningControlSystem {
    private List<String> classList = new ArrayList<String>();
    private List<String> binaryList = new ArrayList<String>();
    private List<String> stoppedList = new ArrayList<String>();
    private List<TangoCommand> dServerCommands = new ArrayList<TangoCommand>();
    private StringBuilder results = new StringBuilder();

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("File and Host names ?");
        } else {
            String fileName = args[0];
            ArrayList<String> hostNames = new ArrayList<String>();
            hostNames.addAll(Arrays.asList(args).subList(1, args.length));
            System.out.println("Stating scan - put results in " + fileName);
            new ScanningControlSystem(fileName, hostNames);
        }
    }

    public ScanningControlSystem(String fileName, List<String> hostNames) {
        try {
            ArrayList<TangoHost> hostList = new ArrayList<TangoHost>();
            for (String hostName : hostNames) {
                hostList.add(new TangoHost(hostName));
            }
            int nbServers = 0;
            int nbDevices = 0;
            int nbControlPoints = 0;
            int nbAttributes = 0;
            int nbCommands = 0;
            for (TangoHost tangoHost : hostList) {
                nbServers += tangoHost.size();
                for (TangoServer tangoServer : tangoHost) {
                    nbDevices += tangoServer.size();
                    for (TangoDevice tangoDevice : tangoServer) {
                        nbAttributes += tangoDevice.size();
                        nbCommands += tangoDevice.commands.size();
                        for (TangoAttribute attribute : tangoDevice) {
                            nbControlPoints += attribute.controlPoint;
                        }
                        for (TangoCommand command : tangoDevice.commands) {
                            nbControlPoints += command.controlPoint;
                        }
                    }
                }
            }
            this.results.append("Controlled under Starter:\n");
            this.results.append("    - Hosts:\t\t\t\t").append(hostList.size()).append("\n");
            this.results.append("    - Server types:\t\t").append(this.binaryList.size()).append("\n");
            this.results.append("    - Server/Instances:\t").append(nbServers).append("\n");
            this.results.append("    - Classes:\t\t\t").append(this.classList.size()).append("\n");
            this.results.append("    - Devices:\t\t\t").append(nbDevices).append("\n");
            this.results.append("    - Control Points:\t\t").append(nbControlPoints).append("\n");
            this.results.append("\t\t- attributes:\t").append(nbAttributes).append("\n");
            this.results.append("\t\t- commands:\t").append(nbCommands).append("\n");
            if (this.stoppedList.size() > 0) {
                this.results.append("\n").append(" Server(s) cannot be checked : ").append(this.stoppedList.size()).append("\n");
            }
            this.results.append("Measurements done ").append(new Date()).append("\n");
            this.saveResults(fileName);
            this.printComplementaryResults();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
        }
    }

    private void saveResults(String filename) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        ScanningControlSystem.writeFile(tmpDir + "/" + filename, this.results.toString());
    }

    public static void writeFile(String filename, String code) {
        try {
            FileOutputStream fidout = new FileOutputStream(filename);
            fidout.write(code.getBytes());
            fidout.close();
            System.out.println("Results saved in " + filename);
        }
        catch (Exception e) {
            System.err.println("Cannot write " + filename + "\n" + e);
        }
    }

    private void printComplementaryResults() {
        System.out.println(this.stoppedList.size() + " stopped server(s)");
        for (String stopped : this.stoppedList) {
            System.out.println(stopped);
        }
    }

    private class TangoHost
    extends ArrayList<TangoServer> {
        String name;

        private TangoHost(String name) throws DevFailed {
            String[] serverNames;
            this.name = name;
            DeviceData argIn = new DeviceData();
            argIn.insert(name);
            DeviceData argOut = ApiUtil.get_db_obj().command_inout("DbGetHostServerList", argIn);
            for (String serverName : serverNames = argOut.extractStringArray()) {
                if (!this.serverControlled(serverName)) continue;
                System.out.println("Checking on " + name + ": " + serverName);
                this.add(new TangoServer(serverName));
            }
        }

        private boolean serverControlled(String serverName) throws DevFailed {
            if (serverName.startsWith("Starter/") || serverName.startsWith("DataBase")) {
                return true;
            }
            DbServInfo info = ApiUtil.get_db_obj().get_server_info(serverName);
            return info.controlled;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            for (TangoServer server : this) {
                sb.append(server).append("\n");
            }
            return sb.toString();
        }
    }

    private class TangoServer
    extends ArrayList<TangoDevice> {
        String name;
        String binary;
        boolean running;

        private TangoServer(String name) throws DevFailed {
            this.name = name;
            this.binary = name.substring(0, name.indexOf(47));
            if (!ScanningControlSystem.this.binaryList.contains(this.binary)) {
                ScanningControlSystem.this.binaryList.add(this.binary);
            }
            this.running = this.isRunning();
            DbServer server = new DbServer(name);
            String[] argOut = server.get_device_class_list();
            for (int i = 0; i < argOut.length; i += 2) {
                String className = argOut[i + 1];
                if (!ScanningControlSystem.this.classList.contains(className)) {
                    ScanningControlSystem.this.classList.add(className);
                }
                String deviceName = argOut[i];
                this.add(new TangoDevice(deviceName, this.running));
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private boolean isRunning() {
            try {
                new DeviceProxy("dserver/" + this.name).ping();
                return true;
            }
            catch (DevFailed e) {
                ScanningControlSystem.this.stoppedList.add(this.name + ":\t" + e.errors[0].desc);
                return false;
            }
        }

        @Override
        public String toString() {
            String tab = "    ";
            StringBuilder sb = new StringBuilder(this.name + ":\n");
            for (TangoDevice device : this) {
                sb.append(device).append("\n");
            }
            return tab + sb.toString().trim();
        }
    }

    private class TangoDevice
    extends ArrayList<TangoAttribute> {
        private String name;
        private List<TangoCommand> commands = new ArrayList<TangoCommand>();

        private TangoDevice(String name, boolean running) {
            this.name = name;
            if (name.startsWith("dserver/")) {
                this.manageDserverDevice(running);
            } else if (running) {
                try {
                    CommandInfo[] commandInfoList;
                    AttributeInfo[] attributeInfoList;
                    DeviceProxy proxy = new DeviceProxy(name);
                    for (AttributeInfo attributeInfo : attributeInfoList = proxy.get_attribute_info()) {
                        this.add(new TangoAttribute(attributeInfo));
                    }
                    for (CommandInfo commandInfo : commandInfoList = proxy.command_list_query()) {
                        this.commands.add(new TangoCommand(commandInfo));
                    }
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
        }

        private void manageDserverDevice(boolean running) {
            if (running && ScanningControlSystem.this.dServerCommands.isEmpty()) {
                try {
                    CommandInfo[] commandInfoList;
                    DeviceProxy proxy = new DeviceProxy(this.name);
                    for (CommandInfo commandInfo : commandInfoList = proxy.command_list_query()) {
                        ScanningControlSystem.this.dServerCommands.add(new TangoCommand(commandInfo));
                    }
                }
                catch (DevFailed proxy) {
                    // empty catch block
                }
            }
            for (TangoCommand tangoCommand : ScanningControlSystem.this.dServerCommands) {
                this.commands.add(tangoCommand);
            }
        }

        private int getControlPointCount() {
            int nb = 0;
            for (TangoAttribute attribute : this) {
                nb += attribute.controlPoint;
            }
            for (TangoCommand command : this.commands) {
                nb += command.controlPoint;
            }
            return nb;
        }

        @Override
        public String toString() {
            String tab = "        ";
            String sb = this.name + ":\n" + tab + this.size() + " attributes\n" + tab + this.commands.size() + " commands\n" + tab + tab + this.getControlPointCount() + " control point\n";
            return tab + sb.trim();
        }
    }

    private class TangoAttribute {
        String name;
        int controlPoint;

        private TangoAttribute(AttributeInfo attributeInfo) {
            this.name = attributeInfo.name;
            this.controlPoint = attributeInfo.writable == AttrWriteType.READ ? 1 : 2;
        }
    }

    private class TangoCommand {
        String name;
        int controlPoint;

        private TangoCommand(CommandInfo commandInfo) {
            this.name = commandInfo.cmd_name;
            this.controlPoint = commandInfo.in_type != 0 && commandInfo.out_type != 0 ? 2 : 1;
        }
    }
}

