/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.UsersTree;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class UsersTreePopupMenu
extends JPopupMenu {
    private UsersTree parent;
    private static final int ADD_USER = 0;
    private static final int COPY = 1;
    private static final int PASTE = 2;
    private static final int ADD_ITEM = 3;
    private static final int EDIT = 4;
    private static final int CLONE = 5;
    private static final int REMOVE = 6;
    private static final int CHANGE_GROUP = 7;
    private static final int TOGGLE_RIGHTS = 8;
    private static String[] menuLabels = new String[]{"Add User", "Copy", "Paste", "Add Item", "Edit", "Clone", "Remove", "Change Group", "Toggle rights"};
    private static final int OFFSET = 2;
    private JLabel title;

    public UsersTreePopupMenu(UsersTree parent) {
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.title = new JLabel();
        this.title.setFont(new Font("Dialog", 1, 16));
        this.add(this.title);
        this.add(new JPopupMenu.Separator());
        for (String menuLabel : menuLabels) {
            if (menuLabel == null) {
                this.add(new JPopupMenu.Separator());
                continue;
            }
            JMenuItem btn = new JMenuItem(menuLabel);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UsersTreePopupMenu.this.userActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt, String name) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.parent.setSelectionPath(selectedPath);
        this.title.setText(name);
        for (int i = 0; i < menuLabels.length; ++i) {
            this.getComponent(2 + i).setVisible(false);
        }
        this.getComponent(2).setVisible(true);
        this.show(this.parent, evt.getX(), evt.getY());
    }

    public void showMenu(MouseEvent evt, int type, Object obj) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.parent.setSelectionPath(selectedPath);
        this.title.setText(obj.toString());
        for (int i = 0; i < menuLabels.length; ++i) {
            this.getComponent(2 + i).setVisible(false);
        }
        switch (type) {
            case -2: {
                this.getComponent(7).setVisible(true);
                if (!obj.toString().equals("All Users")) {
                    this.getComponent(8).setVisible(true);
                }
                this.getComponent(9).setVisible(true);
                break;
            }
            case -1: {
                this.getComponent(5).setVisible(true);
                this.getComponent(4).setVisible(true);
                this.getComponent(4).setEnabled(false);
                if (obj.toString().equals(UsersTree.collecStr[0]) && this.parent.copied_addresses.size() > 0) {
                    this.getComponent(4).setEnabled(true);
                }
                if (!obj.toString().equals(UsersTree.collecStr[1]) || this.parent.copied_devices.size() <= 0) break;
                this.getComponent(4).setEnabled(true);
                break;
            }
            case 0: {
                this.getComponent(3).setVisible(true);
                this.getComponent(6).setVisible(true);
                this.getComponent(8).setVisible(true);
                break;
            }
            case 1: {
                this.getComponent(3).setVisible(true);
                this.getComponent(6).setVisible(true);
                this.getComponent(8).setVisible(true);
                this.getComponent(10).setVisible(true);
            }
        }
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void userActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = 0;
        for (int i = 0; i < menuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 0: {
                this.parent.addUser();
                break;
            }
            case 1: {
                this.parent.copyItem();
                break;
            }
            case 2: {
                this.parent.pasteItem();
                break;
            }
            case 3: {
                this.parent.addItem();
                break;
            }
            case 4: {
                this.parent.editItem();
                break;
            }
            case 5: {
                this.parent.cloneUser();
                break;
            }
            case 6: {
                this.parent.removeItem();
                break;
            }
            case 7: {
                this.parent.changeGroup();
                break;
            }
            case 8: {
                this.parent.toggleRight();
            }
        }
    }
}

