/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.TangoAccess;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordDialog
extends JDialog {
    private byte[] bytePassword;
    private int retVal = 0;
    private int mode = 0;
    private static final int GET_PASSWORD = 0;
    private static final int CHANGE_PASSWORD = 1;
    private static final String defaultPassword = "SUPER_TANGO";
    private JPasswordField passwordField;
    private JLabel titleLabel;
    private static String privateKey = "TangoControl";

    public PasswordDialog(JFrame parent, String title) {
        this(parent, null, title);
        this.mode = 1;
    }

    public PasswordDialog(JFrame parent, byte[] bytePassword) {
        this(parent, bytePassword, null);
    }

    public PasswordDialog(JFrame parent, byte[] bytePassword, String title) {
        super((Frame)parent, true);
        this.bytePassword = bytePassword;
        this.initComponents();
        if (title != null) {
            this.titleLabel.setText(title);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        this.passwordField = new JPasswordField();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PasswordDialog.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Password ?");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.passwordField.setColumns(20);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PasswordDialog.this.passwordFieldKeyPressed(evt);
            }
        });
        centerPanel.add(this.passwordField);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.checkPassword();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private void passwordFieldKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 27) {
            this.doClose(2);
        } else if (code == 10) {
            this.checkPassword();
        }
    }

    private void checkPassword() {
        if (this.mode == 1) {
            this.doClose(0);
            return;
        }
        String str = new String(this.passwordField.getPassword());
        byte[] text = str.getBytes();
        byte[] superTango = defaultPassword.getBytes();
        if (this.comparePassword(text, this.bytePassword)) {
            this.doClose(0);
        } else if (this.comparePassword(text, superTango)) {
            this.doClose(0);
        } else {
            TangoAccess.popupError(this, "Invalid Password !");
            this.passwordField.setText("");
        }
    }

    private boolean comparePassword(byte[] text, byte[] password) {
        if (text.length != password.length) {
            return false;
        }
        for (int i = 0; i < text.length && i < password.length; ++i) {
            if (text[i] == password[i]) continue;
            return false;
        }
        return true;
    }

    private void doClose(int ret) {
        this.retVal = ret;
        this.setVisible(false);
        this.dispose();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void main(String[] args) {
        PasswordDialog dlg = new PasswordDialog(new JFrame(), "dserver".getBytes());
        dlg.setVisible(true);
    }

    private static String bytes2str(byte[] bytes) {
        String str = "";
        for (byte b : bytes) {
            str = str + " " + b;
        }
        return str.trim();
    }

    private static byte[] str2bytes(String str) {
        StringTokenizer stk = new StringTokenizer(str);
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        while (stk.hasMoreTokens()) {
            try {
                tokens.add(Integer.parseInt(stk.nextToken()));
            }
            catch (NumberFormatException e) {
                tokens.add(0);
            }
        }
        byte[] b = new byte[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            b[i] = ((Integer)tokens.get(i)).byteValue();
        }
        return b;
    }

    public static String cryptPassword(String inStr) {
        byte[] mask = privateKey.getBytes();
        byte[] in = inStr.getBytes();
        int len = in.length < mask.length ? in.length : mask.length;
        byte[] out = new byte[len];
        for (int i = 0; i < in.length && i < privateKey.length(); ++i) {
            out[i] = (byte)(in[i] ^ mask[i]);
        }
        return PasswordDialog.bytes2str(out);
    }

    public static String decryptPassword(String inStr) {
        byte[] mask = privateKey.getBytes();
        byte[] in = PasswordDialog.str2bytes(inStr);
        int len = in.length < mask.length ? in.length : mask.length;
        byte[] out = new byte[len];
        for (int i = 0; i < in.length && i < privateKey.length(); ++i) {
            out[i] = (byte)(in[i] ^ mask[i]);
        }
        return new String(out);
    }
}

