/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.EditPropertyDialog;
import admin.astor.tango_release.TangoServerRelease;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.MultiLineToolTipUI;

public class ServArchitectureDialog
extends JDialog {
    private String serverName;
    private boolean fromApplication = true;
    private boolean modified = false;
    private TgServer server;
    private ServerInfoTree tree;
    public static final boolean EXPAND_NOT_FULL = false;
    public static final boolean EXPAND_FULL = true;
    private static String separator = ", ";
    private JRadioButton expandBtn;
    private JRadioButton infoBtn;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JLabel titleLabel;
    private JScrollPane treeScrollPane;
    private JRadioButton zmqButton;

    public ServArchitectureDialog(JFrame parent, String serverName) throws DevFailed {
        super((Frame)parent, false);
        this.serverName = serverName;
        this.initComponents();
        this.initOwnComponent(parent);
    }

    public ServArchitectureDialog(JDialog parent, DeviceProxy dev) throws DevFailed {
        super((Dialog)parent, false);
        this.serverName = dev.get_name().substring("dserver/".length());
        this.initComponents();
        this.initOwnComponent(parent);
    }

    private void initOwnComponent(Component parent) throws DevFailed {
        this.tree = new ServerInfoTree(this);
        this.treeScrollPane.setViewportView(this.tree);
        this.treeScrollPane.setPreferredSize(new Dimension(350, 450));
        this.textScrollPane.setPreferredSize(new Dimension(350, 180));
        this.titleLabel.setText(this.serverName + "  Information");
        if (parent == null) {
            this.fromApplication = false;
        }
        MultiLineToolTipUI.initialize();
        this.pack();
        this.tree.expandTree(false);
    }

    private void initComponents() {
        JPanel titlePanel = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.zmqButton = new JRadioButton();
        JPanel scrollPanel = new JPanel();
        this.treeScrollPane = new JScrollPane();
        JPanel bottomPanel = new JPanel();
        this.expandBtn = new JRadioButton();
        this.infoBtn = new JRadioButton();
        JButton cancelBtn = new JButton();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServArchitectureDialog.this.closeDialog(evt);
            }
        });
        titlePanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel1.add(this.titleLabel);
        titlePanel.add((Component)jPanel1, "Center");
        this.zmqButton.setText("ZMQ event system compatible");
        this.zmqButton.setEnabled(false);
        titlePanel.add((Component)this.zmqButton, "South");
        this.getContentPane().add((Component)titlePanel, "North");
        scrollPanel.setLayout(new BorderLayout());
        scrollPanel.add((Component)this.treeScrollPane, "Center");
        this.getContentPane().add((Component)scrollPanel, "Center");
        this.expandBtn.setText("Expand tree");
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.expandBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.expandBtn);
        this.infoBtn.setSelected(true);
        this.infoBtn.setText("Info");
        this.infoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.infoBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.infoBtn);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServArchitectureDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.textScrollPane.setPreferredSize(new Dimension(200, 170));
        this.textArea.setEditable(false);
        this.textScrollPane.setViewportView(this.textArea);
        this.getContentPane().add((Component)this.textScrollPane, "East");
        this.pack();
    }

    private void infoBtnActionPerformed(ActionEvent evt) {
        boolean b = this.infoBtn.getSelectedObjects() != null;
        this.textScrollPane.setVisible(b);
        this.pack();
    }

    private void expandBtnActionPerformed(ActionEvent evt) {
        if (this.expandBtn.getSelectedObjects() != null) {
            this.tree.expandTree(true);
        } else {
            this.tree.expandTree(false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.modified && JOptionPane.showConfirmDialog(this, "Some properties have been modified !\n\nDo you want a restart devices ?", "Dialog", 0) == 0) {
            try {
                new DeviceProxy("dserver/" + this.serverName).command_inout("init");
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
        this.setVisible(false);
        this.dispose();
        if (!this.fromApplication) {
            System.exit(0);
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public static String multiLine2OneLine(String str) {
        int idx;
        if (str == null) {
            return null;
        }
        while ((idx = str.indexOf(10)) >= 0) {
            str = str.substring(0, idx) + separator + str.substring(idx + 1);
        }
        return str;
    }

    public static String OneLine2multiLine(String str) {
        int idx;
        if (str == null) {
            return null;
        }
        while ((idx = str.indexOf(separator)) >= 0) {
            str = str.substring(0, idx) + "\n" + str.substring(idx + separator.length());
        }
        return str;
    }

    public static String[] string2array(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(str, separator);
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static void main(String[] args) {
        String serverName = "VacGaugeServer/sr_c27-ip";
        if (args.length > 0) {
            serverName = args[0];
        }
        try {
            new ServArchitectureDialog(null, serverName).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JDialog(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon root_icon = Utils.getInstance().getIcon("TransparentTango.gif", 0.15);
        private ImageIcon class_icon = Utils.getInstance().getIcon("class.gif");
        private ImageIcon prop_icon = Utils.getInstance().getIcon("attleaf.gif");
        private ImageIcon leaf_icon = Utils.getInstance().getIcon("uleaf.gif");
        private Font[] fonts = new Font[5];
        private final int TITLE = 0;
        private final int CLASS = 1;
        private final int DEVICE = 2;
        private final int PROP_NAME = 3;
        private final int PROP_DESC = 4;

        private TangoRenderer() {
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 1, 16);
            this.fonts[2] = new Font("helvetica", 1, 12);
            this.fonts[3] = new Font("helvetica", 0, 12);
            this.fonts[4] = new Font("helvetica", 0, 10);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            String tip = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object user_obj = node.getUserObject();
            if (row == 0) {
                this.setIcon(this.root_icon);
                this.setFont(this.fonts[0]);
                tip = ((TgServer)user_obj).desc;
                tip = tip + "\n\n" + ((TgServer)user_obj).nbDevices + "  devices";
            } else if (user_obj instanceof TgClass) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[1]);
                tip = ((TgClass)((Object)user_obj)).desc;
                tip = tip + "\n" + ((TgClass)((Object)user_obj)).nbDevices + "  devices";
            } else if (user_obj instanceof TgDevice) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[2]);
            } else if (user_obj instanceof TgProperty) {
                this.setIcon(this.prop_icon);
                this.setFont(this.fonts[3]);
                tip = ((TgProperty)user_obj).desc;
            } else if (user_obj instanceof String) {
                this.setIcon(this.leaf_icon);
                this.setFont(this.fonts[4]);
            }
            this.setToolTipText(tip);
            return this;
        }
    }

    class TgProperty {
        String objectName;
        String src;
        String name;
        String desc;
        String def_value;
        String db_value = null;

        private TgProperty(String objectName, String src, String name, String desc, String def_value) {
            this.objectName = objectName;
            this.src = src;
            this.name = name;
            this.desc = desc;
            this.def_value = "";
            this.def_value = ServArchitectureDialog.multiLine2OneLine(def_value);
        }

        private void setDbValue(String[] values) {
            this.db_value = "";
            for (int i = 0; i < values.length; ++i) {
                this.db_value = this.db_value + values[i];
                if (i >= values.length - 1) continue;
                this.db_value = this.db_value + ", ";
            }
        }

        private String getValue() {
            if (this.db_value == null) {
                return this.def_value;
            }
            return this.db_value;
        }

        public String toString() {
            return this.name;
        }
    }

    private class TgClass
    extends DbClass {
        String name;
        String desc;
        String tagName;
        TgProperty[] properties;
        int nbDevices;

        private TgClass(String name, TgProperty[] properties) throws DevFailed {
            super(name);
            this.tagName = null;
            this.nbDevices = 0;
            this.name = name;
            this.desc = "No Description Found in Database";
            try {
                DbDatum data = this.get_property("Description");
                if (!data.is_empty()) {
                    String[] array = data.extractStringArray();
                    this.desc = "";
                    for (String line : array) {
                        this.desc = this.desc + line + "\n";
                    }
                }
                this.properties = new TgProperty[properties.length];
                for (int i = 0; i < properties.length; ++i) {
                    this.properties[i] = new TgProperty(name, properties[i].src, properties[i].name, properties[i].desc, properties[i].def_value);
                    DbDatum d = this.get_property(properties[i].name);
                    if (d.is_empty()) continue;
                    this.properties[i].setDbValue(d.extractStringArray());
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        private void put_property(TgProperty prop) throws DevFailed {
            if (prop.db_value == null) {
                this.delete_property(prop.name);
            } else {
                String[] value = ServArchitectureDialog.string2array(prop.db_value);
                DbDatum[] data = new DbDatum[]{new DbDatum(prop.name)};
                data[0].insert(value);
                this.put_property(data);
            }
        }

        public String toString() {
            String label = "Class: ";
            label = this.tagName != null ? (this.tagName.startsWith(this.name) ? label + this.tagName : label + this.name) : label + this.name;
            return label;
        }
    }

    private class TgDevice
    extends DeviceProxy {
        String name;
        TgProperty[] properties;

        private TgDevice(String name, TgProperty[] properties) throws DevFailed {
            super(name);
            this.name = name;
            this.properties = new TgProperty[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                this.properties[i] = new TgProperty(name, properties[i].src, properties[i].name, properties[i].desc, properties[i].def_value);
                try {
                    DbDatum data = this.get_property(properties[i].name);
                    if (data.is_empty()) continue;
                    this.properties[i].setDbValue(data.extractStringArray());
                    continue;
                }
                catch (DevFailed e) {
                    Except.print_exception((Exception)((Object)e));
                }
            }
        }

        private void put_property(TgProperty prop) throws DevFailed {
            if (prop.db_value == null) {
                this.delete_property(prop.name);
            } else {
                String[] value = ServArchitectureDialog.string2array(prop.db_value);
                DbDatum[] data = new DbDatum[]{new DbDatum(prop.name)};
                data[0].insert(value);
                this.put_property(data);
            }
        }

        public String toString() {
            return "Device: " + this.name;
        }
    }

    private class TgServer {
        String name;
        String desc;
        int nbDevices = 0;

        private TgServer(String name) {
            this.name = name;
            this.desc = "";
            try {
                String admin = "dserver/" + name;
                DeviceInfo info = new DbDevice(admin).get_info();
                this.desc = info.toString();
                ServArchitectureDialog.this.textArea.setText(this.desc + "\n\n" + new TangoServerRelease(name).toStringFull());
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private class ServerInfoTree
    extends JTree {
        private Component parent;
        private DeviceProxy deviceProxy = null;
        private String[] deviceList = null;
        private DefaultTreeModel treeModel;
        private DefaultMutableTreeNode root;

        private ServerInfoTree(Component parent) throws DevFailed {
            this.parent = parent;
            this.initComponent();
        }

        private void expandTree(boolean expand) {
            this.expandTree(this.root, expand);
        }

        private void expandTree(DefaultMutableTreeNode node, boolean expand) {
            int nb = node.getChildCount();
            for (int i = 0; i < nb; ++i) {
                TreePath path;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Object obj = child.getUserObject();
                if (expand || obj instanceof TgProperty) {
                    path = new TreePath(child.getPath());
                    this.expandPath(path);
                    this.expandTree(child, expand);
                }
                if (expand || obj instanceof TgProperty) continue;
                path = new TreePath(child.getPath());
                this.collapsePath(path);
            }
        }

        private void initComponent() throws DevFailed {
            ServArchitectureDialog.this.server = new TgServer(ServArchitectureDialog.this.serverName);
            this.root = new DefaultMutableTreeNode(ServArchitectureDialog.this.server);
            this.createNodes(this.root);
            this.getSelectionModel().setSelectionMode(1);
            this.treeModel = new DefaultTreeModel(this.root);
            this.setModel(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setCellRenderer(new TangoRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ServerInfoTree.this.treeMouseClicked(evt);
                }
            });
            ServArchitectureDialog.this.zmqButton.setSelected(this.isZmqCompatible());
        }

        private void createNodes(DefaultMutableTreeNode root) throws DevFailed {
            if (this.deviceProxy == null) {
                this.deviceProxy = new DeviceProxy("dserver/" + ServArchitectureDialog.this.serverName);
            }
            TgClass[] classes = this.getClasses();
            ((ServArchitectureDialog)ServArchitectureDialog.this).server.nbDevices = 0;
            for (TgClass _class : classes) {
                DefaultMutableTreeNode classNode = new DefaultMutableTreeNode((Object)_class);
                root.add(classNode);
                for (int p = 0; p < _class.properties.length; ++p) {
                    TgProperty prop = _class.properties[p];
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(prop);
                    classNode.add(node);
                    node.add(new DefaultMutableTreeNode(prop.getValue()));
                }
                TgDevice[] devices = this.getDevices(_class.name);
                _class.nbDevices = devices.length;
                ((ServArchitectureDialog)ServArchitectureDialog.this).server.nbDevices += _class.nbDevices;
                for (TgDevice device : devices) {
                    DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode((Object)device);
                    classNode.add(deviceNode);
                    for (TgProperty property : device.properties) {
                        DefaultMutableTreeNode node = new DefaultMutableTreeNode(property);
                        deviceNode.add(node);
                        node.add(new DefaultMutableTreeNode(property.getValue()));
                    }
                }
            }
        }

        private TgDevice[] getDevices(String classname) throws DevFailed {
            if (this.deviceList == null) {
                DeviceData argOut = this.deviceProxy.command_inout("QueryDevice");
                this.deviceList = argOut.extractStringArray();
            }
            ArrayList<String> deviceNames = new ArrayList<String>();
            String str = classname + "::";
            for (String item : this.deviceList) {
                if (!item.startsWith(str)) continue;
                deviceNames.add(item.substring(str.length()));
            }
            TgProperty[] dev_prop = this.getProperties(classname, "Dev");
            TgDevice[] devices = new TgDevice[deviceNames.size()];
            int i = 0;
            for (String deviceName : deviceNames) {
                devices[i++] = new TgDevice(deviceName, dev_prop);
            }
            return devices;
        }

        private TgClass[] getClasses() throws DevFailed {
            DeviceData argout = this.deviceProxy.command_inout("QueryClass");
            String[] classnames = argout.extractStringArray();
            TgClass[] classes = new TgClass[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                TgProperty[] prop = this.getProperties(classnames[i], "Class");
                classes[i] = new TgClass(classnames[i], prop);
            }
            return classes;
        }

        private TgProperty[] getProperties(String classname, String source) throws DevFailed {
            DeviceData argin = new DeviceData();
            argin.insert(classname);
            String cmd = "QueryWizard" + source + "Property";
            DeviceData argout = this.deviceProxy.command_inout(cmd, argin);
            String[] str = argout.extractStringArray();
            TgProperty[] prop = new TgProperty[str.length / 3];
            int n = 0;
            for (int i = 0; i < str.length; i += 3) {
                prop[n] = new TgProperty(classname, source, str[i], str[i + 1], str[i + 2]);
                ++n;
            }
            return prop;
        }

        private boolean isZmqCompatible() {
            try {
                this.deviceProxy.command_query("ZmqEventSubscriptionChange");
                return true;
            }
            catch (DevFailed e) {
                return false;
            }
        }

        private void treeMouseClicked(MouseEvent evt) {
            if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
                return;
            }
            int mask = evt.getModifiers();
            if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                Object o = node.getUserObject();
                if (node.isLeaf() && o instanceof String) {
                    this.editProperty(node);
                }
            }
        }

        private void editProperty(DefaultMutableTreeNode node) {
            DefaultMutableTreeNode prop_node = (DefaultMutableTreeNode)node.getParent();
            TgProperty property = (TgProperty)prop_node.getUserObject();
            EditPropertyDialog dialog = this.parent instanceof JDialog ? new EditPropertyDialog((JDialog)this.parent, property) : new EditPropertyDialog((JFrame)this.parent, property);
            property = dialog.showDialog();
            if (property != null) {
                DefaultMutableTreeNode tg_node = (DefaultMutableTreeNode)prop_node.getParent();
                Object o = tg_node.getUserObject();
                try {
                    if (o instanceof TgClass) {
                        TgClass _class = (TgClass)((Object)o);
                        _class.put_property(property);
                        this.replaceNode(node, property.getValue());
                        ServArchitectureDialog.this.modified = true;
                    } else if (o instanceof TgDevice) {
                        TgDevice dev = (TgDevice)((Object)o);
                        dev.put_property(property);
                        this.replaceNode(node, property.getValue());
                        ServArchitectureDialog.this.modified = true;
                    } else {
                        System.out.println("object " + o + "  not implemented !");
                    }
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                }
            }
        }

        private void replaceNode(DefaultMutableTreeNode node, String str) {
            DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
            int pos = 0;
            for (int i = 0; i < parent_node.getChildCount(); ++i) {
                if (!parent_node.getChildAt(i).equals(node)) continue;
                pos = i;
            }
            DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(str);
            this.treeModel.insertNodeInto(new_node, parent_node, pos);
            this.treeModel.removeNodeFromParent(node);
        }
    }
}

