/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import JSSHTerminal.MainPanel;
import admin.astor.AstorDefs;
import admin.astor.tools.PingHosts;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Frame;

public class RemoteLoginThread
extends Thread
implements AstorDefs {
    private String hostname;

    public RemoteLoginThread(String hostname) throws DevFailed {
        this.hostname = hostname;
        PingHosts pingHosts = new PingHosts(hostname);
        if (pingHosts.getAliveList().isEmpty()) {
            Except.throw_exception((String)"NoResponse", (String)("No response from " + hostname + "\nIt seems down"));
        }
    }

    @Override
    public void run() {
        String defaultUser = "dserver";
        String defaultPassword = "dev-server";
        try {
            DbDatum[] data = ApiUtil.get_db_obj().get_property("Astor", new String[]{"RloginUser", "RloginPassword"});
            if (!data[0].is_empty()) {
                defaultUser = data[0].extractString();
            }
            if (!data[1].is_empty()) {
                defaultPassword = data[1].extractString();
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        MainPanel terminal = new MainPanel(this.hostname, defaultUser, defaultPassword, 80, 24, 1024);
        terminal.setX11Forwarding(true);
        terminal.setExitOnClose(false);
        ATKGraphicsUtils.centerFrameOnScreen((Frame)terminal);
        terminal.setVisible(true);
    }
}

