/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import fr.esrf.TangoApi.DbServInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PutServerInfoDialog
extends JDialog {
    public static final int RET_CANCEL = 2;
    public static final int RET_OK = 0;
    private DbServInfo server_info;
    private JButton unregisterBtn;
    private boolean unregister = false;
    private Component parent;
    private boolean manage_unregister = true;
    private JRadioButton yesButton;
    private JRadioButton noButton;
    private JComboBox<String> jComboBox1;
    private JLabel title;
    private int returnStatus = 2;

    public PutServerInfoDialog(JDialog parent, boolean modal) {
        this(parent, modal, true);
    }

    public PutServerInfoDialog(JDialog parent, boolean modal, boolean manageUnregister) {
        super((Dialog)parent, modal);
        this.parent = parent;
        this.initComponents();
        this.jComboBox1.addItem("None");
        int nb = AstorUtil.getStarterNbStartupLevels();
        for (int i = 1; i <= nb; ++i) {
            String s = "Level " + i;
            this.jComboBox1.addItem(s);
        }
        this.manage_unregister = manageUnregister;
        this.pack();
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.yesButton = new JRadioButton();
        this.noButton = new JRadioButton();
        JLabel jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.title = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PutServerInfoDialog.this.closeDialog(evt);
            }
        });
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        okButton.setText("  OK  ");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PutServerInfoDialog.this.okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(okButton);
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PutServerInfoDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        jPanel1.setLayout(new GridBagLayout());
        jLabel1.setText("Controlled by Astor : ");
        jLabel1.setForeground(Color.black);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        jPanel1.add((Component)jLabel1, gridBagConstraints1);
        this.yesButton.setText("Yes");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PutServerInfoDialog.this.yesnoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        jPanel1.add((Component)this.yesButton, gridBagConstraints1);
        this.noButton.setText("No");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PutServerInfoDialog.this.yesnoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        jPanel1.add((Component)this.noButton, gridBagConstraints1);
        jLabel2.setText("Startup Level : ");
        jLabel2.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        jPanel1.add((Component)jLabel2, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridheight = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 2.0;
        jPanel1.add(this.jComboBox1, gridBagConstraints1);
        jLabel3.setText(" ");
        jLabel3.setForeground(Color.black);
        jLabel3.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        jPanel1.add((Component)jLabel3, gridBagConstraints1);
        jLabel5.setPreferredSize(new Dimension(50, 40));
        jLabel5.setMinimumSize(new Dimension(50, 40));
        jLabel5.setText(" ");
        jLabel5.setForeground(Color.black);
        jLabel5.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridheight = 10;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 11;
        gridBagConstraints1.weighty = 10.0;
        jPanel1.add((Component)jLabel5, gridBagConstraints1);
        jLabel6.setText(" ");
        jLabel6.setForeground(Color.black);
        jLabel6.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 11;
        jPanel1.add((Component)jLabel6, gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 7;
        jPanel1.add((Component)new JLabel("  "), gridBagConstraints1);
        this.unregisterBtn = new JButton("Remove startup level info");
        this.unregisterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PutServerInfoDialog.this.unregisterBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.gridwidth = 3;
        jPanel1.add((Component)this.unregisterBtn, gridBagConstraints1);
        this.getContentPane().add((Component)jPanel1, "Center");
        this.title.setText(" ");
        this.title.setForeground(Color.black);
        this.title.setFont(new Font("Dialog", 1, 16));
        this.getContentPane().add((Component)this.title, "North");
    }

    private void unregisterBtnActionPerformed(ActionEvent evt) {
        this.unregister = JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to remove " + this.server_info.name + " startup info ?", "Confirm Dialog", 0) == 0;
        if (this.unregister) {
            this.doClose(0);
        }
    }

    private void yesnoButtonActionPerformed(ActionEvent evt) {
        String org = evt.getActionCommand();
        if (org.equals("Yes")) {
            this.updateButtons(true, this.server_info.startup_level);
        } else {
            this.updateButtons(false, 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean ctrl = this.yesButton.getSelectedObjects() != null;
        int level = this.jComboBox1.getSelectedIndex();
        if (!ctrl || level == 0) {
            level = 0;
        }
        if (ctrl != this.server_info.controlled || level != this.server_info.startup_level) {
            this.doClose(0);
        } else {
            this.doClose(2);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void updateButtons(boolean ctrl, int level) {
        this.yesButton.setSelected(ctrl);
        this.noButton.setSelected(!ctrl);
        this.jComboBox1.setEnabled(ctrl);
        if (ctrl) {
            this.server_info.startup_level = level;
            this.jComboBox1.setSelectedIndex(level);
            this.unregisterBtn.setVisible(false);
        } else {
            this.jComboBox1.setSelectedIndex(0);
            if (this.server_info.name.length() > 0 && this.manage_unregister) {
                this.unregisterBtn.setVisible(true);
            } else {
                this.unregisterBtn.setVisible(false);
            }
        }
    }

    public int showDialog(DbServInfo info) {
        this.server_info = info;
        this.title.setText("  " + info.name + " running on " + info.host + "  ");
        this.updateButtons(info.controlled, info.startup_level);
        this.pack();
        this.setVisible(true);
        return this.returnStatus;
    }

    public int showDialog(DbServInfo info, int level) {
        this.server_info = info;
        this.manage_unregister = false;
        this.title.setText("  Servers (Level " + level + ")   running on " + info.host + "  ");
        this.updateButtons(info.controlled, info.startup_level);
        this.pack();
        this.setVisible(true);
        return this.returnStatus;
    }

    public DbServInfo getSelection() {
        if (this.unregister) {
            return null;
        }
        boolean ctrl = this.yesButton.getSelectedObjects() != null;
        int level = this.jComboBox1.getSelectedIndex();
        if (!ctrl || level == 0) {
            level = 0;
        }
        return new DbServInfo(this.server_info.name, this.server_info.host, ctrl, level);
    }
}

