/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PropListDialog
extends JDialog {
    private JFrame parent;
    private String selectedItem = null;
    private JTextArea pathText = null;
    private String[] props;
    private JList<String> jList;

    private void setList() {
        this.jList.setListData((String[])this.props);
    }

    public PropListDialog(JFrame parent, String[] props) {
        super((Frame)parent, true);
        this.parent = parent;
        this.props = props;
        this.initComponents();
        this.buildList();
    }

    public PropListDialog(JFrame parent, List<String> propertyList) {
        super((Frame)parent, true);
        this.parent = parent;
        this.props = new String[propertyList.size()];
        for (int i = 0; i < propertyList.size(); ++i) {
            this.props[i] = propertyList.get(i);
        }
        this.initComponents();
        this.buildList();
    }

    public PropListDialog(JFrame parent, JTextArea pathText, TangoHost[] hosts) {
        super((Frame)parent, true);
        this.parent = parent;
        this.pathText = pathText;
        this.initComponents();
        this.hosts2path(hosts);
        this.buildList();
    }

    private boolean alreadyIn(List<String> stringList, String s) {
        for (String str : stringList) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    private void hosts2path(TangoHost[] hosts) {
        try {
            ArrayList<String> pathList = new ArrayList<String>();
            for (TangoHost host : hosts) {
                String[] path;
                String deviceName = AstorUtil.getStarterDeviceHeader() + host.getName();
                DeviceProxy dev = new DeviceProxy(deviceName);
                DbDatum data = dev.get_property("StartDsPath");
                if (data.is_empty()) continue;
                for (String aPath : path = data.extractStringArray()) {
                    if (this.alreadyIn(pathList, aPath)) continue;
                    pathList.add(aPath);
                }
            }
            this.props = new String[pathList.size()];
            for (int i = 0; i < pathList.size(); ++i) {
                this.props[i] = (String)pathList.get(i);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    private void buildList() {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PropListDialog.this.listSelectionPerformed(e);
            }
        };
        this.jList.addMouseListener(mouseListener);
        this.pack();
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton addBtn = new JButton();
        JButton dismissBtn = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PropListDialog.this.closeDialog(evt);
            }
        });
        addBtn.setText("Add");
        addBtn.setHorizontalAlignment(4);
        addBtn.setFont(new Font("Dialog", 0, 12));
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropListDialog.this.addBtnActionPerformed(evt);
            }
        });
        jPanel1.add(addBtn);
        dismissBtn.setHorizontalTextPosition(4);
        if (this.pathText == null) {
            dismissBtn.setText("Cancel");
        } else {
            dismissBtn.setText("Dismiss");
        }
        dismissBtn.setHorizontalAlignment(4);
        dismissBtn.setFont(new Font("Dialog", 0, 12));
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropListDialog.this.dismissBtnActionPerformed(evt);
            }
        });
        jPanel1.add(dismissBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.jList.setFont(new Font("Courier", 1, 12));
        jScrollPane1.setPreferredSize(new Dimension(450, 300));
        jScrollPane1.setMinimumSize(new Dimension(450, 300));
        jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)jScrollPane1, "Center");
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        this.retrieveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.retrieveSelectedItem();
        }
    }

    private void retrieveSelectedItem() {
        this.selectedItem = this.jList.getSelectedValue();
        if (this.pathText != null) {
            this.pathText.append(this.selectedItem + "\n");
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        this.setList();
        Point p = this.parent.getLocationOnScreen();
        p.x += (this.parent.getWidth() - this.getWidth()) / 2 + 50;
        p.y += (this.parent.getHeight() - this.getHeight()) / 2 + 50;
        this.setLocation(p);
        this.setVisible(true);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

