/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.MkStarter;
import admin.astor.PropListDialog;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NewStarterDialog
extends JDialog
implements AstorDefs {
    private Astor parent;
    private TangoHost[] hosts;
    private TangoHost host;
    private List<String> collections;
    private int retVal = 2;
    private boolean creating;
    private JButton createBtn;
    private JButton familyBtn;
    private JTextField familyText;
    private JTextField hostText;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JTextArea pathText;
    private JLabel titleLbl;
    private JTextField usageText;
    private JRadioButton useEventsBtn;

    private boolean getUseEvents() {
        boolean ue = false;
        try {
            DbDatum data = this.host.get_property("UseEvents");
            if (!data.is_empty()) {
                ue = data.extractBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ue;
    }

    public NewStarterDialog(Astor parent, TangoHost host, List<String> collectionList, TangoHost[] hosts, boolean creating) {
        super((Frame)parent, true);
        this.parent = parent;
        this.hosts = hosts;
        this.creating = creating;
        this.collections = new ArrayList<String>();
        for (int i = 1; i < collectionList.size(); ++i) {
            this.collections.add(collectionList.get(i));
        }
        this.initComponents();
        this.host = host;
        if (host != null) {
            String[] ds_path;
            String hostname = host.getName();
            for (String path : ds_path = host.getPath()) {
                this.pathText.append(path + "\n");
            }
            this.usageText.setText(host.usage);
            this.familyText.setText(host.getFamily());
            this.hostText.setText(hostname);
            this.useEventsBtn.setSelected(this.getUseEvents());
            if (creating) {
                this.familyText.setText(host.getFamily());
                this.hostText.setText(hostname);
                this.hostText.select(0, hostname.length());
            } else {
                this.titleLbl.setText("Change property for " + hostname + " starter in database");
                this.jLabel2.setText("  ");
                this.hostText.setVisible(false);
                this.jLabel4.setVisible(false);
                this.familyText.setVisible(false);
                this.familyBtn.setVisible(false);
                this.createBtn.setText("Apply");
            }
        }
        this.pack();
        AstorUtil.centerDialog((JDialog)this, parent);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLbl = new JLabel();
        JPanel centerPanel = new JPanel();
        this.jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.hostText = new JTextField();
        this.jLabel2 = new JLabel();
        this.familyText = new JTextField();
        JButton pathBtn = new JButton();
        this.familyBtn = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.pathText = new JTextArea();
        JLabel jLabel8 = new JLabel();
        this.usageText = new JTextField();
        this.useEventsBtn = new JRadioButton();
        JPanel bottomPanel = new JPanel();
        this.createBtn = new JButton();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewStarterDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.titleLbl.setFont(new Font("Dialog", 1, 14));
        this.titleLbl.setText("Create a Starter in Database For a New Host");
        topPanel.add(this.titleLbl);
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new GridBagLayout());
        this.jLabel4.setText("Host name :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        centerPanel.add((Component)this.jLabel4, gridBagConstraints);
        jLabel5.setText("Device Servers PATH :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        centerPanel.add((Component)jLabel5, gridBagConstraints);
        this.hostText.setColumns(20);
        this.hostText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.hostTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)this.hostText, gridBagConstraints);
        this.jLabel2.setText("Host Family:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        centerPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.familyText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)this.familyText, gridBagConstraints);
        pathBtn.setText("...");
        pathBtn.setMargin(new Insets(2, 5, 2, 5));
        pathBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.pathBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        centerPanel.add((Component)pathBtn, gridBagConstraints);
        this.familyBtn.setText("...");
        this.familyBtn.setMargin(new Insets(2, 5, 2, 5));
        this.familyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.familyBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        centerPanel.add((Component)this.familyBtn, gridBagConstraints);
        jScrollPane1.setPreferredSize(new Dimension(300, 180));
        jScrollPane1.setViewportView(this.pathText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)jScrollPane1, gridBagConstraints);
        jLabel8.setText("Host Usage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        centerPanel.add((Component)jLabel8, gridBagConstraints);
        this.usageText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        centerPanel.add((Component)this.usageText, gridBagConstraints);
        this.useEventsBtn.setText("Manage notifd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        centerPanel.add((Component)this.useEventsBtn, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        this.createBtn.setText("Create");
        this.createBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.createBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(this.createBtn);
        jLabel1.setText("          ");
        bottomPanel.add(jLabel1);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStarterDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void hostTextActionPerformed(ActionEvent evt) {
    }

    private void familyBtnActionPerformed(ActionEvent evt) {
        PropListDialog list = new PropListDialog((JFrame)this.parent, this.collections);
        list.showDialog();
        String family = list.getSelectedItem();
        if (family != null) {
            this.familyText.setText(family);
        }
    }

    private void pathBtnActionPerformed(ActionEvent evt) {
        new PropListDialog(this.parent, this.pathText, this.hosts).showDialog();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void createBtnActionPerformed(ActionEvent evt) {
        try {
            String message;
            String hostName = this.hostText.getText();
            String usage = this.usageText.getText();
            String family = this.familyText.getText();
            String str_ds_path = this.pathText.getText().trim();
            if (hostName.length() == 0 || str_ds_path.length() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Fill the fields before creation !", "Warning", 2);
                return;
            }
            String[] ds_path = AstorUtil.string2StringArray(str_ds_path);
            boolean use_events = this.useEventsBtn.getSelectedObjects() != null;
            MkStarter starter = new MkStarter(hostName, ds_path, use_events);
            if (this.creating) {
                starter.create();
            }
            starter.setProperties();
            starter.setAdditionalProperties("HostUsage", usage, this.creating);
            starter.setAdditionalProperties("HostCollection", family, this.creating);
            if (this.host != null && !this.creating && !usage.equals(this.host.usage)) {
                this.host.usage = usage;
                Astor astor = this.parent;
                astor.tree.changeHostNode(this.host);
            }
            if (this.creating) {
                message = "A Starter server has been created in TANGO database.\n\nYou can now start it on " + hostName + " machine.";
            } else {
                message = "The property has been modified in database";
                try {
                    String deviceName = AstorUtil.getStarterDeviceHeader() + hostName;
                    new DeviceProxy(deviceName).command_inout("Init");
                    message = message + "\nand the device has been re-initialized.";
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(this.parent, message, "Command Done", 1);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    int getValue() {
        return this.retVal;
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

