/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.TangoServer;
import admin.astor.tools.PollingProfiler;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ManagePollingDialog
extends JDialog
implements TangoConst {
    private Component parent;
    private String[] commands;
    private String[] attributes;
    private TangoServer server;
    private JRadioButton attrBtn;
    private JComboBox<String> cmdBox;
    private JRadioButton cmdBtn;
    private JLabel cmdLabel;
    private JComboBox<String> devicesBox;
    private JTextArea textArea;

    private void setCmdAttrBox() {
        String[] strArray;
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.cmdLabel.setText("Command Selection");
            strArray = this.commands;
        } else {
            this.cmdLabel.setText("Attribute Selection");
            strArray = this.attributes;
        }
        this.cmdBox.removeAllItems();
        for (String str : strArray) {
            this.cmdBox.addItem(str);
        }
        this.pack();
    }

    private void initComponentsFromDevices() {
        try {
            String[] devices;
            for (String device : devices = this.server.queryDevice()) {
                this.devicesBox.addItem(device);
            }
            this.devicesBox.addItem("*");
            this.devicesBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ManagePollingDialog.this.devSelectionActionPerformed(evt);
                }
            });
            this.cmdBtn.setSelected(false);
            this.attrBtn.setSelected(true);
            this.getAttrCmdLists(devices[0]);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void getAttrCmdLists(String devname) {
        try {
            DeviceProxy dev = new DeviceProxy(devname);
            CommandInfo[] cmd_list = dev.command_list_query();
            int nb = 0;
            for (CommandInfo cmd : cmd_list) {
                if (cmd.in_type != 0 || cmd.cmd_name.equals("Init")) continue;
                ++nb;
            }
            this.commands = new String[nb];
            int j = 0;
            for (int i = 0; i < cmd_list.length; ++i) {
                if (cmd_list[i].in_type != 0 || cmd_list[i].cmd_name.equals("Init")) continue;
                this.commands[j++] = cmd_list[i].cmd_name;
            }
            this.attributes = dev.get_attribute_list();
            this.setCmdAttrBox();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void devSelectionActionPerformed(ActionEvent evt) {
        String devname = this.devicesBox.getSelectedItem().toString();
        if (!devname.equals("*")) {
            this.getAttrCmdLists(devname);
        }
    }

    public ManagePollingDialog(JDialog parent, TangoServer server) {
        super((Dialog)parent, false);
        this.server = server;
        this.parent = parent;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.displayStatus();
        this.pack();
    }

    public ManagePollingDialog(JFrame parent, String devname, String attname) throws DevFailed {
        super((Frame)parent, false);
        this.server = new TangoServer(new DeviceProxy(devname).adm_name());
        this.parent = parent;
        this.setTitle("Device Polling Management Window");
        this.initComponents();
        this.initComponentsFromDevices();
        this.devicesBox.setSelectedItem(devname);
        this.cmdBox.setSelectedItem(attname);
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.displayStatus();
        this.pack();
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        JButton updateBtn = new JButton();
        JLabel jLabel8 = new JLabel();
        JButton profilerBtn = new JButton();
        JLabel jLabel9 = new JLabel();
        JButton dismissBtn = new JButton();
        JPanel jPanel3 = new JPanel();
        this.devicesBox = new JComboBox();
        this.cmdBox = new JComboBox();
        JLabel jLabel2 = new JLabel();
        this.cmdLabel = new JLabel();
        JButton addBtn = new JButton();
        JLabel jLabel3 = new JLabel();
        JButton removeBtn = new JButton();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.cmdBtn = new JRadioButton();
        this.attrBtn = new JRadioButton();
        JLabel jLabel7 = new JLabel();
        JScrollPane textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ManagePollingDialog.this.closeDialog(evt);
            }
        });
        updateBtn.setText("Update Status");
        updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.updateBtnActionPerformed(evt);
            }
        });
        jPanel2.add(updateBtn);
        jLabel8.setText("        ");
        jPanel2.add(jLabel8);
        profilerBtn.setText("Show Profiler");
        profilerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.profilerBtnActionPerformed(evt);
            }
        });
        jPanel2.add(profilerBtn);
        jLabel9.setText("        ");
        jPanel2.add(jLabel9);
        dismissBtn.setText("Dismiss");
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.dismissBtnActionPerformed(evt);
            }
        });
        jPanel2.add(dismissBtn);
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel3.setLayout(new GridBagLayout());
        this.devicesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.devicesBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        jPanel3.add(this.devicesBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel3.add(this.cmdBox, gridBagConstraints);
        jLabel2.setText("Device Selection");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        this.cmdLabel.setText("command :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)this.cmdLabel, gridBagConstraints);
        addBtn.setText("Add / Update");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.addBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)addBtn, gridBagConstraints);
        jLabel3.setFont(new Font("Dialog", 0, 36));
        jLabel3.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        removeBtn.setText("Remove");
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)removeBtn, gridBagConstraints);
        jLabel4.setFont(new Font("Dialog", 0, 36));
        jLabel4.setText("  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        jPanel3.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        jPanel3.add((Component)jLabel6, gridBagConstraints);
        jPanel1.setLayout(new GridBagLayout());
        jLabel1.setText("Polling  on   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel1.add((Component)jLabel1, gridBagConstraints);
        this.cmdBtn.setText("Command");
        this.cmdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.cmdBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel1.add((Component)this.cmdBtn, gridBagConstraints);
        this.attrBtn.setText("Attribute");
        this.attrBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManagePollingDialog.this.attrBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel1.add((Component)this.attrBtn, gridBagConstraints);
        jLabel7.setText("   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel1.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)jPanel3, "West");
        textScrollPane.setPreferredSize(new Dimension(450, 400));
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier New", 1, 12));
        textScrollPane.setViewportView(this.textArea);
        this.getContentPane().add((Component)textScrollPane, "Center");
        this.pack();
    }

    private void profilerBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        if (this.parent instanceof JFrame) {
            new PollingProfiler((JFrame)this.parent, devnames).setVisible(true);
        } else {
            new PollingProfiler((JDialog)this.parent, devnames).setVisible(true);
        }
    }

    private String[] selectedDevices() {
        String[] names;
        String item = this.devicesBox.getSelectedItem().toString();
        if (item.equals("*")) {
            int nb = this.devicesBox.getItemCount() - 1;
            names = new String[nb];
            for (int i = 0; i < nb; ++i) {
                names[i] = this.devicesBox.getItemAt(i);
            }
        } else {
            names = new String[]{item};
        }
        return names;
    }

    private void displayStatus() {
        String[] devnames = this.selectedDevices();
        String message = "        Polling Status\n\n";
        for (String devname : devnames) {
            try {
                message = message + "=============================================\n";
                message = message + devname + " :\n\n";
                DeviceProxy dev = new DeviceProxy(devname);
                String[] status = dev.polling_status();
                for (int st = 0; st < status.length; ++st) {
                    message = message + status[st] + "\n";
                    if (st >= status.length - 1) continue;
                    message = message + "   ---------------------------------\n";
                }
                if (status.length <= 0) continue;
                message = message + "\n\n";
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                return;
            }
        }
        this.textArea.setText(message);
        this.textArea.setCaretPosition(0);
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        String polled_obj_name = this.cmdBox.getSelectedItem().toString();
        String message = "Remove polling on " + polled_obj_name + " for:\n";
        for (String devname : devnames) {
            message = message + devname + ",  ";
        }
        if (JOptionPane.showConfirmDialog(this, message, "Question ?", 0) == 0) {
            message = polled_obj_name + " polling has been removed for:\n";
            for (String devname : devnames) {
                try {
                    DeviceProxy dev = new DeviceProxy(devname);
                    if (this.cmdBtn.getSelectedObjects() != null) {
                        dev.stop_poll_command(polled_obj_name);
                    } else {
                        dev.stop_poll_attribute(polled_obj_name);
                    }
                    message = message + devname + "\n";
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
                    return;
                }
            }
            Utils.popupMessage(this, message);
            this.displayStatus();
        }
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        String[] devnames = this.selectedDevices();
        boolean ok = false;
        String strval = "";
        int polling_period = 0;
        while (!ok) {
            if ((strval = (String)JOptionPane.showInputDialog(this, "Polling period (ms)  ?", "Polling period", 1, null, null, strval)) == null) {
                return;
            }
            try {
                polling_period = Integer.parseInt(strval);
                if (polling_period < 20) {
                    Utils.popupError(this, "The polling period minimum value is 20ms");
                    continue;
                }
                ok = true;
            }
            catch (NumberFormatException e) {
                Utils.popupError(this, e.toString() + "\n\nBad Value in Polling period field !");
            }
        }
        String polled_obj_name = this.cmdBox.getSelectedItem().toString();
        StringBuilder message = new StringBuilder(polled_obj_name + " polling has been added for:\n");
        for (String devname : devnames) {
            try {
                DeviceProxy dev = new DeviceProxy(devname);
                if (this.cmdBtn.getSelectedObjects() != null) {
                    dev.poll_command(polled_obj_name, polling_period);
                } else {
                    dev.poll_attribute(polled_obj_name, polling_period);
                }
                message.append(devname).append('\n');
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
        Utils.popupMessage(this, message.toString());
        this.displayStatus();
    }

    private void attrBtnActionPerformed(ActionEvent evt) {
        if (this.attrBtn.getSelectedObjects() != null) {
            this.cmdBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void cmdBtnActionPerformed(ActionEvent evt) {
        if (this.cmdBtn.getSelectedObjects() != null) {
            this.attrBtn.setSelected(false);
        }
        this.setCmdAttrBox();
    }

    private void devicesBoxActionPerformed(ActionEvent evt) {
        this.displayStatus();
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        this.displayStatus();
    }

    private void dismissBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

