/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import java.util.Date;
import javax.swing.SwingUtilities;

public class HostStateThread
extends Thread
implements AstorDefs {
    private AstorTree parent;
    private TangoHost host;
    private int readInfoPeriod;
    boolean stop_it = false;
    private String[] attributes = new String[]{"State", "NotifdState"};
    private static final int StateAtt = 0;
    private static final int NotifdAtt = 1;
    private DevState previous_state = DevState.UNKNOWN;
    private int timeout = -1;
    private static String[] filters = new String[0];
    private StateEventListener state_listener = null;

    public HostStateThread(TangoHost host) {
        this(null, host);
    }

    public HostStateThread(AstorTree parent, TangoHost host) {
        this.parent = parent;
        this.host = host;
        host.thread = this;
        this.readInfoPeriod = AstorUtil.getStarterReadPeriod() / 2;
    }

    public synchronized void updateData() {
        this.notify();
    }

    @Override
    public void run() {
        if (this.parent == null && this.host.onEvents) {
            this.subscribeChangeStateEvent();
        }
        long t0 = System.currentTimeMillis();
        while (!this.stop_it) {
            long t = System.currentTimeMillis();
            if (!this.host.onEvents) {
                this.manageSynchronousAttributes();
            } else if (t - t0 > 60000L) {
                this.manageSynchronousAttributes();
                t0 = t;
            }
            this.wait_next_loop(t);
        }
    }

    public synchronized void wait_next_loop(long t0) {
        try {
            long t1 = System.currentTimeMillis();
            long time_to_sleep = (long)this.readInfoPeriod - (t1 - t0);
            if (time_to_sleep <= 0L) {
                time_to_sleep = 100L;
            }
            this.wait(time_to_sleep);
        }
        catch (InterruptedException e) {
            System.out.println(e.toString());
        }
    }

    public void updateHost(final DevState state) {
        if (state == this.previous_state) {
            return;
        }
        this.previous_state = state;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (state.value()) {
                    case 0: {
                        ((HostStateThread)HostStateThread.this).host.state = 0;
                        break;
                    }
                    case 6: {
                        ((HostStateThread)HostStateThread.this).host.state = 1;
                        break;
                    }
                    case 7: {
                        ((HostStateThread)HostStateThread.this).host.state = 2;
                        break;
                    }
                    case 11: {
                        ((HostStateThread)HostStateThread.this).host.state = 3;
                        break;
                    }
                    case 1: {
                        ((HostStateThread)HostStateThread.this).host.state = 4;
                        break;
                    }
                    case 8: {
                        ((HostStateThread)HostStateThread.this).host.state = 5;
                        break;
                    }
                    default: {
                        ((HostStateThread)HostStateThread.this).host.state = 6;
                    }
                }
                if (HostStateThread.this.parent != null) {
                    HostStateThread.this.parent.updateState();
                }
                if (((HostStateThread)HostStateThread.this).host.info_dialog != null) {
                    ((HostStateThread)HostStateThread.this).host.info_dialog.updateHostState();
                }
            }
        });
    }

    public void updateNotifdHost(final DevState notifd_state) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int notifyd_state = 6;
                if (notifd_state == DevState.ON) {
                    notifyd_state = 0;
                } else if (notifd_state == DevState.FAULT) {
                    notifyd_state = 5;
                }
                if (((HostStateThread)HostStateThread.this).host.notifydState == notifyd_state) {
                    return;
                }
                ((HostStateThread)HostStateThread.this).host.notifydState = notifyd_state;
                if (HostStateThread.this.parent != null) {
                    HostStateThread.this.parent.updateState();
                } else {
                    ((HostStateThread)HostStateThread.this).host.notifydState = notifyd_state;
                }
                if (((HostStateThread)HostStateThread.this).host.info_dialog != null) {
                    ((HostStateThread)HostStateThread.this).host.info_dialog.updateHostState();
                }
            }
        });
    }

    public void manageSynchronousAttributes() {
        DevState notifdState;
        DevState hostState;
        try {
            if (this.timeout < 0) {
                this.timeout = this.host.get_timeout_millis();
            }
            this.host.set_timeout_millis(1000);
            DeviceAttribute[] att = this.host.read_attribute(this.attributes);
            hostState = att[0].hasFailed() ? DevState.FAULT : att[0].extractState();
            notifdState = att[1].hasFailed() ? DevState.UNKNOWN : att[1].extractState();
        }
        catch (DevFailed e) {
            this.host.except = e;
            notifdState = DevState.UNKNOWN;
            hostState = DevState.FAULT;
        }
        try {
            this.host.set_timeout_millis(this.timeout);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.updateHost(hostState);
        if (this.host.manageNotifd) {
            this.updateNotifdHost(notifdState);
        }
    }

    public void subscribeChangeStateEvent() {
        String stringError = null;
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
            if (this.state_listener == null) {
                this.state_listener = new StateEventListener();
                this.host.supplier.addTangoChangeListener((ITangoChangeListener)this.state_listener, this.attributes[0], filters);
            }
        }
        catch (DevFailed e) {
            this.state_listener = null;
            this.host.onEvents = false;
            if (!e.errors[0].desc.startsWith("Already connected to event")) {
                stringError = "subscribeChangeStateEvent() for " + this.host.get_name() + " FAILED !\n" + e.errors[0].desc;
            }
        }
        catch (Exception e) {
            this.state_listener = null;
            this.host.onEvents = false;
            stringError = "subscribeChangeStateEvent() for " + this.host.get_name() + " FAILED !" + e.toString();
            e.printStackTrace();
        }
        if (this.parent != null) {
            this.parent.updateMonitor(stringError);
        }
    }

    class StateEventListener
    implements ITangoChangeListener {
        StateEventListener() {
        }

        public void change(TangoChangeEvent event) {
            DevState hostState;
            try {
                ((HostStateThread)HostStateThread.this).host.eventSource = event.isZmqEvent() ? "(ZMQ)" : "(notifd)";
            }
            catch (NoSuchMethodError e) {
                ((HostStateThread)HostStateThread.this).host.eventSource = "(notifd)";
            }
            TangoChange tc = (TangoChange)event.getSource();
            String deviceName = tc.getEventSupplier().get_name();
            int timeout = -1;
            try {
                DeviceAttribute attr = event.getValue();
                hostState = attr.hasFailed() ? DevState.UNKNOWN : attr.extractState();
            }
            catch (DevFailed e) {
                System.err.println(new Date());
                System.err.println(HostStateThread.this.host.name() + "  has received a DevFailed :\t" + e.errors[0].desc);
                hostState = DevState.ALARM;
                System.err.println("HostStateThread.StateEventListener on " + deviceName);
                try {
                    timeout = HostStateThread.this.host.get_timeout_millis();
                    HostStateThread.this.host.set_timeout_millis(500);
                    HostStateThread.this.host.ping();
                }
                catch (DevFailed e2) {
                    hostState = DevState.FAULT;
                }
            }
            catch (Exception e) {
                System.out.println("AstorEvent." + deviceName);
                System.out.println(e.toString());
                System.out.println("HostStateThread.StateEventListener : could not extract data!");
                hostState = DevState.UNKNOWN;
            }
            try {
                if (timeout > 0) {
                    HostStateThread.this.host.set_timeout_millis(timeout);
                }
            }
            catch (DevFailed e) {
                System.err.println(e.errors[0].desc);
            }
            if (((HostStateThread)HostStateThread.this).host.manageNotifd) {
                DevState notifdState;
                try {
                    DeviceAttribute att_synch = HostStateThread.this.host.read_attribute(HostStateThread.this.attributes[1]);
                    notifdState = att_synch.hasFailed() ? DevState.UNKNOWN : att_synch.extractState();
                }
                catch (Exception e) {
                    notifdState = DevState.UNKNOWN;
                }
                HostStateThread.this.updateNotifdHost(notifdState);
            }
            HostStateThread.this.updateHost(hostState);
        }
    }
}

